/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.wkb;

import java.io.Serializable;

abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = 256L;
    static final int LINEARRING = 0;
    static final int POINT = 1;
    static final int LINESTRING = 2;
    static final int POLYGON = 3;
    static final int MULTIPOINT = 4;
    static final int MULTILINESTRING = 5;
    static final int MULTIPOLYGON = 6;
    static final int GEOMETRYCOLLECTION = 7;
    static final String[] ALLTYPES = new String[]{"", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    int dimension;
    boolean haveMeasure = false;
    final int type;
    static final int UNKNOWN_SRID = 0;
    int srid = 0;

    static String getTypeString(int type) {
        if (type >= 0 && type <= 7) {
            return ALLTYPES[type];
        }
        throw new IllegalArgumentException("Unknown Geometry type" + type);
    }

    static int parseSRID(int srid) {
        if (srid < 0) {
            return 0;
        }
        return srid;
    }

    protected Geometry(int type) {
        this.type = type;
    }

    public int hashCode() {
        return this.dimension | this.type * 4 | this.srid * 32;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Geometry && this.equals((Geometry)other);
    }

    public boolean equals(Geometry other) {
        return other != null && this.dimension == other.dimension && this.type == other.type && this.srid == other.srid && this.haveMeasure == other.haveMeasure && other.getClass().equals(this.getClass()) && this.equalsintern(other);
    }

    protected abstract boolean equalsintern(Geometry var1);

    abstract int numPoints();

    int getType() {
        return this.type;
    }

    String getTypeString() {
        return Geometry.getTypeString(this.type);
    }

    boolean isMeasured() {
        return this.haveMeasure;
    }

    int getDimension() {
        return this.dimension;
    }

    int getSrid() {
        return this.srid;
    }

    void setSrid(int srid) {
        this.srid = srid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.srid != 0) {
            sb.append("SRID=");
            sb.append(this.srid);
            sb.append(';');
        }
        this.outerWKT(sb, true);
        return sb.toString();
    }

    void outerWKT(StringBuffer sb, boolean putM) {
        sb.append(this.getTypeString());
        if (putM && this.haveMeasure && this.dimension == 2) {
            sb.append('M');
        }
        this.mediumWKT(sb);
    }

    final void outerWKT(StringBuffer sb) {
        this.outerWKT(sb, true);
    }

    protected void mediumWKT(StringBuffer sb) {
        sb.append('(');
        this.innerWKT(sb);
        sb.append(')');
    }

    protected abstract void innerWKT(StringBuffer var1);

    String getValue() {
        StringBuffer sb = new StringBuffer();
        this.mediumWKT(sb);
        return sb.toString();
    }

    boolean checkConsistency() {
        return this.dimension >= 2 && this.dimension <= 3 && this.type >= 0 && this.type <= 7;
    }

    protected String initSRID(String value) {
        String v = value.trim();
        if (v.startsWith("SRID=")) {
            int index = v.indexOf(59, 5);
            if (index == -1) {
                throw new IllegalArgumentException("Error parsing Geometry - SRID not delimited with ';' ");
            }
            this.srid = Integer.parseInt(v.substring(5, index));
            return v.substring(index + 1).trim();
        }
        return v;
    }
}

