/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.poi3d;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.oscim.core.Box;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.gdx.GdxAssets;
import org.oscim.gdx.poi3d.GdxRenderer3D;
import org.oscim.gdx.poi3d.GdxRenderer3D2;
import org.oscim.gdx.poi3d.ModelHolder;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileSet;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.model.VtmModels;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.geom.TileClipper;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Poi3DLayer
extends Layer
implements Map.UpdateListener,
ZoomLimiter.IZoomLimiter {
    private static final Logger log = LoggerFactory.getLogger(Poi3DLayer.class);
    public static final int MIN_ZOOM = 17;
    static final String POI_DATA = Poi3DLayer.class.getSimpleName();
    public static final boolean RANDOM_TRANSFORM = true;
    public static final Tag TAG_TREE = new Tag("natural", "tree");
    public static final Tag TAG_MEMORIAL = new Tag("historic", "memorial");
    public static final Tag TAG_FOREST = new Tag("landuse", "forest");
    public static final Tag TAG_WOOD = new Tag("natural", "wood");
    public static final Tag TAG_ARTWORK = new Tag("tourism", "artwork");
    public static final Tag TAG_TREE_BROADLEAVED = new Tag("leaf_type", "broadleaved");
    public static final Tag TAG_TREE_NEEDLELEAVED = new Tag("leaf_type", "needleleaved");
    public static final Tag TAG_TREE_ROW = new Tag("natural", "tree_row");
    public static final Tag TAG_STREETLAMP = new Tag("highway", "street_lamp");
    public static float MODEL_DISTANCE = 8.0f;
    AssetManager mAssets;
    GdxRenderer3D2 mG3d;
    Set<Tag> mHideThemeRenders = new HashSet<Tag>();
    boolean mLoading;
    LinkedHashMap<Tag, List<ModelHolder>> mScenes = new LinkedHashMap();
    TileClipper mTileClipper = new TileClipper(0.0f, 0.0f, (float)Tile.SIZE, (float)Tile.SIZE);
    VectorTileLayer mTileLayer;
    LinkedHashMap<Tile, Array<ModelInstance>> mTileMap = new LinkedHashMap();
    TileSet mTileSet = new TileSet();
    TileSet mPrevTiles = new TileSet();
    final ZoomLimiter mZoomLimiter;

    public Poi3DLayer(Map map, VectorTileLayer tileLayer) {
        this(map, tileLayer, true);
    }

    public Poi3DLayer(Map map, VectorTileLayer tileLayer, boolean useDefaults) {
        super(map);
        tileLayer.addHook(new VectorTileLayer.TileLoaderProcessHook(){

            public boolean process(MapTile tile, RenderBuckets buckets, MapElement element) {
                if (tile.zoomLevel < Poi3DLayer.this.mZoomLimiter.getMinZoom()) {
                    return false;
                }
                Poi3DTileData td = Poi3DLayer.this.get(tile);
                for (Map.Entry<Tag, List<ModelHolder>> scene : Poi3DLayer.this.mScenes.entrySet()) {
                    int pointCount;
                    float[] points;
                    if (!element.tags.contains(scene.getKey())) continue;
                    List<ModelHolder> holders = scene.getValue();
                    if (element.isPoly() || element.isLine()) {
                        GeometryBuffer geom = new GeometryBuffer((GeometryBuffer)element);
                        Poi3DLayer.this.mTileClipper.clip(geom);
                        points = geom.points;
                        pointCount = element.getNumPoints() * 2;
                        if (pointCount < 4) {
                            return false;
                        }
                        double scale = MercatorProjection.zoomLevelToScale((byte)tile.zoomLevel);
                        double lat = MercatorProjection.tileYToLatitudeWithScale((long)tile.tileY, (double)scale);
                        double modelDistPix = MercatorProjection.metersToPixelsWithScale((float)MODEL_DISTANCE, (double)lat, (double)scale);
                        ArrayList<Float> polyPoints = new ArrayList<Float>();
                        float variation = (float)modelDistPix / 16.0f;
                        if (geom.isPoly()) {
                            Box box = new Box();
                            box.setExtents(points, pointCount);
                            double pixelsX = Tile.SIZE * tile.tileX;
                            double pixelsY = Tile.SIZE * tile.tileY;
                            box.xmin += (pixelsX + box.xmin) % modelDistPix;
                            box.ymin += (pixelsY + box.ymin) % modelDistPix;
                            while (box.xmin < box.xmax) {
                                for (double tmpY = box.ymin; tmpY < box.ymax; tmpY += modelDistPix) {
                                    float x = (float)box.xmin;
                                    float y = (float)tmpY;
                                    int hashX = Poi3DLayer.this.getPosXHash((Tile)tile, x);
                                    int hashY = Poi3DLayer.this.getPosYHash((Tile)tile, y);
                                    int hash = hashY * hashX;
                                    if (!GeometryUtils.pointInPoly((float)(x += (float)((hash + hashX) % 14 - 7) * variation), (float)(y += (float)((hash + hashY) % 14 - 7) * variation), (float[])points, (int)pointCount, (int)0)) continue;
                                    polyPoints.add(Float.valueOf(x));
                                    polyPoints.add(Float.valueOf(y));
                                }
                                box.xmin += modelDistPix;
                            }
                        } else {
                            float[] p1 = new float[]{points[0], points[1]};
                            float[] p2 = new float[2];
                            float sumDist = 0.0f;
                            for (int i = 2; i < pointCount; i += 2) {
                                p2[0] = points[i];
                                p2[1] = points[i + 1];
                                float dist = (float)GeometryUtils.distance2D((float[])p1, (float[])p2);
                                float[] vec = GeometryUtils.scale((float[])GeometryUtils.diffVec((float[])p2, (float[])p1), (float)(1.0f / dist));
                                while (sumDist < dist) {
                                    float[] tmp = GeometryUtils.scale((float[])vec, (float)sumDist);
                                    polyPoints.add(Float.valueOf(p1[0] + tmp[0]));
                                    polyPoints.add(Float.valueOf(p1[1] + tmp[1]));
                                    sumDist = (float)((double)sumDist + modelDistPix);
                                }
                                sumDist -= dist;
                                p1[0] = p2[0];
                                p1[1] = p2[1];
                            }
                        }
                        points = new float[polyPoints.size()];
                        for (int i = 0; i < polyPoints.size(); ++i) {
                            points[i] = ((Float)polyPoints.get(i)).floatValue();
                        }
                        pointCount = points.length;
                    } else {
                        pointCount = element.getNumPoints() * 2;
                        points = element.points;
                    }
                    for (int i = 0; i < pointCount; i += 2) {
                        ModelHolder holder;
                        SymbolItem s = (SymbolItem)SymbolItem.pool.get();
                        s.x = points[i];
                        s.y = points[i + 1];
                        if (holders.size() > 1) {
                            int random = Poi3DLayer.this.getPosHash((Tile)tile, s) % holders.size();
                            holder = holders.get(random);
                        } else {
                            holder = holders.get(0);
                        }
                        Inlist.List symbolItems = td.symbols.get(holder);
                        if (symbolItems == null) {
                            symbolItems = new Inlist.List();
                            td.symbols.put(holder, (Inlist.List<SymbolItem>)symbolItems);
                        }
                        symbolItems.push((Inlist)s);
                    }
                    return Poi3DLayer.this.mHideThemeRenders.contains(scene.getKey());
                }
                return false;
            }

            public void complete(MapTile tile, boolean success) {
            }
        });
        this.mTileLayer = tileLayer;
        this.mZoomLimiter = new ZoomLimiter(tileLayer.getManager(), 17, map.viewport().getMaxZoomLevel(), 17);
        this.mG3d = new GdxRenderer3D2(this.mMap);
        this.mRenderer = this.mG3d;
        this.mAssets = new AssetManager();
        if (useDefaults) {
            this.useDefaults();
        }
    }

    public void addModel(VtmModels model, Tag tag) {
        this.addModel(GdxAssets.getAssetPath((String)model.getPath()), tag);
    }

    public void addModel(String path, Tag tag) {
        List<ModelHolder> scene = this.mScenes.get(tag);
        if (scene == null) {
            scene = new ArrayList<ModelHolder>();
            this.mScenes.put(tag, scene);
        }
        scene.add(new ModelHolder(path));
        this.mAssets.load(path, Model.class);
        if (!this.mLoading) {
            this.mLoading = true;
        }
    }

    private void doneLoading() {
        for (List<ModelHolder> holders : this.mScenes.values()) {
            for (ModelHolder holder : holders) {
                Model model = (Model)this.mAssets.get(holder.getPath());
                for (Node node : model.nodes) {
                    log.debug("loader node " + node.id);
                    if (node.hasChildren() && this.mG3d instanceof GdxRenderer3D) {
                        if (model.nodes.size != 1) {
                            throw new RuntimeException("Model has more than one node with GdxRenderer: " + model.toString());
                        }
                        node = node.getChild(0);
                        log.debug("loader node " + node.id);
                        model.nodes.removeIndex(0);
                        model.nodes.add((Object)node);
                    }
                    node.scale.set(1.0f, 1.0f, -1.0f);
                    node.rotation.setFromAxis(1.0f, 0.0f, 0.0f, 90.0f);
                }
                model.calculateTransforms();
                holder.setModel(model);
            }
        }
        this.mLoading = false;
    }

    private Poi3DTileData get(MapTile tile) {
        Poi3DTileData ld = (Poi3DTileData)tile.getData((Object)POI_DATA);
        if (ld == null) {
            ld = new Poi3DTileData();
            tile.addData((Object)POI_DATA, (MapTile.TileData)ld);
        }
        return ld;
    }

    private int getPosHash(Tile tile, SymbolItem item) {
        int a = this.getPosXHash(tile, item.x);
        int b = this.getPosYHash(tile, item.y);
        return Math.abs(a * b);
    }

    private int getPosXHash(Tile tile, float x) {
        return (int)(((double)tile.tileX + (double)x / (double)Tile.SIZE) * 1.0E9 / (double)(1 << tile.zoomLevel)) * 37;
    }

    private int getPosYHash(Tile tile, float y) {
        return (int)(((double)tile.tileY + (double)y / (double)Tile.SIZE) * 1.0E9 / (double)(1 << tile.zoomLevel)) * 73;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMapEvent(Event ev, MapPosition pos) {
        Array<ModelInstance> instances;
        MapTile t;
        int i;
        int zoom;
        if (ev == Map.CLEAR_EVENT) {
            this.mTileSet = new TileSet();
            this.mPrevTiles = new TileSet();
            this.mTileMap = new LinkedHashMap();
            GdxRenderer3D2 gdxRenderer3D2 = this.mG3d;
            synchronized (gdxRenderer3D2) {
                this.mG3d.instances.clear();
            }
        }
        if (this.mLoading && this.mAssets.update()) {
            this.doneLoading();
        }
        if (this.mLoading) {
            return;
        }
        Integer tZoom = this.mTileLayer.tileRenderer().getVisibleTiles(this.mTileSet, true);
        if (this.mTileSet.cnt == 0 || tZoom == null) {
            this.mTileSet.releaseTiles();
            return;
        }
        if (tZoom > this.mZoomLimiter.getZoomLimit()) {
            HashSet<MapTile> hashTiles = new HashSet<MapTile>();
            for (int i2 = 0; i2 < this.mTileSet.cnt; ++i2) {
                MapTile t2 = this.mZoomLimiter.getTile(this.mTileSet.tiles[i2]);
                if (t2 == null) continue;
                hashTiles.add(t2);
            }
            this.mTileSet.cnt = hashTiles.size();
            if (this.mTileSet.cnt == 0) {
                return;
            }
            this.mTileSet.tiles = hashTiles.toArray(new MapTile[this.mTileSet.cnt]);
            zoom = this.mZoomLimiter.getZoomLimit();
        } else {
            zoom = tZoom;
        }
        boolean changed = false;
        Array added = new Array();
        Array removed = new Array();
        for (i = 0; i < this.mTileSet.cnt; ++i) {
            t = this.mTileSet.tiles[i];
            if (this.mPrevTiles.contains(t)) continue;
            instances = new Array<ModelInstance>();
            Poi3DTileData ld = (Poi3DTileData)t.getData((Object)POI_DATA);
            if (ld == null) continue;
            for (Map.Entry<ModelHolder, Inlist.List<SymbolItem>> entry : ld.symbols.entrySet()) {
                for (SymbolItem it : entry.getValue()) {
                    ModelInstance inst = new ModelInstance(entry.getKey().getModel());
                    inst.userData = it;
                    instances.add((Object)inst);
                    added.add((Object)inst);
                }
            }
            if (instances.size == 0) continue;
            log.debug("add " + t + " " + instances.size);
            changed = true;
            this.mTileMap.put((Tile)t, instances);
        }
        for (i = 0; i < this.mPrevTiles.cnt; ++i) {
            t = this.mPrevTiles.tiles[i];
            if (this.mTileSet.contains(t) || (instances = this.mTileMap.get(t)) == null) continue;
            changed = true;
            removed.addAll(instances);
            this.mTileMap.remove(t);
            log.debug("remove " + t);
        }
        this.mPrevTiles.releaseTiles();
        float groundScale = this.mTileSet.tiles[0].getGroundScale();
        TileSet tmp = this.mPrevTiles;
        this.mPrevTiles = this.mTileSet;
        this.mTileSet = tmp;
        if (!changed) {
            return;
        }
        float scale = 1.0f / groundScale;
        double tileX = pos.x * (double)(Tile.SIZE << zoom);
        double tileY = pos.y * (double)(Tile.SIZE << zoom);
        GdxRenderer3D2 gdxRenderer3D2 = this.mG3d;
        synchronized (gdxRenderer3D2) {
            for (Map.Entry<Tile, Array<ModelInstance>> e : this.mTileMap.entrySet()) {
                Tile t3 = e.getKey();
                float dx = (float)((double)(t3.tileX * Tile.SIZE) - tileX);
                float dy = (float)((double)(t3.tileY * Tile.SIZE) - tileY);
                for (ModelInstance inst : e.getValue()) {
                    SymbolItem it = (SymbolItem)inst.userData;
                    float s = scale;
                    float r = 0.0f;
                    float deviationStep = s * 0.1f;
                    int hash = this.getPosHash(t3, it);
                    r = hash % 360;
                    inst.transform.idt();
                    inst.transform.scale(s += (float)(hash % 4 - 2) * deviationStep, s, s);
                    inst.transform.translate((dx + it.x) / s, (dy + it.y) / s, 0.0f);
                    inst.transform.rotate(0.0f, 0.0f, 1.0f, r);
                }
            }
            this.mG3d.instances.removeAll(removed, true);
            this.mG3d.instances.addAll(added);
            this.mG3d.cam.setMapPosition(pos.x, pos.y, 1 << zoom);
        }
    }

    public void hideThemeRenders(Tag tag) {
        this.mHideThemeRenders.add(tag);
    }

    public void showThemeRenders(Tag tag) {
        this.mHideThemeRenders.remove(tag);
    }

    public void useDefaults() {
        this.addModel(VtmModels.MEMORIAL, TAG_ARTWORK);
        this.addModel(VtmModels.MEMORIAL, TAG_MEMORIAL);
        this.addModel(VtmModels.STREETLAMP, TAG_STREETLAMP);
        this.addModel(VtmModels.TREE_FIR, TAG_TREE_NEEDLELEAVED);
        this.addModel(VtmModels.TREE_OAK, TAG_TREE_BROADLEAVED);
        this.addModel(VtmModels.TREE_ASH, TAG_TREE);
        this.addModel(VtmModels.TREE_ASH, TAG_TREE_ROW);
        this.addModel(VtmModels.TREE_FIR, TAG_WOOD);
        this.addModel(VtmModels.TREE_OAK, TAG_WOOD);
        this.addModel(VtmModels.TREE_ASH, TAG_WOOD);
        this.addModel(VtmModels.TREE_OAK, TAG_FOREST);
        this.addModel(VtmModels.TREE_ASH, TAG_FOREST);
        this.addModel(VtmModels.TREE_FIR, TAG_FOREST);
        this.hideThemeRenders(TAG_STREETLAMP);
    }

    public void addZoomLimit() {
        this.mZoomLimiter.addZoomLimit();
    }

    public void removeZoomLimit() {
        this.mZoomLimiter.removeZoomLimit();
    }

    static class Poi3DTileData
    extends MapTile.TileData {
        public final HashMap<ModelHolder, Inlist.List<SymbolItem>> symbols = new HashMap();

        Poi3DTileData() {
        }

        protected void dispose() {
            for (Inlist.List<SymbolItem> symbolItems : this.symbols.values()) {
                SymbolItem.pool.releaseAll(symbolItems.clear());
            }
            this.symbols.clear();
        }
    }
}

