/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.poi3d;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.DefaultTextureBinder;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.TextureBinder;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.gdx.poi3d.MapCamera;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdxModelRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(GdxModelRenderer.class);
    ModelBatch modelBatch;
    public MapCamera cam;
    Map mMap;
    boolean loading;
    public Environment lights;
    public Array<ModelInstance> instances = new Array();
    public Shader shader;
    public RenderContext renderContext;
    public Model model;
    private ModelBatch mBatch = new ModelBatch();
    Vector3 tempVector = new Vector3();
    float[] mBox = new float[8];
    Renderable r = new Renderable();

    public GdxModelRenderer(Map map) {
        this.mMap = map;
    }

    public boolean setup() {
        this.modelBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider());
        this.lights = new Environment();
        this.lights.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f));
        this.lights.add(new DirectionalLight().set(0.3f, 0.3f, 0.3f, 0.0f, 1.0f, -0.2f));
        this.cam = new MapCamera(this.mMap);
        this.renderContext = new RenderContext((TextureBinder)new DefaultTextureBinder(1, 1));
        return true;
    }

    public synchronized void update(GLViewport v) {
        if (!this.isReady()) {
            this.cam.setPosition(v.pos);
            this.setReady(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GLViewport v) {
        if (this.instances.size == 0) {
            return;
        }
        GLAdapter.gl.depthMask(true);
        if (v.pos.zoomLevel < 16) {
            GLAdapter.gl.clear(256);
        }
        GLState.bindElementBuffer((int)0);
        GLState.bindBuffer((int)34962, (int)0);
        GLState.enableVertexArrays((int)-1, (int)-1);
        GLState.bindTex2D((int)-1);
        GLState.useProgram((int)-1);
        GLState.test((boolean)false, (boolean)false);
        GLState.blend((boolean)false);
        this.cam.update(v);
        ViewController p = this.mMap.viewport();
        p.getMapExtents(this.mBox, 10.0f);
        float scale = (float)(this.cam.mMapPosition.scale / v.pos.scale);
        float dx = (float)(this.cam.mMapPosition.x - v.pos.x) * (float)(Tile.SIZE << this.cam.mMapPosition.zoomLevel);
        float dy = (float)(this.cam.mMapPosition.y - v.pos.y) * (float)(Tile.SIZE << this.cam.mMapPosition.zoomLevel);
        for (int i = 0; i < 8; i += 2) {
            int n = i;
            this.mBox[n] = this.mBox[n] * scale;
            int n2 = i;
            this.mBox[n2] = this.mBox[n2] - dx;
            int n3 = i + 1;
            this.mBox[n3] = this.mBox[n3] * scale;
            int n4 = i + 1;
            this.mBox[n4] = this.mBox[n4] - dy;
        }
        GdxModelRenderer gdxModelRenderer = this;
        synchronized (gdxModelRenderer) {
            if (this.instances.size == 0) {
                return;
            }
            this.mBatch.begin((Camera)this.cam);
            for (ModelInstance instance : this.instances) {
                instance.transform.getTranslation(this.tempVector);
                this.mBatch.render((RenderableProvider)instance);
            }
            this.mBatch.end();
        }
        GLAdapter.gl.depthMask(false);
        GLState.bindElementBuffer((int)0);
        GLState.bindBuffer((int)34962, (int)0);
    }
}

