/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.poi3d;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.utils.Array;
import java.util.HashMap;
import java.util.Map;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.event.Event;
import org.oscim.gdx.GdxAssets;
import org.oscim.gdx.poi3d.GdxRenderer3D;
import org.oscim.gdx.poi3d.GdxRenderer3D2;
import org.oscim.gdx.poi3d.ModelHolder;
import org.oscim.gdx.poi3d.ModelPosition;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.model.VtmModels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdxModelLayer
extends Layer
implements Map.UpdateListener {
    private static final Logger log = LoggerFactory.getLogger(GdxModelLayer.class);
    private static final int MIN_ZOOM = 17;
    private Array<ModelInstance> mAdded = new Array();
    private AssetManager mAssets;
    private GdxRenderer3D2 mG3d;
    private boolean mLoading;
    private java.util.Map<ModelPosition, ModelHolder> mScenes = new HashMap<ModelPosition, ModelHolder>();

    public GdxModelLayer(Map map) {
        super(map);
        this.mG3d = new GdxRenderer3D2(this.mMap);
        this.mRenderer = this.mG3d;
        this.mAssets = new AssetManager();
    }

    public ModelPosition addModel(VtmModels model, double lat, double lon, float rotation) {
        return this.addModel(GdxAssets.getAssetPath((String)model.getPath()), lat, lon, rotation);
    }

    public ModelPosition addModel(String path, double lat, double lon, float rotation) {
        ModelPosition pos = new ModelPosition(lat, lon, rotation);
        this.mScenes.put(pos, new ModelHolder(path));
        this.mAssets.load(path, Model.class);
        if (!this.mLoading) {
            this.mLoading = true;
        }
        return pos;
    }

    private void doneLoading() {
        for (ModelHolder poiModel : this.mScenes.values()) {
            Model model = (Model)this.mAssets.get(poiModel.getPath());
            for (Node node : model.nodes) {
                log.debug("loader node " + node.id);
                if (node.hasChildren() && this.mG3d instanceof GdxRenderer3D) {
                    if (model.nodes.size != 1) {
                        throw new RuntimeException("Model has more than one node with GdxRenderer: " + model.toString());
                    }
                    node = node.getChild(0);
                    log.debug("loader node " + node.id);
                    model.nodes.removeIndex(0);
                    model.nodes.add((Object)node);
                }
                node.scale.set(1.0f, 1.0f, -1.0f);
                node.rotation.setFromAxis(1.0f, 0.0f, 0.0f, 90.0f);
            }
            model.calculateTransforms();
            poiModel.setModel(model);
        }
        this.mLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMapEvent(Event ev, MapPosition pos) {
        if (this.mLoading && this.mAssets.update()) {
            this.doneLoading();
            this.refreshModelInstances();
        }
        if (this.mLoading) {
            return;
        }
        double lat = MercatorProjection.toLatitude((double)pos.y);
        float groundscale = (float)MercatorProjection.groundResolutionWithScale((double)lat, (double)(1 << pos.zoomLevel));
        float scale = 1.0f / groundscale;
        GdxRenderer3D2 gdxRenderer3D2 = this.mG3d;
        synchronized (gdxRenderer3D2) {
            this.mG3d.instances.removeAll(this.mAdded, true);
            if (pos.getZoomLevel() >= 17) {
                this.mG3d.instances.addAll(this.mAdded);
            }
            for (ModelInstance inst : this.mAdded) {
                ModelPosition p = (ModelPosition)inst.userData;
                float dx = (float)((p.x - pos.x) * (double)(Tile.SIZE << pos.zoomLevel));
                float dy = (float)((p.y - pos.y) * (double)(Tile.SIZE << pos.zoomLevel));
                inst.transform.idt();
                inst.transform.scale(scale, scale, scale);
                inst.transform.translate(dx / scale, dy / scale, 0.0f);
                inst.transform.rotate(0.0f, 0.0f, 1.0f, p.getRotation());
            }
        }
        this.mG3d.cam.setMapPosition(pos.x, pos.y, 1 << pos.getZoomLevel());
    }

    public void refreshModelInstances() {
        for (Map.Entry<ModelPosition, ModelHolder> scene : this.mScenes.entrySet()) {
            this.mAdded.clear();
            this.mG3d.instances.clear();
            ModelInstance inst = new ModelInstance(scene.getValue().getModel());
            inst.userData = scene.getKey();
            this.mAdded.add((Object)inst);
            this.mG3d.instances.add((Object)inst);
        }
    }

    public void removeModel(ModelPosition position) {
        this.mScenes.remove(position);
        if (!this.mLoading) {
            this.refreshModelInstances();
        }
    }
}

