/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.poi3d;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.map.Map;
import org.oscim.renderer.GLViewport;

public class MapCamera
extends Camera {
    private final Map mMap;
    MapPosition mMapPosition = new MapPosition();

    public MapCamera(Map map) {
        this.mMap = map;
        this.near = 1.0f;
        this.far = 8.0f;
    }

    public void setPosition(MapPosition pos) {
        this.mMapPosition.copy(pos);
        this.viewportWidth = this.mMap.getWidth();
        this.viewportHeight = this.mMap.getHeight();
    }

    public void setMapPosition(double x, double y, double scale) {
        this.mMapPosition.setScale(scale);
        this.mMapPosition.x = x;
        this.mMapPosition.y = y;
    }

    public void update(GLViewport v) {
        double scale = v.pos.scale * (double)Tile.SIZE;
        float x = (float)((this.mMapPosition.x - v.pos.x) * scale);
        float y = (float)((this.mMapPosition.y - v.pos.y) * scale);
        float z = (float)(v.pos.scale / this.mMapPosition.scale);
        v.proj.get(this.projection.getValues());
        v.mvp.setTransScale(x, y, z);
        v.mvp.setValue(10, z);
        v.mvp.multiplyLhs(v.view);
        v.mvp.get(this.view.getValues());
        this.combined.set(this.projection);
        Matrix4.mul((float[])this.combined.val, (float[])this.view.val);
        this.invProjectionView.set(this.combined);
        Matrix4.inv((float[])this.invProjectionView.val);
        this.frustum.update(this.invProjectionView);
    }

    public void update() {
    }

    public void update(boolean updateFrustum) {
    }
}

