/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.InputStream;
import org.oscim.backend.AssetAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdxAssets
extends AssetAdapter {
    private static final Logger log = LoggerFactory.getLogger(GdxAssets.class);
    static String pathPrefix = "";

    private GdxAssets(String path) {
        pathPrefix = path;
    }

    public InputStream openFileAsStream(String fileName) {
        FileHandle file = Gdx.files.internal(pathPrefix + fileName);
        if (file == null) {
            throw new IllegalArgumentException("missing file " + fileName);
        }
        try {
            return file.read();
        }
        catch (GdxRuntimeException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    public static String getAssetPath(String fileName) {
        return Gdx.files.internal(pathPrefix + fileName).path();
    }

    public static void init(String path) {
        AssetAdapter.init((AssetAdapter)new GdxAssets(path));
    }
}

