/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.utils.Timer;
import org.oscim.gdx.GestureHandlerImpl;
import org.oscim.gdx.InputHandler;
import org.oscim.gdx.MotionHandler;
import org.oscim.layers.TileGridLayer;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.map.Layers;
import org.oscim.map.Map;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.VtmThemes;
import org.oscim.tiling.TileSource;
import org.oscim.utils.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GdxMap
implements ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(GdxMap.class);
    protected Map mMap;
    protected GestureDetector mGestureDetector;
    protected MapRenderer mMapRenderer;
    boolean mRenderWait;
    boolean mRenderRequest;
    boolean mUpdateRequest;

    protected void initDefaultLayers(TileSource tileSource, boolean tileGrid, boolean labels, boolean buildings) {
        Layers layers = this.mMap.layers();
        if (tileSource != null) {
            VectorTileLayer mapLayer = this.mMap.setBaseMap(tileSource);
            this.mMap.setTheme((ThemeFile)VtmThemes.DEFAULT);
            if (buildings) {
                layers.add((Object)new BuildingLayer(this.mMap, mapLayer));
            }
            if (labels) {
                layers.add((Object)new LabelLayer(this.mMap, mapLayer));
            }
        }
        if (tileGrid) {
            layers.add((Object)new TileGridLayer(this.mMap));
        }
    }

    public void create() {
        GLVersion version = Gdx.graphics.getGLVersion();
        log.info(version.getDebugVersionString());
        this.initGLAdapter(version);
        if (!Parameters.CUSTOM_COORD_SCALE && Math.min(Gdx.graphics.getDisplayMode().width, Gdx.graphics.getDisplayMode().height) > 1080) {
            MapRenderer.COORD_SCALE = 4.0f;
        }
        this.mMap = new MapAdapter();
        this.mMapRenderer = new MapRenderer(this.mMap);
        Gdx.graphics.setContinuousRendering(false);
        Gdx.app.setLogLevel(3);
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        this.mMap.viewport().setViewSize(w, h);
        this.mMapRenderer.onSurfaceCreated();
        this.mMapRenderer.onSurfaceChanged(w, h);
        InputMultiplexer mux = new InputMultiplexer();
        if (!Parameters.MAP_EVENT_LAYER2) {
            this.mGestureDetector = new GestureDetector((GestureDetector.GestureListener)new GestureHandlerImpl(this.mMap));
            mux.addProcessor((InputProcessor)this.mGestureDetector);
        }
        mux.addProcessor((InputProcessor)new InputHandler(this));
        mux.addProcessor((InputProcessor)new MotionHandler(this.mMap));
        Gdx.input.setInputProcessor((InputProcessor)mux);
        this.createLayers();
    }

    protected abstract void initGLAdapter(GLVersion var1);

    protected void createLayers() {
    }

    public void dispose() {
    }

    public void render() {
        this.mMapRenderer.onDrawFrame();
    }

    public void resize(int w, int h) {
        this.mMap.viewport().setViewSize(w, h);
        this.mMapRenderer.onSurfaceChanged(w, h);
        this.mMap.render();
    }

    public void pause() {
    }

    public void resume() {
    }

    protected boolean onKeyDown(int keycode) {
        return false;
    }

    public Map getMap() {
        return this.mMap;
    }

    class MapAdapter
    extends Map {
        private final Runnable mRedrawCb = new Runnable(){

            @Override
            public void run() {
                MapAdapter.this.prepareFrame();
                Gdx.graphics.requestRendering();
            }
        };

        MapAdapter() {
        }

        public int getWidth() {
            return Gdx.graphics.getWidth();
        }

        public int getHeight() {
            return Gdx.graphics.getHeight();
        }

        public int getScreenWidth() {
            return Gdx.graphics.getDisplayMode().width;
        }

        public int getScreenHeight() {
            return Gdx.graphics.getDisplayMode().height;
        }

        public void updateMap() {
            this.updateMap(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateMap(boolean forceRender) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                if (!GdxMap.this.mRenderRequest) {
                    GdxMap.this.mRenderRequest = true;
                    Gdx.app.postRunnable(this.mRedrawCb);
                } else {
                    GdxMap.this.mRenderWait = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                GdxMap.this.mRenderRequest = true;
                if (this.mClearMap) {
                    this.updateMap(false);
                } else {
                    Gdx.graphics.requestRendering();
                }
            }
        }

        public boolean post(Runnable runnable) {
            Gdx.app.postRunnable(runnable);
            return true;
        }

        public boolean postDelayed(final Runnable action, long delay) {
            Timer.schedule((Timer.Task)new Timer.Task(){

                public void run() {
                    action.run();
                }
            }, (float)((float)delay / 1000.0f));
            return true;
        }

        public void beginFrame() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doneFrame(boolean animate) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                GdxMap.this.mRenderRequest = false;
                if (animate || GdxMap.this.mRenderWait) {
                    GdxMap.this.mRenderWait = false;
                    this.updateMap(true);
                }
            }
        }
    }
}

