/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import org.oscim.core.Tile;
import org.oscim.map.Map;

public class GestureHandler
implements GestureDetector.GestureListener {
    private boolean mayFling = true;
    private boolean mPinch;
    private boolean mBeginScale;
    private float mSumScale;
    private float mSumRotate;
    private boolean mBeginRotate;
    private boolean mBeginTilt;
    private float mPrevX;
    private float mPrevY;
    private float mPrevX2;
    private float mPrevY2;
    private float mFocusX;
    private float mFocusY;
    private double mAngle;
    protected double mPrevPinchWidth = -1.0;
    protected static final int JUMP_THRESHOLD = 100;
    protected static final double PINCH_ZOOM_THRESHOLD = 5.0;
    protected static final double PINCH_ROTATE_THRESHOLD = 0.02;
    protected static final float PINCH_TILT_THRESHOLD = 1.0f;
    private final Map mMap;

    public GestureHandler(Map map) {
        this.mMap = map;
    }

    public boolean touchDown(float x, float y, int pointer, int button) {
        this.mayFling = true;
        this.mPinch = false;
        return false;
    }

    public boolean tap(float x, float y, int count, int button) {
        return false;
    }

    public boolean longPress(float x, float y) {
        return false;
    }

    public boolean fling(float velocityX, float velocityY, int button) {
        if (this.mayFling && button == 0) {
            int m = Tile.SIZE * 4;
            this.mMap.animator().animateFling((float)((int)velocityX), (float)((int)velocityY), -m, m, -m, m);
            return true;
        }
        return false;
    }

    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (this.mPinch) {
            return true;
        }
        this.mMap.viewport().moveMap(deltaX, deltaY);
        this.mMap.updateMap(true);
        return false;
    }

    public boolean zoom(float initialDistance, float distance) {
        return false;
    }

    public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
        this.mayFling = false;
        if (!this.mPinch) {
            this.mPrevX = pointer1.x;
            this.mPrevY = pointer1.y;
            this.mPrevX2 = pointer2.x;
            this.mPrevY2 = pointer2.y;
            double dx = this.mPrevX - this.mPrevX2;
            double dy = this.mPrevY - this.mPrevY2;
            this.mAngle = Math.atan2(dy, dx);
            this.mPrevPinchWidth = Math.sqrt(dx * dx + dy * dy);
            this.mPinch = true;
            this.mBeginTilt = false;
            this.mBeginRotate = false;
            this.mBeginScale = false;
            return true;
        }
        float x1 = pointer1.x;
        float y1 = pointer1.y;
        float my = y1 - this.mPrevY;
        float x2 = pointer2.x;
        float y2 = pointer2.y;
        float dx = x1 - x2;
        float dy = y1 - y2;
        float slope = 0.0f;
        if (dx != 0.0f) {
            slope = dy / dx;
        }
        double pinchWidth = Math.sqrt(dx * dx + dy * dy);
        double deltaPinchWidth = pinchWidth - this.mPrevPinchWidth;
        double rad = Math.atan2(dy, dx);
        double r = rad - this.mAngle;
        boolean startScale = Math.abs(deltaPinchWidth) > 5.0;
        boolean changed = false;
        if (!this.mBeginTilt && (this.mBeginScale || startScale)) {
            this.mBeginScale = true;
            float scale = (float)(pinchWidth / this.mPrevPinchWidth);
            if (this.mBeginRotate) {
                scale = 1.0f + (scale - 1.0f) * Math.max(1.0f - (float)Math.abs(r) * 20.0f, 0.0f);
            }
            this.mSumScale *= scale;
            if (((double)this.mSumScale < 0.99 || (double)this.mSumScale > 1.01) && (double)this.mSumRotate < Math.abs(0.02)) {
                this.mBeginRotate = false;
            }
            float fx = (x2 + x1) / 2.0f - (float)(this.mMap.getWidth() / 2);
            float fy = (y2 + y1) / 2.0f - (float)(this.mMap.getHeight() / 2);
            changed = this.mMap.viewport().scaleMap(scale, fx, fy);
        }
        if (!this.mBeginRotate && Math.abs(slope) < 1.0f) {
            float my2 = y2 - this.mPrevY2;
            float threshold = 1.0f;
            if (my > threshold && my2 > threshold || my < -threshold && my2 < -threshold) {
                this.mBeginTilt = true;
                changed = this.mMap.viewport().tiltMap(my / 5.0f);
            }
        }
        if (!this.mBeginTilt && (this.mBeginRotate || Math.abs(slope) > 1.0f && Math.abs(r) > 0.02)) {
            if (!this.mBeginRotate) {
                this.mAngle = rad;
                this.mSumScale = 1.0f;
                this.mSumRotate = 0.0f;
                this.mBeginRotate = true;
                this.mFocusX = (x1 + x2) / 2.0f - (float)(this.mMap.getWidth() / 2);
                this.mFocusY = (y1 + y2) / 2.0f - (float)(this.mMap.getHeight() / 2);
            } else {
                double da = rad - this.mAngle;
                this.mSumRotate = (float)((double)this.mSumRotate + da);
                if (Math.abs(da) > 0.001) {
                    double rsin = Math.sin(r);
                    double rcos = Math.cos(r);
                    float x = (float)((double)this.mFocusX * rcos + (double)this.mFocusY * -rsin - (double)this.mFocusX);
                    float y = (float)((double)this.mFocusX * rsin + (double)this.mFocusY * rcos - (double)this.mFocusY);
                    this.mMap.viewport().rotateMap(da, x, y);
                    changed = true;
                }
            }
            this.mAngle = rad;
        }
        if (changed) {
            this.mMap.updateMap(true);
            this.mPrevPinchWidth = pinchWidth;
            this.mPrevY2 = y2;
        }
        this.mPrevX = x1;
        this.mPrevY = y1;
        this.mPrevX2 = x2;
        return true;
    }

    public boolean panStop(float x, float y, int pointer, int button) {
        return false;
    }

    public void pinchStop() {
    }
}

