/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jeo.tile.Tile;
import org.jeo.tile.TileDataset;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeoTileSource
extends TileSource {
    static final Logger log = LoggerFactory.getLogger(JeoTileSource.class);
    final TileDataset mTileDataset;
    int mRefs;

    public JeoTileSource(TileDataset tileDataset) {
        log.debug("load tileset {}", (Object)tileDataset.name());
        this.mTileDataset = tileDataset;
        this.mZoomMax = 1;
        this.mZoomMin = 0;
    }

    public ITileDataSource getDataSource() {
        return new ITileDataSource(){

            public void query(MapTile tile, ITileDataSink sink) {
                log.debug("query {}", (Object)tile);
                try {
                    Tile t = JeoTileSource.this.mTileDataset.read((long)tile.zoomLevel, (long)tile.tileX, (long)((1 << tile.zoomLevel) - 1 - tile.tileY));
                    if (t == null) {
                        log.debug("not found {}", (Object)tile);
                        sink.completed(QueryResult.TILE_NOT_FOUND);
                        return;
                    }
                    Bitmap b = CanvasAdapter.decodeBitmap((InputStream)new ByteArrayInputStream(t.data()));
                    sink.setTileImage(b);
                    log.debug("success {}", (Object)tile);
                    sink.completed(QueryResult.SUCCESS);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.debug("fail {}", (Object)tile);
                    sink.completed(QueryResult.FAILED);
                    return;
                }
            }

            public void dispose() {
            }

            public void cancel() {
            }
        };
    }

    public TileSource.OpenResult open() {
        ++this.mRefs;
        return TileSource.OpenResult.SUCCESS;
    }

    public void close() {
        if (--this.mRefs == 0) {
            this.mTileDataset.close();
        }
    }
}

