/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.io.IOException;
import org.jeo.geom.Geom;
import org.jeo.map.RGB;
import org.jeo.map.Rule;
import org.jeo.map.RuleList;
import org.jeo.map.Style;
import org.jeo.vector.Feature;
import org.jeo.vector.VectorDataset;
import org.jeo.vector.VectorQuery;
import org.oscim.jeo.JeoUtils;
import org.oscim.layers.JtsLayer;
import org.oscim.layers.vector.AbstractVectorLayer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeoVectorLayer
extends JtsLayer {
    public static final Logger log = LoggerFactory.getLogger(JeoVectorLayer.class);
    static final boolean dbg = false;
    private final VectorDataset mDataset;
    private final RuleList mRules;
    protected double mDropPointDistance = 0.01;
    private double mMinX;
    private double mMinY;

    public JeoVectorLayer(Map map, VectorDataset data, Style style) {
        super(map);
        this.mDataset = data;
        this.mRules = style.getRules().selectById(data.name(), true).flatten();
        log.debug(this.mRules.toString());
        this.mRenderer = new AbstractVectorLayer.Renderer((AbstractVectorLayer)this);
    }

    @Override
    protected void processFeatures(AbstractVectorLayer.Task t, Envelope b) {
        if (this.mDropPointDistance > 0.0) {
            this.mMinX = (b.getMaxX() - b.getMinX()) / (double)this.mMap.getWidth();
            this.mMinY = (b.getMaxY() - b.getMinY()) / (double)this.mMap.getHeight();
            this.mMinX *= this.mDropPointDistance;
            this.mMinY *= this.mDropPointDistance;
        }
        try {
            VectorQuery q = new VectorQuery().bounds(b);
            block10: for (Feature f : this.mDataset.cursor(q)) {
                Geometry g;
                Rule r;
                RuleList rs = this.mRules.match(f);
                if (rs.isEmpty() || (r = rs.collapse()) == null || (g = f.geometry()) == null) continue;
                switch (Geom.Type.from((Geometry)g)) {
                    case POINT: {
                        this.addPoint(t, f, r, g);
                        break;
                    }
                    case MULTIPOINT: {
                        int i;
                        int n = g.getNumGeometries();
                        for (i = 0; i < n; ++i) {
                            this.addPoint(t, f, r, g.getGeometryN(i));
                        }
                        continue block10;
                    }
                    case LINESTRING: {
                        this.addLine(t, f, r, g);
                        break;
                    }
                    case MULTILINESTRING: {
                        int i;
                        int n = g.getNumGeometries();
                        for (i = 0; i < n; ++i) {
                            this.addLine(t, f, r, g.getGeometryN(i));
                        }
                        continue block10;
                    }
                    case POLYGON: {
                        this.addPolygon(t, f, r, g);
                        break;
                    }
                    case MULTIPOLYGON: {
                        int i;
                        int n = g.getNumGeometries();
                        for (i = 0; i < n; ++i) {
                            this.addPolygon(t, f, r, g.getGeometryN(i));
                        }
                        continue block10;
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Error querying layer " + this.mDataset.name() + e);
        }
    }

    protected void addLine(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
        if (((LineString)g).isClosed()) {
            this.addPolygon(t, f, rule, g);
            return;
        }
        LineBucket ll = t.buckets.getLineBucket(2);
        if (ll.line == null) {
            RGB color = rule.color((Object)f, "line-color", RGB.black);
            float width = rule.number((Object)f, "line-width", Float.valueOf(1.2f)).floatValue();
            ll.line = new LineStyle(0, JeoUtils.color(color), width);
            ll.setDropDistance(0.5f);
        }
        this.addLine(t, g, ll);
    }

    protected void addPolygon(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
        LineBucket ll = t.buckets.getLineBucket(1);
        if (ll.line == null) {
            float width = rule.number((Object)f, "line-width", Float.valueOf(1.2f)).floatValue();
            RGB color = rule.color((Object)f, "line-color", RGB.black);
            ll.line = new LineStyle(0, JeoUtils.color(color), width);
            ll.setDropDistance(0.5f);
        }
        MeshBucket mesh = t.buckets.getMeshBucket(0);
        if (mesh.area == null) {
            int color = JeoUtils.color(rule.color((Object)f, "polygon-fill", RGB.red));
            mesh.area = new AreaStyle(color);
        }
        this.addPolygon(t, g, mesh, ll);
    }

    protected void addPoint(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
    }
}

