/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.HashMap;
import org.jeo.map.RGB;
import org.jeo.map.Rule;
import org.jeo.map.Style;
import org.jeo.vector.Feature;
import org.jeo.vector.VectorDataset;
import org.oscim.backend.canvas.Color;
import org.oscim.jeo.JeoUtils;
import org.oscim.layers.JeoVectorLayer;
import org.oscim.layers.vector.AbstractVectorLayer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextBucket;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.TextStyle;

public class OSMIndoorLayer
extends JeoVectorLayer {
    protected TextBucket mTextLayer;
    protected TextStyle mText;
    public boolean[] activeLevels = new boolean[10];

    public OSMIndoorLayer(Map map, VectorDataset data, Style style, TextStyle textStyle) {
        super(map, data, style);
        this.mText = textStyle;
    }

    @Override
    protected void processFeatures(AbstractVectorLayer.Task t, Envelope b) {
        this.mTextLayer = new TextBucket();
        t.buckets.set((RenderBucket)this.mTextLayer);
        super.processFeatures(t, b);
        this.mTextLayer.prepare();
    }

    @Override
    protected void addLine(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
        if (((LineString)g).isClosed()) {
            this.addPolygon(t, f, rule, g);
            return;
        }
        int level = this.getLevel(f);
        LineBucket ll = t.buckets.getLineBucket(level * 3 + 2);
        if (ll.line == null) {
            RGB color = rule.color((Object)f, "line-color", RGB.black);
            float width = rule.number((Object)f, "line-width", Float.valueOf(1.2f)).floatValue();
            ll.line = new LineStyle(0, JeoUtils.color(color), width);
            ll.heightOffset = level * 4;
            ll.setDropDistance(0.0f);
        }
        this.addLine(t, g, ll);
    }

    @Override
    protected void addPolygon(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
        Object o;
        int color;
        int level = this.getLevel(f);
        LineBucket ll = t.buckets.getLineBucket(level * 3 + 1);
        boolean active = this.activeLevels[level + 1];
        if (ll.line == null) {
            float width = rule.number((Object)f, "line-width", Float.valueOf(1.2f)).floatValue();
            color = JeoUtils.color(rule.color((Object)f, "line-color", RGB.black));
            if (!active) {
                color = this.getInactiveColor(color);
            }
            ll.line = new LineStyle(0, color, width);
            ll.heightOffset = level * 4;
            ll.setDropDistance(0.0f);
        }
        MeshBucket mesh = t.buckets.getMeshBucket(level * 3);
        if (mesh.area == null) {
            color = JeoUtils.color(rule.color((Object)f, "polygon-fill", RGB.red));
            if (!active) {
                color = this.getInactiveColor(color);
            }
            mesh.area = new AreaStyle(color);
            mesh.heightOffset = (float)level * 4.0f;
        }
        this.addPolygon(t, g, mesh, ll);
        if (active && (o = f.get("name")) instanceof String) {
            float x = 0.0f;
            float y = 0.0f;
            int n = this.mGeom.index[0];
            if (n > 0) {
                int i = 0;
                while (i < n) {
                    x += this.mGeom.points[i++];
                    y += this.mGeom.points[i++];
                }
                TextItem ti = (TextItem)TextItem.pool.get();
                ti.set(x / (float)(n / 2), y / (float)(n / 2), (String)o, this.mText);
                this.mTextLayer.addText(ti);
            }
        }
    }

    @Override
    protected void addPoint(AbstractVectorLayer.Task t, Feature f, Rule rule, Geometry g) {
    }

    protected int getInactiveColor(int color) {
        return Color.fade((int)color, (double)0.1f);
    }

    private int getLevel(Feature f) {
        HashMap tags;
        HashMap reltags;
        Object o = f.get("@relations");
        if (o instanceof HashMap && (reltags = (HashMap)(tags = (HashMap)o).get("reltags")) != null && (o = reltags.get("level")) instanceof String) {
            return Integer.parseInt((String)o);
        }
        o = f.get("level");
        if (o instanceof String) {
            return (int)Double.parseDouble((String)o);
        }
        return 0;
    }
}

