/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jeo.carto.Carto;
import org.jeo.data.Dataset;
import org.jeo.data.mem.MemVector;
import org.jeo.data.mem.MemWorkspace;
import org.jeo.geojson.GeoJSONDataset;
import org.jeo.geojson.GeoJSONReader;
import org.jeo.geom.GeomBuilder;
import org.jeo.map.Style;
import org.jeo.vector.Feature;
import org.jeo.vector.Features;
import org.jeo.vector.Schema;
import org.jeo.vector.SchemaBuilder;
import org.jeo.vector.VectorDataset;
import org.jeo.vector.VectorQuery;
import org.oscim.layers.OSMIndoorLayer;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.styles.TextStyle;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.oscimap4.OSciMap4TileSource;

public class JeoTest {
    public static void indoorSketch(Map map, String file) {
        MapRenderer.setBackgroundColor((int)-7303024);
        VectorTileLayer baseLayer = map.setBaseMap((TileSource)new OSciMap4TileSource());
        map.layers().add((Object)new BuildingLayer(map, baseLayer));
        VectorDataset data = null;
        try {
            data = JeoTest.readGeoJson(new FileInputStream(new File(file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Style style = JeoTest.getStyle();
        TextStyle textStyle = ((TextStyle.TextBuilder)((TextStyle.TextBuilder)((TextStyle.TextBuilder)TextStyle.builder().isCaption(true).fontSize(16.0f).color(-16777216)).strokeWidth(2.2f)).strokeColor(-1)).build();
        map.layers().add((Object)new OSMIndoorLayer(map, data, style, textStyle));
    }

    public static Style getStyle() {
        Style style = null;
        try {
            style = Carto.parse((Object)"#way {  line-width: 2;  line-color: #c80;  polygon-fill: #44111111;  }#states {  line-width: 2.2;  line-color: #c80;  polygon-fill: #44111111;  }");
            return style;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static VectorDataset readGeoJson(InputStream is) {
        GeoJSONReader r = new GeoJSONReader();
        MemWorkspace mem = new MemWorkspace();
        try {
            Schema s = new SchemaBuilder("way").schema();
            MemVector memData = mem.create(s);
            for (Feature f : r.features((Object)is)) {
                memData.add(f);
            }
            return memData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Dataset getJsonData(String file, boolean memory) {
        GeoJSONDataset data = null;
        try {
            data = new GeoJSONDataset(new File(file));
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (memory) {
            MemWorkspace mem = new MemWorkspace();
            try {
                Schema s = data.schema();
                VectorQuery q = new VectorQuery();
                MemVector memData = mem.create(s);
                for (Feature f : data.cursor(q)) {
                    memData.add(f);
                }
                return memData;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static Dataset getMemWorkspace(String layer) {
        MemVector data;
        GeomBuilder gb = new GeomBuilder(4326);
        MemWorkspace mem = new MemWorkspace();
        Schema schema = new SchemaBuilder(layer).field("geometry", Geometry.class).field("id", Integer.class).field("name", String.class).field("cost", Double.class).schema();
        try {
            data = mem.create(schema);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Point g = gb.point(0.0, 0.0).toPoint();
        data.add(Features.create(null, (Schema)data.schema(), (Object[])new Object[]{g, 1, "anvil", 10.99}));
        data.add(Features.create(null, (Schema)data.schema(), (Object[])new Object[]{gb.points(new double[]{10.0, 10.0, 20.0, 20.0}).toLineString(), 2, "bomb", 11.99}));
        data.add(Features.create(null, (Schema)data.schema(), (Object[])new Object[]{gb.point(100.0, 10.0).toPoint().buffer(10.0), 3, "dynamite", 12.99}));
        try {
            return mem.get(layer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

