/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.jeo.geom.CoordinatePath;
import org.oscim.core.Box;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.layers.vector.AbstractVectorLayer;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.utils.geom.SimplifyDP;
import org.oscim.utils.geom.SimplifyVW;

public abstract class JtsLayer
extends AbstractVectorLayer<Geometry> {
    private double mMinX;
    private double mMinY;
    SimplifyDP mSimpDP = new SimplifyDP();
    SimplifyVW mSimpVW = new SimplifyVW();

    public JtsLayer(Map map) {
        super(map);
    }

    protected void processFeatures(AbstractVectorLayer.Task t, Box bbox) {
        this.processFeatures(t, new Envelope(bbox.xmin, bbox.xmax, bbox.ymin, bbox.ymax));
    }

    protected abstract void processFeatures(AbstractVectorLayer.Task var1, Envelope var2);

    /*
     * Enabled aggressive block sorting
     */
    protected int transformPath(MapPosition pos, GeometryBuffer g, CoordinatePath path) {
        double scale = pos.scale * (double)Tile.SIZE / 4.0;
        int cnt = 0;
        while (path.hasNext()) {
            Coordinate c = path.next();
            float x = (float)((MercatorProjection.longitudeToX((double)c.x) - pos.x) * scale);
            float y = (float)((MercatorProjection.latitudeToY((double)c.y) - pos.y) * scale);
            switch (path.step()) {
                case MOVE_TO: {
                    if (g.isPoly()) {
                        g.startPolygon();
                    } else if (g.isLine()) {
                        g.startLine();
                    }
                    ++cnt;
                    g.addPoint(x, y);
                    break;
                }
                case LINE_TO: {
                    ++cnt;
                    g.addPoint(x, y);
                    break;
                }
                case CLOSE: {
                    break;
                }
                case STOP: {
                    return cnt;
                }
            }
        }
        return cnt;
    }

    protected void addPolygon(AbstractVectorLayer.Task t, Geometry g, MeshBucket ml, LineBucket ll) {
        this.mGeom.clear();
        this.mGeom.startPolygon();
        CoordinatePath p = CoordinatePath.create((Geometry)g);
        if (this.mMinX > 0.0 || this.mMinY > 0.0) {
            p.generalize(this.mMinX, this.mMinY);
        }
        if (this.transformPath(t.position, this.mGeom, p) < 3) {
            return;
        }
        if (!this.mClipper.clip(this.mGeom)) {
            return;
        }
        this.mSimpVW.simplify(this.mGeom, 0.1f);
        this.mSimpDP.simplify(this.mGeom, 0.5f);
        ll.addLine(this.mGeom);
        ml.addMesh(this.mGeom);
    }

    protected void addLine(AbstractVectorLayer.Task t, Geometry g, LineBucket ll) {
        this.mGeom.clear();
        this.mGeom.startLine();
        CoordinatePath p = CoordinatePath.create((Geometry)g);
        this.transformPath(t.position, this.mGeom, p);
        ll.addLine(this.mGeom);
    }
}

