/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.carto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jeo.carto.Carto;
import org.jeo.map.RGB;
import org.jeo.map.Rule;
import org.jeo.map.RuleList;
import org.jeo.map.Style;
import org.jeo.vector.Feature;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.carto.MatcherFeature;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;

public class RenderTheme
implements IRenderTheme {
    final String STYLE = "[building = 'yes'] { z: 1;  polygon-fill: #eee;  [zoom >= 16] {    polygon-fill: #c00;  }}[admin_level = '2'] { line-color: #000; line-width: 1; z: 1;}[admin_level = '2'] { line-color: #000; line-width: 1; z: 1;}[admin_level = '4'] { line-color: #aaa; line-width: 1; z: 2;}[highway = 'motorway'] { line-color: #a00; z: 10;}[highway = 'primary'] { line-color: #aa0; z: 11;}[highway = 'residential'],[highway = 'road'],[highway = 'secondary'] { line-color: #fff; z: 12;} [landuse = 'forest'] { polygon-fill: #0a0; z: 2;}[natural = 'water'] { polygon-fill: #00a; z: 3;}";
    private Style mStyle;
    private RuleList mRules;
    MatcherFeature mMatchFeature = new MatcherFeature();
    private int mBackground;
    Map<Rule, StyleSet> mStyleSets = new HashMap<Rule, StyleSet>();
    int mCurLevel = 0;

    public RenderTheme() {
        Rule rule;
        RGB bgColor;
        try {
            this.mStyle = this.loadStyle();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RuleList rules = this.mStyle.getRules().selectByName("Map", false, false);
        if (!rules.isEmpty() && (bgColor = (rule = rules.collapse()).color(null, "background-color", null)) != null) {
            bgColor = bgColor.alpha(rule.number(null, "opacity", Float.valueOf(1.0f)).floatValue());
            this.mBackground = RenderTheme.color(bgColor);
        }
        this.mRules = this.mStyle.getRules();
        if (((Rule)this.mRules.get(1)).equals(this.mRules.get(2))) {
            System.out.println("ok");
        }
        for (Rule r : this.mRules) {
            System.out.println(this.formatRule(r, 0));
        }
    }

    public String formatRule(Rule r, int indent) {
        StringBuilder sb = new StringBuilder();
        String pad = "";
        for (int i = 0; i < indent; ++i) {
            pad = pad + " ";
        }
        sb.append(pad);
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(pad).append(" {").append("\n");
        StyleSet s = new StyleSet();
        RGB l = null;
        RGB p = null;
        if (r.properties().containsKey("line-color")) {
            l = r.color(null, "line-color", RGB.black);
        }
        if (r.properties().containsKey("polygon-fill")) {
            p = r.color(null, "polygon-fill", RGB.black);
        }
        if (p != null) {
            s.ri[0] = new AreaStyle(this.mCurLevel++, RenderTheme.color(p));
        }
        if (l != null) {
            s.ri[1] = new LineStyle(this.mCurLevel++, RenderTheme.color(l), 1.0f);
        }
        if (p != null || l != null) {
            this.mStyleSets.put(r, s);
            System.out.println("put " + s.ri[0] + s.ri[1]);
        }
        for (Map.Entry e : r.properties().entrySet()) {
            sb.append(pad).append("  ").append((String)e.getKey()).append(": ").append(e.getValue()).append(";\n");
        }
        for (Rule nested : r.nested()) {
            sb.append(this.formatRule(nested, indent + 2)).append("\n");
        }
        sb.append(pad).append("}");
        return sb.toString();
    }

    Style loadStyle() throws IOException {
        return Carto.parse((Object)"[building = 'yes'] { z: 1;  polygon-fill: #eee;  [zoom >= 16] {    polygon-fill: #c00;  }}[admin_level = '2'] { line-color: #000; line-width: 1; z: 1;}[admin_level = '2'] { line-color: #000; line-width: 1; z: 1;}[admin_level = '4'] { line-color: #aaa; line-width: 1; z: 2;}[highway = 'motorway'] { line-color: #a00; z: 10;}[highway = 'primary'] { line-color: #aa0; z: 11;}[highway = 'residential'],[highway = 'road'],[highway = 'secondary'] { line-color: #fff; z: 12;} [landuse = 'forest'] { polygon-fill: #0a0; z: 2;}[natural = 'water'] { polygon-fill: #00a; z: 3;}");
    }

    public synchronized RenderStyle[] matchElement(GeometryBuffer.GeometryType type, TagSet tags, int zoomLevel) {
        MatcherFeature f = this.mMatchFeature;
        f.setTags(tags);
        f.setZoom(zoomLevel);
        RuleList rules = this.mRules.match((Feature)f);
        Rule r = rules.collapse();
        if (rules.isEmpty()) {
            return null;
        }
        int z = r.number((Object)f, "z", Float.valueOf(0.0f)).intValue();
        if (type == GeometryBuffer.GeometryType.POLY) {
            RGB c = r.color((Object)f, "polygon-fill", RGB.black);
            System.out.println(z + " " + c);
            return new RenderStyle[]{new AreaStyle(z, RenderTheme.color(c))};
        }
        if (type == GeometryBuffer.GeometryType.LINE) {
            RGB c = r.color((Object)f, "line-color", RGB.black);
            float width = r.number((Object)f, "line-width", Float.valueOf(2.0f)).floatValue();
            return new RenderStyle[]{new LineStyle(100 + z, RenderTheme.color(c), width)};
        }
        if (type == GeometryBuffer.GeometryType.POINT) {
            // empty if block
        }
        return null;
    }

    public static int color(RGB rgb) {
        return rgb.getAlpha() << 24 | rgb.getRed() << 16 | rgb.getGreen() << 8 | rgb.getBlue();
    }

    public void dispose() {
    }

    public int getLevels() {
        return 1;
    }

    public int getMapBackground() {
        return this.mBackground;
    }

    public boolean isMapsforgeTheme() {
        return false;
    }

    public void scaleTextSize(float scaleFactor) {
    }

    public String transformBackwardKey(String key) {
        return null;
    }

    public String transformForwardKey(String key) {
        return null;
    }

    public Tag transformBackwardTag(Tag tag) {
        return null;
    }

    public Tag transformForwardTag(Tag tag) {
        return null;
    }

    public void updateStyles() {
    }

    public static void main(String[] args) {
        RenderTheme t = new RenderTheme();
        MapElement e = new MapElement();
        e.startPolygon();
        e.tags.add(new Tag("building", "yes"));
        t.matchElement(GeometryBuffer.GeometryType.POLY, e.tags, 16);
        t.matchElement(GeometryBuffer.GeometryType.POLY, e.tags, 15);
    }

    class StyleSet {
        int level;
        RenderStyle[] ri = new RenderStyle[2];

        StyleSet() {
        }
    }
}

