/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.carto;

import com.vividsolutions.jts.geom.Geometry;
import io.jeo.util.Util;
import io.jeo.vector.Feature;
import io.jeo.vector.Field;
import io.jeo.vector.Schema;
import io.jeo.vector.SchemaBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgeo.proj4j.CoordinateReferenceSystem;

public class BasicFeature
implements Feature {
    protected String id;
    protected Storage storage;

    public BasicFeature(String id) {
        this(id, (Schema)null);
    }

    public BasicFeature(String id, Schema schema) {
        this(id, schema != null ? new ListStorage(null, schema) : new MapStorage(null, schema));
    }

    public BasicFeature(String id, List<Object> values) {
        this(id, values, null);
    }

    public BasicFeature(String id, List<Object> values, Schema schema) {
        this(id, new ListStorage(values, schema));
    }

    public BasicFeature(String id, Map<String, Object> values) {
        this(id, values, null);
    }

    public BasicFeature(String id, Map<String, Object> values, Schema schema) {
        this(id, new MapStorage(values, schema));
    }

    protected BasicFeature(String id, Storage storage) {
        this.id = id != null ? id : Util.uuid();
        this.storage = storage;
    }

    public String id() {
        return this.id;
    }

    public BasicFeature crs(CoordinateReferenceSystem crs) {
        this.storage.crs(crs);
        return this;
    }

    public boolean has(String key) {
        return this.storage.has(key);
    }

    public Object get(String key) {
        return this.storage.get(key);
    }

    public BasicFeature put(String key, Object val) {
        this.storage.put(key, val);
        return this;
    }

    public BasicFeature put(Geometry g) {
        Field gf = this.storage.schema(true).geometry();
        if (gf == null) {
            throw new IllegalArgumentException("Feature schema has no geometry");
        }
        return this.put(gf.name(), g);
    }

    public Geometry geometry() {
        return this.storage.geometry();
    }

    public Map<String, Object> map() {
        return this.storage.map();
    }

    public String toString() {
        return this.id + this.map();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.storage == null ? 0 : this.storage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicFeature other = (BasicFeature)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }

    static class MapStorage
    extends Storage {
        Map<String, Object> map;

        MapStorage(Map<String, Object> values, Schema schema) {
            super(schema);
            this.map = values != null ? new LinkedHashMap<String, Object>(values) : new LinkedHashMap();
        }

        @Override
        protected Schema buildSchema() {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Map.Entry<String, Object> e : this.map.entrySet()) {
                fields.add(new Field(e.getKey(), e.getValue() != null ? e.getValue().getClass() : null));
            }
            return new Schema("feature", fields);
        }

        @Override
        protected Geometry findGeometry() {
            for (Object obj : this.map.values()) {
                if (!(obj instanceof Geometry)) continue;
                return (Geometry)obj;
            }
            return null;
        }

        @Override
        protected boolean has(String key) {
            return this.map.containsKey(key);
        }

        @Override
        protected Object get(String key) {
            return this.map.get(key);
        }

        @Override
        protected void put(String key, Object val) {
            if (!this.map.containsKey(key)) {
                this.schema = null;
            }
            this.map.put(key, val);
        }

        @Override
        protected Object get(int index) {
            return Util.get(this.map, (int)index);
        }

        @Override
        protected void set(int index, Object value) {
            Util.set(this.map, (int)index, (Object)value);
        }

        @Override
        protected List<Object> list() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Field f : this.schema()) {
                list.add(this.get(f.name()));
            }
            return list;
        }

        @Override
        protected Map<String, Object> map() {
            return Collections.unmodifiableMap(this.map);
        }
    }

    static class ListStorage
    extends Storage {
        List<Object> list;

        ListStorage(List<Object> values, Schema schema) {
            super(schema);
            this.list = this.pad(values, schema);
        }

        List<Object> pad(List<Object> values, Schema schema) {
            List<Object> list = values = values != null ? new ArrayList<Object>(values) : new ArrayList();
            if (schema != null) {
                while (values.size() < schema.size()) {
                    values.add(null);
                }
            }
            return values;
        }

        @Override
        protected Geometry findGeometry() {
            for (Object o : this.list) {
                if (!(o instanceof Geometry)) continue;
                return (Geometry)o;
            }
            return null;
        }

        @Override
        protected Schema buildSchema() {
            ArrayList<Field> fields = new ArrayList<Field>();
            int i = 0;
            boolean g = false;
            for (Object o : this.list) {
                if (o instanceof Geometry && !g) {
                    fields.add(new Field("geometry", o.getClass()));
                    g = true;
                    continue;
                }
                fields.add(new Field(String.format(Locale.ROOT, "field%d", i++), o != null ? o.getClass() : null));
            }
            return new Schema("feature", fields);
        }

        @Override
        protected boolean has(String key) {
            return this.schema().indexOf(key) >= 0;
        }

        @Override
        protected Object get(int i) {
            return this.list.get(i);
        }

        @Override
        protected void set(int i, Object value) {
            this.list.set(i, value);
        }

        @Override
        protected Object get(String key) {
            int i = this.schema().indexOf(key);
            return i != -1 ? this.get(i) : null;
        }

        @Override
        protected void put(String key, Object val) {
            int i = this.schema().indexOf(key);
            if (i == -1) {
                throw new IllegalArgumentException("No such key " + key);
            }
            this.set(i, val);
        }

        @Override
        protected List<Object> list() {
            return Collections.unmodifiableList(this.list);
        }

        @Override
        protected Map<String, Object> map() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Field f : this.schema()) {
                map.put(f.name(), this.get(f.name()));
            }
            return map;
        }
    }

    protected static abstract class Storage {
        Schema schema;
        CoordinateReferenceSystem crs;

        protected Storage(Schema schema) {
            this.schema = schema;
        }

        protected Storage crs(CoordinateReferenceSystem crs) {
            this.crs = crs;
            return this;
        }

        protected Schema schema() {
            return this.schema(true);
        }

        protected Schema schema(boolean derive) {
            if (this.schema == null && derive) {
                this.schema = this.buildSchema();
                if (this.crs != null && this.schema.crs() == null) {
                    this.schema = SchemaBuilder.crs((Schema)this.schema, (CoordinateReferenceSystem)this.crs);
                }
            }
            return this.schema;
        }

        protected Geometry geometry() {
            Field f;
            if (this.schema != null && (f = this.schema.geometry()) != null) {
                return (Geometry)this.get(f.name());
            }
            return this.findGeometry();
        }

        protected CoordinateReferenceSystem crs() {
            if (this.crs != null) {
                return this.crs;
            }
            if (this.schema != null) {
                return this.schema.crs();
            }
            return null;
        }

        protected abstract Schema buildSchema();

        protected abstract Geometry findGeometry();

        protected abstract Object get(String var1);

        protected abstract Object get(int var1);

        protected abstract void put(String var1, Object var2);

        protected abstract void set(int var1, Object var2);

        protected abstract List<Object> list();

        protected abstract Map<String, Object> map();

        protected abstract boolean has(String var1);
    }
}

