/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import java.util.LinkedHashMap;
import java.util.Map;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.geojson.GeojsonTileSource;

public class MapzenGeojsonTileSource
extends GeojsonTileSource {
    private static final String DEFAULT_URL = "https://tile.mapzen.com/mapzen/vector/v1/all";
    private static final String DEFAULT_PATH = "/{Z}/{X}/{Y}.json";
    private static Map<String, Tag> mappings = new LinkedHashMap<String, Tag>();
    private final String locale;

    public static Builder<?> builder() {
        return new Builder();
    }

    private static Tag addMapping(String key, String val) {
        Tag tag = new Tag(key, val);
        mappings.put(key + "=" + val, tag);
        return tag;
    }

    public MapzenGeojsonTileSource(Builder<?> builder) {
        super(builder);
        this.locale = ((Builder)builder).locale;
    }

    public MapzenGeojsonTileSource() {
        this(MapzenGeojsonTileSource.builder());
    }

    public MapzenGeojsonTileSource(String urlString) {
        this((Builder)MapzenGeojsonTileSource.builder().url(urlString));
    }

    @Override
    public void decodeTags(MapElement mapElement, Map<String, Object> properties) {
        boolean hasName = false;
        String fallbackName = null;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String val;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = val = value instanceof String ? (String)value : String.valueOf(value);
            if (key.startsWith("name")) {
                int len = key.length();
                if (len == 4) {
                    fallbackName = val;
                    continue;
                }
                if (len < 7 || !this.locale.equals(key.substring(5))) continue;
                hasName = true;
                mapElement.tags.add(new Tag("name", val, false));
                continue;
            }
            Tag tag = mappings.get(key + "=" + val);
            if (tag == null) {
                tag = MapzenGeojsonTileSource.addMapping(key, val);
            }
            mapElement.tags.add(tag);
        }
        if (!hasName && fallbackName != null) {
            mapElement.tags.add(new Tag("name", fallbackName, false));
        }
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        private String locale = "";

        public Builder() {
            super(MapzenGeojsonTileSource.DEFAULT_URL, MapzenGeojsonTileSource.DEFAULT_PATH, 1, 17);
        }

        public T locale(String locale) {
            this.locale = locale;
            return (T)((Object)((Builder)this.self()));
        }

        public MapzenGeojsonTileSource build() {
            return new MapzenGeojsonTileSource(this);
        }
    }
}

