/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.core.client.JsArrayNumber;
import com.google.gwt.core.client.JsArrayUtils;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.Int32Array;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.bucket.VertexData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tessellator {
    static final Logger log = LoggerFactory.getLogger(Tessellator.class);

    public static int tessellate(GeometryBuffer geom, float scale, VertexData outPoints, VertexData outTris, int vertexOffset) {
        int numIndices = 0;
        int indexPos = 0;
        int pointPos = 0;
        int indexEnd = geom.index.length;
        JsArrayNumber jspoints = JsArrayUtils.readOnlyJsArray((float[])geom.points);
        JsArrayInteger jsindex = JsArrayUtils.readOnlyJsArray((int[])geom.index);
        for (int idx = 0; idx < indexEnd && geom.index[idx] > 0; ++idx) {
            TessResult res;
            indexPos = idx;
            int numRings = 1;
            int numPoints = geom.index[idx++];
            while (idx < indexEnd && geom.index[idx] > 0) {
                ++numRings;
                numPoints += geom.index[idx];
                ++idx;
            }
            if (numPoints <= 0 && numRings == 1) {
                log.debug("tessellation skip empty");
                pointPos += numPoints;
                continue;
            }
            try {
                res = Tessellator.tessellate2(jspoints, pointPos, numPoints, jsindex, indexPos, numRings);
            }
            catch (JavaScriptException e) {
                e.printStackTrace();
                return 0;
            }
            pointPos += numPoints;
            if (res == null) {
                log.debug("tessellation failed");
                continue;
            }
            Int32Array io = res.getIndices(res);
            int resIndices = io.length();
            numIndices += resIndices;
            int cnt = 0;
            for (int k = 0; k < resIndices; k += cnt) {
                VertexData.Chunk chunk = outTris.obtainChunk();
                cnt = 360 - chunk.used;
                if (k + cnt > resIndices) {
                    cnt = resIndices - k;
                }
                for (int i = 0; i < cnt; ++i) {
                    chunk.vertices[chunk.used + i] = (short)(vertexOffset + io.get(k + i));
                }
                chunk.used += cnt;
                outTris.releaseChunk();
            }
            Float32Array po = res.getPoints(res);
            int resPoints = po.length();
            vertexOffset += resPoints >> 1;
            int cnt2 = 0;
            for (int k = 0; k < resPoints; k += cnt2) {
                VertexData.Chunk chunk = outPoints.obtainChunk();
                cnt2 = 360 - chunk.used;
                if (k + cnt2 > resPoints) {
                    cnt2 = resPoints - k;
                }
                for (int i = 0; i < cnt2; ++i) {
                    chunk.vertices[chunk.used + i] = (short)(po.get(k + i) * scale);
                }
                chunk.used += cnt2;
                outPoints.releaseChunk();
            }
            if (idx >= indexEnd || geom.index[idx] < 0) break;
        }
        return numIndices;
    }

    public static int tessellate(float[] points, int ppos, int plen, int[] index, int ipos, int rings, int vertexOffset, VertexData outTris) {
        Int32Array io;
        try {
            io = Tessellator.tessellate(JsArrayUtils.readOnlyJsArray((float[])points), ppos, plen, JsArrayUtils.readOnlyJsArray((int[])index), ipos, rings);
        }
        catch (JavaScriptException e) {
            e.printStackTrace();
            return 0;
        }
        if (io == null) {
            return 0;
        }
        int numIndices = io.length();
        int cnt = 0;
        for (int k = 0; k < numIndices; k += cnt) {
            VertexData.Chunk chunk = outTris.obtainChunk();
            cnt = 360 - chunk.used;
            if (k + cnt > numIndices) {
                cnt = numIndices - k;
            }
            for (int i = 0; i < cnt; ++i) {
                int idx = vertexOffset + io.get(k + i);
                chunk.vertices[chunk.used + i] = (short)idx;
            }
            chunk.used += cnt;
            outTris.releaseChunk();
        }
        return numIndices;
    }

    public static int tessellate(GeometryBuffer geom, GeometryBuffer out) {
        return 0;
    }

    static native Int32Array tessellate(JsArrayNumber var0, int var1, int var2, JsArrayInteger var3, int var4, int var5);

    static native TessResult tessellate2(JsArrayNumber var0, int var1, int var2, JsArrayInteger var3, int var4, int var5);

    static final class TessResult
    extends JavaScriptObject {
        protected TessResult() {
        }

        native Float32Array getPoints(JavaScriptObject var1);

        native Int32Array getIndices(JavaScriptObject var1);
    }
}

