/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.client;

import com.badlogic.gdx.graphics.Pixmap;
import org.oscim.backend.canvas.Paint;
import org.oscim.gdx.client.GwtGdxGraphics;

public class GwtPaint
implements Paint {
    private Paint.Align align;
    String color;
    boolean stroke;
    float strokeWidth;
    float fontSize = 12.0f;
    private Paint.FontStyle fontStyle = Paint.FontStyle.NORMAL;
    private Paint.FontFamily fontFamily = Paint.FontFamily.DEFAULT;
    String font = "13px Helvetica";
    Paint.Style style;

    public int getColor() {
        return 0;
    }

    public void setColor(int color) {
        float a = (float)(color >>> 24 & 0xFF) / 255.0f;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        this.color = Pixmap.make(r, g, b, a);
    }

    public void setStrokeCap(Paint.Cap cap) {
        this.stroke = true;
    }

    public void setStrokeJoin(Paint.Join join) {
        this.stroke = true;
    }

    public void setStrokeWidth(float width) {
        this.stroke = true;
        this.strokeWidth = width;
    }

    public void setStyle(Paint.Style style) {
        this.style = style;
    }

    public void setTextAlign(Paint.Align align) {
        this.align = align;
    }

    public void setTextSize(float size) {
        this.fontSize = size;
        this.buildFont();
    }

    public void setTypeface(Paint.FontFamily fontFamily, Paint.FontStyle fontStyle) {
        this.fontStyle = fontStyle;
        this.fontFamily = fontFamily;
        this.buildFont();
    }

    public float measureText(String text) {
        return GwtGdxGraphics.getTextWidth(text, this.font);
    }

    public float getFontHeight() {
        return 2.0f + this.fontSize + this.strokeWidth * 2.0f;
    }

    public float getFontDescent() {
        return 4.0f + this.strokeWidth;
    }

    private void buildFont() {
        StringBuilder sb = new StringBuilder();
        String weight = null;
        String name = "Helvetica";
        switch (this.fontFamily) {
            case MEDIUM: {
                weight = "500";
                break;
            }
            case BLACK: {
                weight = "900";
                break;
            }
            case DEFAULT_BOLD: {
                weight = "bold";
                break;
            }
            case LIGHT: {
                weight = "300";
                break;
            }
            case THIN: {
                weight = "200";
                break;
            }
            case SERIF: {
                name = "Georgia";
                break;
            }
            case MONOSPACE: {
                name = "'Courier New'";
                break;
            }
            case CONDENSED: {
                sb.append("condensed ");
            }
        }
        switch (this.fontStyle) {
            case BOLD: {
                weight = "bold";
                break;
            }
            case ITALIC: {
                sb.append("italic ");
                break;
            }
            case BOLD_ITALIC: {
                weight = "bold";
                sb.append("italic ");
            }
        }
        if (weight != null) {
            sb.append(weight).append(" ");
        }
        sb.append(Math.round(this.fontSize));
        sb.append("px ").append(name);
        this.font = sb.toString();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public Paint.Style getStyle() {
        return this.style;
    }

    public float getTextHeight(String text) {
        return 0.0f;
    }

    public float getTextWidth(String text) {
        return this.measureText(text);
    }
}

