/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import com.google.gwt.typedarrays.client.Uint8ArrayNative;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint8Array;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;

public class LwHttp
implements HttpEngine {
    private XMLHttpRequest mHttpRequest;
    private ReadyStateChangeHandler mResponseHandler;
    private UrlTileSource mTileSource;

    public LwHttp(UrlTileSource tileSource) {
        this.mTileSource = tileSource;
    }

    public void close() {
        if (this.mHttpRequest == null) {
            return;
        }
        this.mHttpRequest.abort();
        this.mHttpRequest = null;
    }

    public void sendRequest(MapTile tile, final UrlTileDataSource dataSource) {
        String url = this.mTileSource.getTileUrl((Tile)tile);
        this.mHttpRequest = XMLHttpRequest.create();
        this.mHttpRequest.open("GET", url);
        this.mHttpRequest.setResponseType(XMLHttpRequest.ResponseType.ArrayBuffer);
        this.mResponseHandler = new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                int state = xhr.getReadyState();
                if (state == 4) {
                    if (xhr.getStatus() == 200) {
                        Uint8ArrayNative buf = Uint8ArrayNative.create((ArrayBuffer)xhr.getResponseArrayBuffer());
                        dataSource.process(new Buffer((Uint8Array)buf));
                    } else {
                        dataSource.process(null);
                    }
                    LwHttp.this.mHttpRequest = null;
                }
            }
        };
        this.mHttpRequest.setOnReadyStateChange(this.mResponseHandler);
        this.mHttpRequest.send();
    }

    public InputStream read() throws IOException {
        return null;
    }

    public void setCache(OutputStream os) {
    }

    public boolean requestCompleted(boolean success) {
        return true;
    }

    public void sendRequest(Tile tile) throws IOException {
    }

    public static class LwHttpFactory
    implements HttpEngine.Factory {
        public HttpEngine create(UrlTileSource tileSource) {
            return new LwHttp(tileSource);
        }
    }

    static class Buffer
    extends InputStream {
        Uint8Array mBuffer;
        int mPos;
        int mEnd;

        public Buffer(Uint8Array buf) {
            this.mBuffer = buf;
            this.mPos = 0;
            this.mEnd = buf.byteLength();
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.mPos < this.mEnd) {
                return this.mBuffer.get(this.mPos++);
            }
            return -1;
        }
    }
}

