/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.Tile;
import org.oscim.layers.tile.LoadDelayTask;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.LwHttp;
import org.oscim.tiling.source.UrlTileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlTileDataSource
implements ITileDataSource {
    static final Logger log = LoggerFactory.getLogger(UrlTileDataSource.class);
    protected final LwHttp mConn;
    protected final ITileDecoder mTileDecoder;
    protected final UrlTileSource mTileSource;
    private ITileDataSink mSink;
    private MapTile mTile;

    public UrlTileDataSource(UrlTileSource tileSource, ITileDecoder tileDecoder, HttpEngine conn) {
        this.mTileSource = tileSource;
        this.mTileDecoder = tileDecoder;
        this.mConn = (LwHttp)conn;
    }

    public void query(MapTile tile, ITileDataSink sink) {
        this.mTile = tile;
        this.mSink = sink;
        this.mConn.sendRequest(tile, this);
    }

    public void process(InputStream is) {
        if (is == null) {
            log.debug("{} no inputstream", (Object)this.mTile);
            this.mSink.completed(QueryResult.FAILED);
            this.mTile = null;
            this.mSink = null;
            return;
        }
        TileLoader.postLoadDelay(new LoadDelayTask<InputStream>(this.mTile, this.mSink, is){

            @Override
            public void continueLoading() {
                boolean win = false;
                if (this.tile.state(2)) {
                    try {
                        win = UrlTileDataSource.this.mTileDecoder.decode((Tile)this.tile, this.sink, (InputStream)this.data);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (win) {
                    this.sink.completed(QueryResult.SUCCESS);
                } else {
                    this.sink.completed(QueryResult.FAILED);
                    log.debug("{} decode failed", (Object)this.tile);
                }
            }
        });
        this.mTile = null;
        this.mSink = null;
    }

    public void dispose() {
        this.mConn.close();
    }

    public void cancel() {
        this.mConn.close();
    }
}

