/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import com.google.gwt.core.client.JavaScriptObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.geojson.Feature;
import org.oscim.tiling.source.geojson.FeatureCollection;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;
import org.oscim.tiling.source.geojson.Geometry;
import org.oscim.tiling.source.geojson.LineString;
import org.oscim.tiling.source.geojson.LngLat;
import org.oscim.tiling.source.geojson.MultiLineString;
import org.oscim.tiling.source.geojson.MultiPolygon;
import org.oscim.tiling.source.geojson.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsonTileDecoder
implements ITileDecoder {
    static final Logger log = LoggerFactory.getLogger(GeoJsonTileDecoder.class);
    private final MapElement mapElement;
    private final GeoJsonTileSource mTileSource;
    private ITileDataSink mTileDataSink;
    static final LinkedHashMap<String, Object> mProperties = new LinkedHashMap(10);
    double mTileY;
    double mTileX;
    double mTileScale;

    public GeoJsonTileDecoder(GeoJsonTileSource tileSource) {
        this.mTileSource = tileSource;
        this.mapElement = new MapElement();
        this.mapElement.layer = 5;
    }

    public boolean decode(Tile tile, ITileDataSink sink, JavaScriptObject jso) {
        this.mTileDataSink = sink;
        this.mTileScale = 1 << tile.zoomLevel;
        this.mTileX = (double)tile.tileX / this.mTileScale;
        this.mTileY = (double)tile.tileY / this.mTileScale;
        this.mTileScale *= (double)Tile.SIZE;
        FeatureCollection c = (FeatureCollection)jso;
        for (Feature f : c.getFeatures()) {
            this.mapElement.clear();
            this.mapElement.tags.clear();
            this.mTileSource.decodeTags(this.mapElement, f.getProperties(mProperties));
            if (this.mapElement.tags.size() == 0) continue;
            this.decodeGeometry(f.getGeometry());
            if (this.mapElement.type == GeometryBuffer.GeometryType.NONE) continue;
            this.mTileDataSink.process(this.mapElement);
        }
        return true;
    }

    private void decodeGeometry(Geometry<?> geometry) {
        block3: {
            String type;
            block5: {
                block4: {
                    block2: {
                        type = geometry.type();
                        if (!"Polygon".equals(type)) break block2;
                        Polygon p = (Polygon)geometry.getCoordinates();
                        this.decodePolygon(p);
                        break block3;
                    }
                    if (!"MultiPolygon".equals(type)) break block4;
                    MultiPolygon mp = (MultiPolygon)geometry.getCoordinates();
                    int l = mp.getNumGeometries();
                    for (int k = 0; k < l; ++k) {
                        this.decodePolygon(mp.getGeometryN(k));
                    }
                    break block3;
                }
                if (!"LineString".equals(type)) break block5;
                LineString ls = (LineString)geometry.getCoordinates();
                this.decodeLineString(ls);
                break block3;
            }
            if (!"MultiLineString".equals(type)) break block3;
            MultiLineString ml = (MultiLineString)geometry.getCoordinates();
            int n = ml.getNumGeometries();
            for (int k = 0; k < n; ++k) {
                this.decodeLineString(ml.getGeometryN(k));
            }
        }
    }

    private void decodeLineString(LineString l) {
        this.mapElement.startLine();
        int m = l.length();
        for (int j = 0; j < m; ++j) {
            this.decodePoint((LngLat)l.get(j));
        }
    }

    private void decodePolygon(Polygon p) {
        int n = p.getNumRings();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.mapElement.startHole();
            } else {
                this.mapElement.startPolygon();
            }
            LineString ls = p.getRing(i);
            int m = ls.length() - 1;
            for (int j = 0; j < m; ++j) {
                this.decodePoint((LngLat)ls.get(j));
            }
        }
    }

    private void decodePoint(LngLat point) {
        float x = (float)((MercatorProjection.longitudeToX((double)point.getLongitude()) - this.mTileX) * this.mTileScale);
        float y = (float)((MercatorProjection.latitudeToY((double)point.getLatitude()) - this.mTileY) * this.mTileScale);
        this.mapElement.addPoint(x, y);
    }

    public boolean decode(Tile tile, ITileDataSink sink, InputStream is) throws IOException {
        return false;
    }
}

