/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.client;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.oscim.backend.canvas.Bitmap;

public class GwtBitmap
implements Bitmap {
    Pixmap pixmap;
    Image image;
    boolean disposable;

    public GwtBitmap(Image data) {
        ImageElement imageElement = ImageElement.as((Element)data.getElement());
        this.pixmap = new Pixmap(imageElement);
        this.image = data;
    }

    public GwtBitmap(int width, int height, int format) {
        this.pixmap = new Pixmap(width, height, null);
    }

    public GwtBitmap(String fileName) {
        FileHandle handle = Gdx.files.internal(fileName);
        this.pixmap = new Pixmap(handle);
        this.disposable = true;
    }

    public int getWidth() {
        return this.pixmap.getWidth();
    }

    public int getHeight() {
        return this.pixmap.getHeight();
    }

    public void recycle() {
        this.pixmap.dispose();
        if (this.image != null) {
            RootPanel.get().remove((Widget)this.image);
        }
    }

    public int[] getPixels() {
        return null;
    }

    public void eraseColor(int color) {
    }

    public void uploadToTexture(boolean replace) {
        Gdx.gl.glTexImage2D(3553, 0, this.pixmap.getGLInternalFormat(), this.pixmap.getWidth(), this.pixmap.getHeight(), 0, this.pixmap.getGLFormat(), this.pixmap.getGLType(), this.pixmap.getPixels());
        if (this.disposable || this.image != null) {
            this.pixmap.dispose();
            if (this.image != null) {
                RootPanel.get().remove((Widget)this.image);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public byte[] getPngEncodedData() {
        return null;
    }

    public void scaleTo(int width, int height) {
    }
}

