/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullParserFactory {
    public static final String PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    protected ArrayList parserClasses;
    protected ArrayList serializerClasses;
    protected String classNamesLocation = null;
    protected HashMap<String, Boolean> features = new HashMap();

    protected XmlPullParserFactory() {
        this.parserClasses = new ArrayList();
        this.serializerClasses = new ArrayList();
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        this.features.put(name, state);
    }

    public boolean getFeature(String name) {
        Boolean value = this.features.get(name);
        return value != null ? value : false;
    }

    public void setNamespaceAware(boolean awareness) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", awareness);
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
    }

    public void setValidating(boolean validating) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", validating);
    }

    public boolean isValidating() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    public XmlPullParser newPullParser() throws XmlPullParserException {
        XmlPullParser pp = this.getParserInstance();
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            pp.setFeature(entry.getKey(), entry.getValue());
        }
        return pp;
    }

    private XmlPullParser getParserInstance() throws XmlPullParserException {
        ArrayList exceptions = null;
        if (this.parserClasses != null && !this.parserClasses.isEmpty()) {
            exceptions = new ArrayList();
            for (Object e : this.parserClasses) {
            }
        }
        throw XmlPullParserFactory.newInstantiationException("Invalid parser class list", exceptions);
    }

    private XmlSerializer getSerializerInstance() throws XmlPullParserException {
        ArrayList exceptions = null;
        if (this.serializerClasses != null && !this.serializerClasses.isEmpty()) {
            exceptions = new ArrayList();
            for (Object e : this.serializerClasses) {
            }
        }
        throw XmlPullParserFactory.newInstantiationException("Invalid serializer class list", exceptions);
    }

    private static XmlPullParserException newInstantiationException(String message, ArrayList<Exception> exceptions) {
        if (exceptions == null || exceptions.isEmpty()) {
            return new XmlPullParserException(message);
        }
        XmlPullParserException exception = new XmlPullParserException(message);
        for (Exception ex : exceptions) {
            exception.addSuppressed(ex);
        }
        return exception;
    }

    public XmlSerializer newSerializer() throws XmlPullParserException {
        return this.getSerializerInstance();
    }

    public static XmlPullParserFactory newInstance() throws XmlPullParserException {
        return new XmlPullParserFactory();
    }

    public static XmlPullParserFactory newInstance(String unused, Class unused2) throws XmlPullParserException {
        return XmlPullParserFactory.newInstance();
    }
}

