/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.client;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import java.util.HashMap;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.map.Map;

public class MapUrl
extends Timer {
    private int curLon;
    private int curLat;
    private int curZoom;
    private int curTilt;
    private int curRot;
    private int curRoll;
    private MapPosition pos = new MapPosition();
    private final Map mMap;
    private String mParams = "";
    public final HashMap<String, String> params = new HashMap();

    public MapUrl(Map map) {
        this.mMap = map;
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public void parseUrl(MapPosition pos) {
        if (Window.Location.getHash() == null) {
            return;
        }
        String hash = Window.Location.getHash();
        hash = hash.substring(1);
        String[] urlParams = null;
        urlParams = hash.split("&");
        if (urlParams.length == 1) {
            urlParams = hash.split(",");
        }
        double lat = pos.getLatitude();
        double lon = pos.getLongitude();
        float rotation = pos.bearing;
        float tilt = pos.tilt;
        float roll = pos.roll;
        int zoom = pos.zoomLevel;
        for (String p : urlParams) {
            try {
                if (p.startsWith("lat=")) {
                    lat = Double.parseDouble(p.substring(4));
                    continue;
                }
                if (p.startsWith("lon=")) {
                    lon = Double.parseDouble(p.substring(4));
                    continue;
                }
                if (p.startsWith("scale=")) {
                    zoom = Integer.parseInt(p.substring(6));
                    continue;
                }
                if (p.startsWith("rot=")) {
                    rotation = Float.parseFloat(p.substring(4));
                    continue;
                }
                if (p.startsWith("tilt=")) {
                    tilt = Float.parseFloat(p.substring(5));
                    continue;
                }
                if (p.startsWith("roll=")) {
                    roll = Float.parseFloat(p.substring(5));
                    continue;
                }
                String[] opt = p.split("=");
                if (opt.length > 1) {
                    this.params.put(opt[0], opt[1]);
                } else {
                    this.params.put(opt[0], null);
                }
                this.mParams = this.mParams + p + "&";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        pos.setPosition(lat, lon);
        pos.setZoomLevel(zoom);
        pos.set(MercatorProjection.longitudeToX((double)lon), MercatorProjection.latitudeToY((double)lat), (double)(1 << zoom), rotation, tilt, roll);
    }

    public void run() {
        this.mMap.viewport().getMapPosition(this.pos);
        int lat = (int)(this.pos.getLatitude() * 1000.0);
        int lon = (int)(this.pos.getLongitude() * 1000.0);
        int tilt = (int)this.pos.tilt;
        int rot = (int)this.pos.bearing;
        int roll = (int)this.pos.roll;
        if (this.curZoom != this.pos.zoomLevel || this.curLat != lat || this.curLon != lon || this.curTilt != tilt || this.curRot != rot || this.curRoll != roll) {
            this.curLat = lat;
            this.curLon = lon;
            this.curZoom = this.pos.zoomLevel;
            this.curTilt = tilt;
            this.curRot = rot;
            this.curRoll = roll;
            String newURL = Window.Location.createUrlBuilder().setHash(this.mParams + "scale=" + this.pos.zoomLevel + "&rot=" + this.curRot + "&tilt=" + this.curTilt + "&roll=" + this.curRoll + "&lat=" + (float)this.curLat / 1000.0f + "&lon=" + (float)this.curLon / 1000.0f).buildString();
            Window.Location.replace((String)newURL);
        }
    }
}

