/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Timer;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MapElement;
import org.oscim.layers.tile.LoadDelayTask;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.renderer.MapRenderer;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileLoader
implements ITileDataSink {
    static final Logger log = LoggerFactory.getLogger(TileLoader.class);
    private final TileManager mTileManager;
    private Timer mTimer;
    boolean isInterrupted;
    boolean mPausing;
    protected boolean mWorking;
    protected MapTile mTile;
    public static long lastLoadTime;

    public TileLoader(TileManager tileManager) {
        if (this.mTimer == null) {
            this.mTimer = new Timer();
        }
        this.mTileManager = tileManager;
    }

    public abstract void dispose();

    protected abstract boolean loadTile(MapTile var1);

    public void finish() {
        this.isInterrupted = true;
    }

    public void cancel() {
        this.isInterrupted = true;
    }

    public boolean isCanceled() {
        return this.mPausing;
    }

    public boolean isPausing() {
        return this.mPausing;
    }

    public void pause() {
        this.mPausing = true;
    }

    public void proceed() {
        this.mPausing = false;
        this.mWorking = false;
        if (this.mTileManager.hasTileJobs()) {
            this.go();
        }
    }

    public void awaitPausing() {
    }

    public void start() {
        this.mPausing = false;
    }

    public void go() {
        if (this.mWorking) {
            return;
        }
        this.mTile = this.mTileManager.getTileJob();
        if (this.mTile == null) {
            return;
        }
        try {
            this.loadTile(this.mTile);
            this.mWorking = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.completed(QueryResult.FAILED);
        }
    }

    public void completed(QueryResult result) {
        long now;
        lastLoadTime = now = MapRenderer.frametime;
        this.mTileManager.jobCompleted(this.mTile, result);
        this.mTile = null;
        this.mWorking = false;
        if (this.mPausing || !this.mTileManager.hasTileJobs()) {
            return;
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                TileLoader.this.go();
            }
        });
    }

    public void process(MapElement element) {
    }

    public void setTileImage(Bitmap bitmap) {
    }

    public static void postLoadDelay(LoadDelayTask<?> task) {
        Gdx.app.postRunnable(task);
    }
}

