/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.jsonp.client.JsonpRequest;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.io.InputStream;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.geojson.GeoJsonTileDecoder;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTileDataSource
implements ITileDataSource {
    static final Logger log = LoggerFactory.getLogger(JsonTileDataSource.class);
    protected final GeoJsonTileDecoder mTileDecoder;
    protected final UrlTileSource mTileSource;
    private ITileDataSink mSink;
    private MapTile mTile;
    boolean mFinished;
    JsonpRequest<JavaScriptObject> mRequestHandle;

    public JsonTileDataSource(GeoJsonTileSource tileSource) {
        this.mTileSource = tileSource;
        this.mTileDecoder = new GeoJsonTileDecoder(tileSource);
    }

    UrlTileSource getTileSource() {
        return this.mTileSource;
    }

    public void query(MapTile tile, ITileDataSink sink) {
        this.mTile = tile;
        this.mSink = sink;
        try {
            this.doGet(this.mTileSource.getTileUrl((Tile)tile));
        }
        catch (Exception e) {
            e.printStackTrace();
            sink.completed(QueryResult.FAILED);
        }
    }

    public void process(InputStream is) {
    }

    public void dispose() {
        this.mFinished = true;
    }

    public void cancel() {
        this.mFinished = true;
    }

    void doGet(final String url) {
        JsonpRequestBuilder builder = new JsonpRequestBuilder();
        this.mRequestHandle = builder.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

            public void onFailure(Throwable caught) {
                JsonTileDataSource.this.mSink.completed(QueryResult.FAILED);
                log.debug("fail! {} {}", JsonTileDataSource.this.mRequestHandle, (Object)caught.getMessage());
            }

            public void onSuccess(JavaScriptObject jso) {
                if (JsonTileDataSource.this.mTile.state(1)) {
                    log.debug("tile cleared {}", (Object)url);
                    JsonTileDataSource.this.mSink.completed(QueryResult.FAILED);
                    return;
                }
                if (jso == null) {
                    log.debug("Couldn't retrieve JSON for {}", (Object)url);
                    JsonTileDataSource.this.mSink.completed(QueryResult.FAILED);
                    return;
                }
                try {
                    if (JsonTileDataSource.this.mTileDecoder.decode((Tile)JsonTileDataSource.this.mTile, JsonTileDataSource.this.mSink, jso)) {
                        JsonTileDataSource.this.mSink.completed(QueryResult.SUCCESS);
                        return;
                    }
                }
                catch (Exception e) {
                    log.debug("Couldn't retrieve JSON for {} {}" + url, (Throwable)e);
                    JsonTileDataSource.this.mSink.completed(QueryResult.FAILED);
                }
            }
        });
    }
}

