/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.gwt.DefaultGwtAudio;
import com.badlogic.gdx.backends.gwt.DefaultGwtInput;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtAudio;
import com.badlogic.gdx.backends.gwt.GwtClipboard;
import com.badlogic.gdx.backends.gwt.GwtFiles;
import com.badlogic.gdx.backends.gwt.GwtGraphics;
import com.badlogic.gdx.backends.gwt.GwtNet;
import com.badlogic.gdx.backends.gwt.GwtPreferences;
import com.badlogic.gdx.backends.gwt.preloader.Preloader;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class GwtApplication
implements EntryPoint,
Application {
    private ApplicationListener listener;
    GwtApplicationConfiguration config;
    GwtGraphics graphics;
    private DefaultGwtInput input;
    private GwtNet net;
    private Panel root = null;
    private TextArea log = null;
    private int logLevel = 1;
    private ApplicationLogger applicationLogger;
    private Array<Runnable> runnables = new Array();
    private Array<Runnable> runnablesHelper = new Array();
    private Array<LifecycleListener> lifecycleListeners = new Array();
    private int lastWidth;
    private int lastHeight;
    Preloader preloader;
    private static AgentInfo agentInfo;
    private ObjectMap<String, Preferences> prefs = new ObjectMap();
    private Clipboard clipboard;
    LoadingListener loadingListener;
    long loadStart = TimeUtils.nanoTime();

    public abstract GwtApplicationConfiguration getConfig();

    public String getPreloaderBaseURL() {
        return GWT.getHostPageBaseURL() + "assets/";
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public abstract ApplicationListener createApplicationListener();

    public void onModuleLoad() {
        agentInfo = GwtApplication.computeAgentInfo();
        this.listener = this.createApplicationListener();
        this.config = this.getConfig();
        this.log = this.config.log;
        this.addEventListeners();
        if (this.config.rootPanel != null) {
            this.root = this.config.rootPanel;
        } else {
            Element element = Document.get().getElementById("embed-" + GWT.getModuleName());
            if (element == null) {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                RootPanel.get().add((Widget)panel);
                RootPanel.get().setWidth("" + this.config.width + "px");
                RootPanel.get().setHeight("" + this.config.height + "px");
                this.root = panel;
            } else {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                element.appendChild((Node)panel.getElement());
                this.root = panel;
            }
        }
        final Preloader.PreloaderCallback callback = this.getPreloaderCallback();
        this.preloader = this.createPreloader();
        this.preloader.preload("assets.txt", new Preloader.PreloaderCallback(){

            public void error(String file) {
                callback.error(file);
            }

            public void update(Preloader.PreloaderState state) {
                callback.update(state);
                if (state.hasEnded()) {
                    GwtApplication.this.getRootPanel().clear();
                    if (GwtApplication.this.loadingListener != null) {
                        GwtApplication.this.loadingListener.beforeSetup();
                    }
                    GwtApplication.this.setupLoop();
                    if (GwtApplication.this.loadingListener != null) {
                        GwtApplication.this.loadingListener.afterSetup();
                    }
                }
            }
        });
    }

    public Widget getNoWebGLSupportWidget() {
        return new Label("Sorry, your browser doesn't seem to support WebGL");
    }

    void setupLoop() {
        try {
            this.graphics = new GwtGraphics(this.root, this.config);
        }
        catch (Throwable e) {
            this.root.clear();
            this.root.add(this.getNoWebGLSupportWidget());
            return;
        }
        this.lastWidth = this.graphics.getWidth();
        this.lastHeight = this.graphics.getHeight();
        Gdx.app = this;
        Gdx.audio = this.createAudio();
        Gdx.graphics = this.graphics;
        Gdx.gl = Gdx.gl20 = this.graphics.getGL20();
        Gdx.files = new GwtFiles(this.preloader);
        this.input = this.createInput(this.graphics.canvas, this.config);
        Gdx.input = this.input;
        this.net = new GwtNet(this.config);
        Gdx.net = this.net;
        this.clipboard = new GwtClipboard();
        this.updateLogLabelSize();
        try {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        }
        catch (Throwable t) {
            this.error("GwtApplication", "exception: " + t.getMessage(), t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        AnimationScheduler.get().requestAnimationFrame(new AnimationScheduler.AnimationCallback(){

            public void execute(double timestamp) {
                try {
                    GwtApplication.this.mainLoop();
                }
                catch (Throwable t) {
                    GwtApplication.this.error("GwtApplication", "exception: " + t.getMessage(), t);
                    throw new RuntimeException(t);
                }
                AnimationScheduler.get().requestAnimationFrame((AnimationScheduler.AnimationCallback)this, (Element)GwtApplication.this.graphics.canvas);
            }
        }, (Element)this.graphics.canvas);
    }

    void mainLoop() {
        this.graphics.update();
        if (Gdx.graphics.getWidth() != this.lastWidth || Gdx.graphics.getHeight() != this.lastHeight) {
            this.listener.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            this.lastWidth = this.graphics.getWidth();
            this.lastHeight = this.graphics.getHeight();
            Gdx.gl.glViewport(0, 0, this.lastWidth, this.lastHeight);
        }
        this.runnablesHelper.addAll(this.runnables);
        this.runnables.clear();
        for (int i = 0; i < this.runnablesHelper.size; ++i) {
            ((Runnable)this.runnablesHelper.get(i)).run();
        }
        this.runnablesHelper.clear();
        ++this.graphics.frameId;
        this.listener.render();
        this.input.reset();
    }

    public Panel getRootPanel() {
        return this.root;
    }

    public Preloader createPreloader() {
        return new Preloader(this.getPreloaderBaseURL());
    }

    public Preloader.PreloaderCallback getPreloaderCallback() {
        VerticalPanel preloaderPanel = new VerticalPanel();
        preloaderPanel.setStyleName("gdx-preloader");
        Image logo = new Image(GWT.getModuleBaseURL() + "logo.png");
        logo.setStyleName("logo");
        preloaderPanel.add((Widget)logo);
        SimplePanel meterPanel = new SimplePanel();
        meterPanel.setStyleName("gdx-meter");
        meterPanel.addStyleName("red");
        InlineHTML meter = new InlineHTML();
        final Style meterStyle = meter.getElement().getStyle();
        meterStyle.setWidth(0.0, Style.Unit.PCT);
        meterPanel.add((Widget)meter);
        preloaderPanel.add((Widget)meterPanel);
        this.getRootPanel().add((Widget)preloaderPanel);
        return new Preloader.PreloaderCallback(){

            public void error(String file) {
                System.out.println("error: " + file);
            }

            public void update(Preloader.PreloaderState state) {
                meterStyle.setWidth((double)(100.0f * state.getProgress()), Style.Unit.PCT);
            }
        };
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Audio getAudio() {
        return Gdx.audio;
    }

    public Input getInput() {
        return Gdx.input;
    }

    public Files getFiles() {
        return Gdx.files;
    }

    public Net getNet() {
        return Gdx.net;
    }

    private void updateLogLabelSize() {
        if (this.log != null) {
            if (this.graphics != null) {
                this.log.setSize(this.graphics.getWidth() + "px", "200px");
            } else {
                this.log.setSize("400px", "200px");
            }
        }
    }

    private void checkLogLabel() {
        if (this.log == null) {
            this.log = new TextArea();
            if (this.graphics != null) {
                this.log.setSize(this.graphics.getWidth() + "px", "200px");
            } else {
                this.log.setSize("400px", "200px");
            }
            this.log.setReadOnly(true);
            this.root.add((Widget)this.log);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message);
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + this.getMessages(exception) + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n" + exception.getMessage());
            System.out.println(this.getStackTrace(exception));
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + this.getMessages(exception) + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.err.println(tag + ": " + message + "\n" + exception.getMessage() + "\n");
            System.out.println(this.getStackTrace(exception));
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n");
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + this.getMessages(exception) + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n" + exception.getMessage());
            System.out.println(this.getStackTrace(exception));
        }
    }

    private String getMessages(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        while (e != null) {
            buffer.append(e.getMessage() + "\n");
            e = e.getCause();
        }
        return buffer.toString();
    }

    private String getStackTrace(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        for (StackTraceElement trace : e.getStackTrace()) {
            buffer.append(trace.toString() + "\n");
        }
        return buffer.toString();
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.WebGL;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return 0L;
    }

    public long getNativeHeap() {
        return 0L;
    }

    public Preferences getPreferences(String name) {
        Preferences pref = (Preferences)this.prefs.get((Object)name);
        if (pref == null) {
            pref = new GwtPreferences(name);
            this.prefs.put((Object)name, (Object)pref);
        }
        return pref;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void postRunnable(Runnable runnable) {
        this.runnables.add((Object)runnable);
    }

    public void exit() {
    }

    public static AgentInfo agentInfo() {
        return agentInfo;
    }

    private static native AgentInfo computeAgentInfo();

    public String getBaseUrl() {
        return this.preloader.baseUrl;
    }

    public Preloader getPreloader() {
        return this.preloader;
    }

    public CanvasElement getCanvasElement() {
        return this.graphics.canvas;
    }

    public LoadingListener getLoadingListener() {
        return this.loadingListener;
    }

    public void setLoadingListener(LoadingListener loadingListener) {
        this.loadingListener = loadingListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public static native void consoleLog(String var0);

    private native void addEventListeners();

    private void onVisibilityChange(boolean visible) {
        if (visible) {
            for (LifecycleListener listener : this.lifecycleListeners) {
                listener.resume();
            }
            this.listener.resume();
        } else {
            for (LifecycleListener listener : this.lifecycleListeners) {
                listener.pause();
            }
            this.listener.pause();
        }
    }

    protected GwtAudio createAudio() {
        return new DefaultGwtAudio();
    }

    protected DefaultGwtInput createInput(CanvasElement canvas, GwtApplicationConfiguration config) {
        return new DefaultGwtInput(canvas, config);
    }

    public static interface LoadingListener {
        public void beforeSetup();

        public void afterSetup();
    }

    public static class AgentInfo
    extends JavaScriptObject {
        public final native boolean isFirefox();

        public final native boolean isChrome();

        public final native boolean isSafari();

        public final native boolean isOpera();

        public final native boolean isIE();

        public final native boolean isMacOS();

        public final native boolean isLinux();

        public final native boolean isWindows();

        protected AgentInfo() {
        }
    }
}

