/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtCursor;
import com.badlogic.gdx.backends.gwt.GwtGL20Debug;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.webgl.client.WebGLContextAttributes;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import org.oscim.gdx.client.GdxGL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtGraphics
implements Graphics {
    static final Logger log = LoggerFactory.getLogger(GwtGraphics.class);
    CanvasElement canvas;
    WebGLRenderingContext context;
    GLVersion glVersion;
    GL20 gl;
    String extensions;
    float fps = 0.0f;
    long lastTimeStamp = System.currentTimeMillis();
    long frameId = -1L;
    float deltaTime = 0.0f;
    float time = 0.0f;
    int frames;
    GwtApplicationConfiguration config;
    double pixelRatio = GwtGraphics.getDevicePixelRatioJSNI();

    public GwtGraphics(Panel root, GwtApplicationConfiguration config) {
        if (config.canvasId == null) {
            Canvas canvasWidget = Canvas.createIfSupported();
            if (canvasWidget == null) {
                throw new GdxRuntimeException("Canvas not supported");
            }
            this.canvas = canvasWidget.getCanvasElement();
            root.add((Widget)canvasWidget);
        } else {
            this.canvas = (CanvasElement)Document.get().getElementById(config.canvasId);
            this.canvas.setWidth((int)((double)config.width * this.pixelRatio));
            this.canvas.setHeight((int)((double)config.height * this.pixelRatio));
            this.canvas.getStyle().setWidth((double)config.width, Style.Unit.PX);
            this.canvas.getStyle().setHeight((double)config.height, Style.Unit.PX);
        }
        this.config = config;
        WebGLContextAttributes attributes = WebGLContextAttributes.create();
        attributes.setAntialias(config.antialiasing);
        attributes.setStencil(config.stencil);
        attributes.setAlpha(false);
        attributes.setPremultipliedAlpha(false);
        attributes.setPreserveDrawingBuffer(false);
        this.context = WebGLRenderingContext.getContext((CanvasElement)this.canvas, (WebGLContextAttributes)attributes);
        if (this.context == null) {
            throw new GdxRuntimeException("Could not create Canvas for " + attributes);
        }
        this.context.viewport(0, 0, config.width, config.height);
        if (this.context.getExtension("OES_standard_derivatives") == null) {
            log.error("Missing gl extension for OES_standard_derivatives");
        }
        if (this.context.getExtension("WEBKIT_WEBGL_depth_texture") == null) {
            log.error("Missing gl extension for WEBKIT_WEBGL_depth_texture");
        }
        this.gl = config.useDebugGL ? new GwtGL20Debug(this.context) : new GdxGL(this.context);
        String versionString = this.gl.glGetString(7938);
        String vendorString = this.gl.glGetString(7936);
        String rendererString = this.gl.glGetString(7937);
        this.glVersion = new GLVersion(Application.ApplicationType.WebGL, versionString, vendorString, rendererString);
    }

    public static native double getDevicePixelRatioJSNI();

    public static native int getWindowWidthJSNI();

    public static native int getWindowHeightJSNI();

    public WebGLRenderingContext getContext() {
        return this.context;
    }

    public GL20 getGL20() {
        return this.gl;
    }

    public void setGL20(GL20 gl20) {
        this.gl = gl20;
        Gdx.gl = gl20;
        Gdx.gl20 = gl20;
    }

    public boolean isGL30Available() {
        return false;
    }

    public GL30 getGL30() {
        return null;
    }

    public void setGL30(GL30 gl30) {
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public int getBackBufferWidth() {
        return this.canvas.getWidth();
    }

    public int getBackBufferHeight() {
        return this.canvas.getHeight();
    }

    public float getBackBufferScale() {
        return 0.0f;
    }

    public int getSafeInsetLeft() {
        return 0;
    }

    public int getSafeInsetTop() {
        return 0;
    }

    public int getSafeInsetBottom() {
        return 0;
    }

    public int getSafeInsetRight() {
        return 0;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return (int)this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.WebGL;
    }

    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    public float getPpiX() {
        return 96.0f;
    }

    public float getPpiY() {
        return 96.0f;
    }

    public float getPpcX() {
        return 37.795277f;
    }

    public float getPpcY() {
        return 37.795277f;
    }

    public boolean supportsDisplayModeChange() {
        return this.supportsFullscreenJSNI();
    }

    private native boolean supportsFullscreenJSNI();

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{new Graphics.DisplayMode(this.getScreenWidthJSNI(), this.getScreenHeightJSNI(), 60, 8){}};
    }

    private native int getScreenWidthJSNI();

    private native int getScreenHeightJSNI();

    private native boolean isFullscreenJSNI();

    private void fullscreenChanged() {
        if (!this.isFullscreen()) {
            this.canvas.setWidth(this.config.width);
            this.canvas.setHeight(this.config.height);
            if (this.config.fullscreenOrientation != null) {
                this.unlockOrientation();
            }
        } else if (this.config.fullscreenOrientation != null) {
            this.lockOrientation(this.config.fullscreenOrientation);
        }
    }

    private native boolean setFullscreenJSNI(GwtGraphics var1, CanvasElement var2);

    private native void exitFullscreen();

    public Graphics.DisplayMode getDisplayMode() {
        return new Graphics.DisplayMode(this.getScreenWidthJSNI(), this.getScreenHeightJSNI(), 60, 8){};
    }

    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        if (displayMode.width != this.getScreenWidthJSNI() && displayMode.height != this.getScreenHeightJSNI()) {
            return false;
        }
        return this.setFullscreenJSNI(this, this.canvas);
    }

    public boolean setWindowedMode(int width, int height) {
        if (this.isFullscreenJSNI()) {
            this.exitFullscreen();
        }
        this.canvas.setWidth(width);
        this.canvas.setHeight(height);
        return true;
    }

    public Graphics.Monitor getPrimaryMonitor() {
        return new GwtMonitor(0, 0, "Primary Monitor");
    }

    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    public boolean lockOrientation(OrientationLockType orientation) {
        return this.lockOrientationJSNI(orientation.getName());
    }

    public boolean unlockOrientation() {
        return this.unlockOrientationJSNI();
    }

    private native boolean lockOrientationJSNI(String var1);

    private native boolean unlockOrientationJSNI();

    public Graphics.BufferFormat getBufferFormat() {
        return new Graphics.BufferFormat(8, 8, 8, 0, 16, this.config.stencil ? 8 : 0, 0, false);
    }

    public boolean supportsExtension(String extensionName) {
        return this.context.getExtension(extensionName) != null;
    }

    public void update() {
        long currTimeStamp = System.currentTimeMillis();
        this.deltaTime = (float)(currTimeStamp - this.lastTimeStamp) / 1000.0f;
        this.lastTimeStamp = currTimeStamp;
        this.time += this.deltaTime;
        ++this.frames;
        if (this.time > 1.0f) {
            this.fps = this.frames;
            this.time = 0.0f;
            this.frames = 0;
        }
    }

    public void setTitle(String title) {
    }

    public void setUndecorated(boolean undecorated) {
    }

    public void setResizable(boolean resizable) {
    }

    public void setVSync(boolean vsync) {
    }

    public void setForegroundFPS(int fps) {
    }

    public float getDensity() {
        return 0.6f;
    }

    public void setContinuousRendering(boolean isContinuous) {
    }

    public boolean isContinuousRendering() {
        return false;
    }

    public void requestRendering() {
    }

    public float getRawDeltaTime() {
        return this.getDeltaTime();
    }

    public boolean isFullscreen() {
        return this.isFullscreenJSNI();
    }

    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return new GwtCursor(pixmap, xHotspot, yHotspot);
    }

    public void setCursor(Cursor cursor) {
        ((GwtApplication)Gdx.app).graphics.canvas.getStyle().setProperty("cursor", ((GwtCursor)cursor).cssCursorProperty);
    }

    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
        ((GwtApplication)Gdx.app).graphics.canvas.getStyle().setProperty("cursor", GwtCursor.getNameForSystemCursor((Cursor.SystemCursor)systemCursor));
    }

    static class GwtMonitor
    extends Graphics.Monitor {
        protected GwtMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }

    public static enum OrientationLockType {
        LANDSCAPE("landscape"),
        PORTRAIT("portrait"),
        PORTRAIT_PRIMARY("portrait-primary"),
        PORTRAIT_SECONDARY("portrait-secondary"),
        LANDSCAPE_PRIMARY("landscape-primary"),
        LANDSCAPE_SECONDARY("landscape-secondary");

        private final String name;

        private OrientationLockType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

