/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.CanvasPixelArray;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.VideoElement;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class Pixmap
implements Disposable {
    public static Map<Integer, Pixmap> pixmaps = new HashMap<Integer, Pixmap>();
    static int nextId = 0;
    int width;
    int height;
    Format format;
    Canvas canvas;
    Context2d context;
    int id;
    IntBuffer buffer;
    int r = 255;
    int g = 255;
    int b = 255;
    float a;
    String color = Pixmap.make(this.r, this.g, this.b, this.a);
    static String clearColor = Pixmap.make(255, 255, 255, 1.0f);
    static Blending blending;
    CanvasPixelArray pixels;
    private ImageElement imageElement;

    public Pixmap(FileHandle file) {
        this((ImageElement)((GwtFileHandle)file).preloader.images.get((Object)file.path()));
        if (this.imageElement == null) {
            throw new GdxRuntimeException("Couldn't load image '" + file.path() + "', file does not exist");
        }
    }

    public Context2d getContext() {
        this.ensureCanvasExists();
        return this.context;
    }

    private static Context2d.Composite getComposite() {
        return Context2d.Composite.SOURCE_OVER;
    }

    public Pixmap(ImageElement img) {
        this(-1, -1, img);
    }

    public Pixmap(int width, int height, Format format) {
        this(width, height, (ImageElement)null);
    }

    private Pixmap(int width, int height, ImageElement imageElement) {
        this.imageElement = imageElement;
        this.width = imageElement != null ? imageElement.getWidth() : width;
        this.height = imageElement != null ? imageElement.getHeight() : height;
        this.buffer = BufferUtils.newIntBuffer((int)1);
        this.id = nextId++;
        this.buffer.put(0, this.id);
        pixmaps.put(this.id, this);
    }

    private void create() {
        this.canvas = Canvas.createIfSupported();
        this.canvas.getCanvasElement().setWidth(this.width);
        this.canvas.getCanvasElement().setHeight(this.height);
        this.context = this.canvas.getContext2d();
        this.context.setGlobalCompositeOperation(Pixmap.getComposite());
    }

    public static String make(int r2, int g2, int b2, float a2) {
        return "rgba(" + r2 + "," + g2 + "," + b2 + "," + a2 + ")";
    }

    public static void setBlending(Blending blending) {
        Pixmap.blending = blending;
        Context2d.Composite composite = Pixmap.getComposite();
        for (Pixmap pixmap : pixmaps.values()) {
            pixmap.ensureCanvasExists();
            pixmap.context.setGlobalCompositeOperation(composite);
        }
    }

    public static Blending getBlending() {
        return blending;
    }

    public static void setFilter(Filter filter) {
    }

    public Format getFormat() {
        return this.format;
    }

    public int getGLInternalFormat() {
        return 6408;
    }

    public int getGLFormat() {
        return 6408;
    }

    public int getGLType() {
        return 5121;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Buffer getPixels() {
        return this.buffer;
    }

    public void dispose() {
        pixmaps.remove(this.id);
    }

    public CanvasElement getCanvasElement() {
        this.ensureCanvasExists();
        return this.canvas.getCanvasElement();
    }

    private void ensureCanvasExists() {
        if (this.canvas == null) {
            this.create();
            if (this.imageElement != null) {
                this.context.setGlobalCompositeOperation(Context2d.Composite.COPY);
                this.context.drawImage(this.imageElement, 0.0, 0.0);
                this.context.setGlobalCompositeOperation(Pixmap.getComposite());
            }
        }
    }

    public boolean canUseImageElement() {
        return this.canvas == null && this.imageElement != null;
    }

    public ImageElement getImageElement() {
        return this.imageElement;
    }

    public boolean canUseVideoElement() {
        return false;
    }

    public VideoElement getVideoElement() {
        return null;
    }

    public void setColor(int color) {
        this.ensureCanvasExists();
        this.r = color >>> 24 & 0xFF;
        this.g = color >>> 16 & 0xFF;
        this.b = color >>> 8 & 0xFF;
        this.a = (float)(color & 0xFF) / 255.0f;
        this.color = Pixmap.make(this.r, this.g, this.b, this.a);
        this.context.setFillStyle(this.color);
        this.context.setStrokeStyle(this.color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.ensureCanvasExists();
        this.r = (int)(r * 255.0f);
        this.g = (int)(g * 255.0f);
        this.b = (int)(b * 255.0f);
        this.a = a;
        this.color = Pixmap.make(this.r, this.g, this.b, this.a);
        this.context.setFillStyle(this.color);
        this.context.setStrokeStyle(this.color);
    }

    public void setColor(Color color) {
        this.setColor(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        this.ensureCanvasExists();
        this.context.clearRect(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        this.rectangle(0, 0, this.getWidth(), this.getHeight(), DrawType.FILL);
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.line(x, y, x2, y2, DrawType.STROKE);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.rectangle(x, y, width, height, DrawType.STROKE);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        CanvasElement image = pixmap.getCanvasElement();
        this.image(image, 0, 0, image.getWidth(), image.getHeight(), x, y, image.getWidth(), image.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        CanvasElement image = pixmap.getCanvasElement();
        this.image(image, srcx, srcy, srcWidth, srcHeight, x, y, srcWidth, srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.image(pixmap.getCanvasElement(), srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.rectangle(x, y, width, height, DrawType.FILL);
    }

    public void drawCircle(int x, int y, int radius) {
        this.circle(x, y, radius, DrawType.STROKE);
    }

    public void fillCircle(int x, int y, int radius) {
        this.circle(x, y, radius, DrawType.FILL);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.triangle(x1, y1, x2, y2, x3, y3, DrawType.FILL);
    }

    public int getPixel(int x, int y) {
        this.ensureCanvasExists();
        if (this.pixels == null) {
            this.pixels = this.context.getImageData(0.0, 0.0, (double)this.width, (double)this.height).getData();
        }
        int i = x * 4 + y * this.width * 4;
        int r = this.pixels.get(i + 0) & 0xFF;
        int g = this.pixels.get(i + 1) & 0xFF;
        int b = this.pixels.get(i + 2) & 0xFF;
        int a = this.pixels.get(i + 3) & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public void drawPixel(int x, int y) {
        this.rectangle(x, y, 1, 1, DrawType.FILL);
    }

    public void drawPixel(int x, int y, int color) {
        this.setColor(color);
        this.drawPixel(x, y);
    }

    private void circle(int x, int y, int radius, DrawType drawType) {
        this.ensureCanvasExists();
        if (blending == Blending.None) {
            this.context.setFillStyle(clearColor);
            this.context.setStrokeStyle(clearColor);
            this.context.setGlobalCompositeOperation("destination-out");
            this.context.beginPath();
            this.context.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2, false);
            this.fillOrStrokePath(drawType);
            this.context.closePath();
            this.context.setFillStyle(this.color);
            this.context.setStrokeStyle(this.color);
            this.context.setGlobalCompositeOperation(Context2d.Composite.SOURCE_OVER);
        }
        this.context.beginPath();
        this.context.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2, false);
        this.fillOrStrokePath(drawType);
        this.context.closePath();
        this.pixels = null;
    }

    private void line(int x, int y, int x2, int y2, DrawType drawType) {
        this.ensureCanvasExists();
        if (blending == Blending.None) {
            this.context.setFillStyle(clearColor);
            this.context.setStrokeStyle(clearColor);
            this.context.setGlobalCompositeOperation("destination-out");
            this.context.beginPath();
            this.context.moveTo((double)x, (double)y);
            this.context.lineTo((double)x2, (double)y2);
            this.fillOrStrokePath(drawType);
            this.context.closePath();
            this.context.setFillStyle(this.color);
            this.context.setStrokeStyle(this.color);
            this.context.setGlobalCompositeOperation(Context2d.Composite.SOURCE_OVER);
        }
        this.context.beginPath();
        this.context.moveTo((double)x, (double)y);
        this.context.lineTo((double)x2, (double)y2);
        this.fillOrStrokePath(drawType);
        this.context.closePath();
        this.pixels = null;
    }

    private void rectangle(int x, int y, int width, int height, DrawType drawType) {
        this.ensureCanvasExists();
        if (blending == Blending.None) {
            this.context.setFillStyle(clearColor);
            this.context.setStrokeStyle(clearColor);
            this.context.setGlobalCompositeOperation("destination-out");
            this.context.beginPath();
            this.context.rect((double)x, (double)y, (double)width, (double)height);
            this.fillOrStrokePath(drawType);
            this.context.closePath();
            this.context.setFillStyle(this.color);
            this.context.setStrokeStyle(this.color);
            this.context.setGlobalCompositeOperation(Context2d.Composite.SOURCE_OVER);
        }
        this.context.beginPath();
        this.context.rect((double)x, (double)y, (double)width, (double)height);
        this.fillOrStrokePath(drawType);
        this.context.closePath();
        this.pixels = null;
    }

    private void triangle(int x1, int y1, int x2, int y2, int x3, int y3, DrawType drawType) {
        this.ensureCanvasExists();
        if (blending == Blending.None) {
            this.context.setFillStyle(clearColor);
            this.context.setStrokeStyle(clearColor);
            this.context.setGlobalCompositeOperation("destination-out");
            this.context.beginPath();
            this.context.moveTo((double)x1, (double)y1);
            this.context.lineTo((double)x2, (double)y2);
            this.context.lineTo((double)x3, (double)y3);
            this.context.lineTo((double)x1, (double)y1);
            this.fillOrStrokePath(drawType);
            this.context.closePath();
            this.context.setFillStyle(this.color);
            this.context.setStrokeStyle(this.color);
            this.context.setGlobalCompositeOperation(Context2d.Composite.SOURCE_OVER);
        }
        this.context.beginPath();
        this.context.moveTo((double)x1, (double)y1);
        this.context.lineTo((double)x2, (double)y2);
        this.context.lineTo((double)x3, (double)y3);
        this.context.lineTo((double)x1, (double)y1);
        this.fillOrStrokePath(drawType);
        this.context.closePath();
        this.pixels = null;
    }

    private void image(CanvasElement image, int srcX, int srcY, int srcWidth, int srcHeight, int dstX, int dstY, int dstWidth, int dstHeight) {
        this.ensureCanvasExists();
        if (blending == Blending.None) {
            this.context.setFillStyle(clearColor);
            this.context.setStrokeStyle(clearColor);
            this.context.setGlobalCompositeOperation("destination-out");
            this.context.beginPath();
            this.context.rect((double)dstX, (double)dstY, (double)dstWidth, (double)dstHeight);
            this.fillOrStrokePath(DrawType.FILL);
            this.context.closePath();
            this.context.setFillStyle(this.color);
            this.context.setStrokeStyle(this.color);
            this.context.setGlobalCompositeOperation(Context2d.Composite.SOURCE_OVER);
        }
        this.context.drawImage(image, (double)srcX, (double)srcY, (double)srcWidth, (double)srcHeight, (double)dstX, (double)dstY, (double)dstWidth, (double)dstHeight);
        this.pixels = null;
    }

    private void fillOrStrokePath(DrawType drawType) {
        this.ensureCanvasExists();
        switch (drawType) {
            case FILL: {
                this.context.fill();
                break;
            }
            case STROKE: {
                this.context.stroke();
            }
        }
    }

    private static enum DrawType {
        FILL,
        STROKE;

    }

    public static enum Filter {
        NearestNeighbour,
        BiLinear;

    }

    public static enum Blending {
        None,
        SourceOver;

    }

    public static enum Format {
        Alpha,
        Intensity,
        LuminanceAlpha,
        RGB565,
        RGBA4444,
        RGB888,
        RGBA8888;


        public static int toGlFormat(Format format) {
            if (format == Alpha) {
                return 6406;
            }
            if (format == Intensity) {
                return 6406;
            }
            if (format == LuminanceAlpha) {
                return 6410;
            }
            if (format == RGB565) {
                return 6407;
            }
            if (format == RGB888) {
                return 6407;
            }
            if (format == RGBA4444) {
                return 6408;
            }
            if (format == RGBA8888) {
                return 6408;
            }
            throw new GdxRuntimeException("unknown format: " + (Object)((Object)format));
        }

        public static int toGlType(Format format) {
            if (format == Alpha) {
                return 5121;
            }
            if (format == Intensity) {
                return 5121;
            }
            if (format == LuminanceAlpha) {
                return 5121;
            }
            if (format == RGB565) {
                return 33635;
            }
            if (format == RGB888) {
                return 5121;
            }
            if (format == RGBA4444) {
                return 32819;
            }
            if (format == RGBA8888) {
                return 5121;
            }
            throw new GdxRuntimeException("unknown format: " + (Object)((Object)format));
        }
    }
}

