/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.Tag;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeStyleLayer;
import org.oscim.theme.XmlRenderThemeStyleMenu;
import org.oscim.theme.XmlThemeResourceProvider;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.Parameters;
import org.oscim.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlThemeBuilder
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(XmlThemeBuilder.class);
    private static final int RENDER_THEME_VERSION_MAPSFORGE = 6;
    private static final int RENDER_THEME_VERSION_VTM = 1;
    private static final String ELEMENT_NAME_RENDER_THEME = "rendertheme";
    private static final String ELEMENT_NAME_STYLE_MENU = "stylemenu";
    private static final String ELEMENT_NAME_MATCH_MAPSFORGE = "rule";
    private static final String ELEMENT_NAME_MATCH_VTM = "m";
    private static final String UNEXPECTED_ELEMENT_STACK_NOT_EMPTY = "Stack not empty, unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RENDERING_INSTRUCTION_PARENT_ELEMENT_MISMATCH = "Rendering instruction:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RULE_PARENT_ELEMENT_MISMATCH = "Rule:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_STYLE_PARENT_ELEMENT_MISMATCH = "Style:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_ATLAS_PARENT_ELEMENT_MISMATCH = "Atlas:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RECT_PARENT_ELEMENT_MISMATCH = "Rect:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_TAG_TRANSFORM_PARENT_ELEMENT_MISMATCH = "Tag transform:: Parent element mismatch: unexpected element: ";
    private static final String LINE_STYLE = "L";
    private static final String OUTLINE_STYLE = "O";
    private static final String AREA_STYLE = "A";
    private static final int DEFAULT_PRIORITY = 0x3FFFFFFF;
    private final ArrayList<RuleBuilder> mRulesList = new ArrayList();
    private final Stack<Element> mElementStack = new Stack();
    private final Stack<RuleBuilder> mRuleStack = new Stack();
    private final HashMap<String, RenderStyle> mStyles = new HashMap(10);
    private final HashMap<String, TextStyle.TextBuilder<?>> mTextStyles = new HashMap(10);
    private final HashMap<String, SymbolStyle.SymbolBuilder<?>> mSymbolStyles = new HashMap(10);
    private final AreaStyle.AreaBuilder<?> mAreaBuilder = AreaStyle.builder();
    private final CircleStyle.CircleBuilder<?> mCircleBuilder = CircleStyle.builder();
    private final ExtrusionStyle.ExtrusionBuilder<?> mExtrusionBuilder = ExtrusionStyle.builder();
    private final LineStyle.LineBuilder<?> mLineBuilder = LineStyle.builder();
    private final SymbolStyle.SymbolBuilder<?> mSymbolBuilder = SymbolStyle.builder();
    private final TextStyle.TextBuilder<?> mTextBuilder = TextStyle.builder();
    private RuleBuilder mCurrentRule;
    private TextureAtlas mTextureAtlas;
    int mLevels = 0;
    int mMapBackground = -1;
    private float mStrokeScale = 1.0f;
    float mTextScale = 1.0f;
    final ThemeFile mTheme;
    private final ThemeCallback mThemeCallback;
    RenderTheme mRenderTheme;
    final boolean mMapsforgeTheme;
    private final float mScale;
    private Set<String> mCategories;
    private XmlRenderThemeStyleLayer mCurrentLayer;
    private XmlRenderThemeStyleMenu mRenderThemeStyleMenu;
    private Map<String, String> mTransformKeyMap = new HashMap<String, String>();
    private Map<Tag, Tag> mTransformTagMap = new HashMap<Tag, Tag>();

    public static IRenderTheme read(ThemeFile theme) throws IRenderTheme.ThemeException {
        return XmlThemeBuilder.read(theme, null);
    }

    public static IRenderTheme read(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        XmlThemeBuilder renderThemeHandler = new XmlThemeBuilder(theme, themeCallback);
        try {
            new XMLReaderAdapter().parse(renderThemeHandler, theme.getRenderThemeAsStream());
        }
        catch (Exception e) {
            throw new IRenderTheme.ThemeException(e.getMessage());
        }
        return renderThemeHandler.mRenderTheme;
    }

    private static void logUnknownAttribute(String element, String name, String value, int attributeIndex) {
        log.debug("unknown attribute in element {} () : {} = {}", new Object[]{element, attributeIndex, name, value});
    }

    public XmlThemeBuilder(ThemeFile theme) {
        this(theme, null);
    }

    public XmlThemeBuilder(ThemeFile theme, ThemeCallback themeCallback) {
        this.mTheme = theme;
        this.mThemeCallback = themeCallback;
        this.mMapsforgeTheme = theme.isMapsforgeTheme();
        this.mScale = CanvasAdapter.getScale();
    }

    @Override
    public void endDocument() {
        if (this.mMapsforgeTheme) {
            this.mRulesList.add(this.buildingRule());
        }
        Rule[] rules = new Rule[this.mRulesList.size()];
        int n = rules.length;
        for (int i = 0; i < n; ++i) {
            rules[i] = this.mRulesList.get(i).onComplete(this.mMapsforgeTheme ? new int[1] : null);
        }
        this.mRenderTheme = this.createTheme(rules);
        this.mRulesList.clear();
        this.mStyles.clear();
        this.mTextStyles.clear();
        this.mSymbolStyles.clear();
        this.mRuleStack.clear();
        this.mElementStack.clear();
        this.mTextureAtlas = null;
    }

    RenderTheme createTheme(Rule[] rules) {
        return new RenderTheme(this.mMapBackground, this.mTextScale, rules, this.mLevels, this.mTransformKeyMap, this.mTransformTagMap, this.mMapsforgeTheme);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.mElementStack.pop();
        if (ELEMENT_NAME_MATCH_MAPSFORGE.equals(localName) || ELEMENT_NAME_MATCH_VTM.equals(localName)) {
            this.mRuleStack.pop();
            if (this.mRuleStack.empty()) {
                if (this.isVisible(this.mCurrentRule)) {
                    this.mRulesList.add(this.mCurrentRule);
                }
            } else {
                this.mCurrentRule = this.mRuleStack.peek();
            }
        } else if (ELEMENT_NAME_STYLE_MENU.equals(localName) && null != this.mTheme.getMenuCallback()) {
            this.mCategories = this.mTheme.getMenuCallback().getCategories(this.mRenderThemeStyleMenu);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        log.debug(exception.getMessage());
    }

    @Override
    public void warning(SAXParseException exception) {
        log.debug(exception.getMessage());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws IRenderTheme.ThemeException {
        block36: {
            try {
                if (ELEMENT_NAME_RENDER_THEME.equals(localName)) {
                    this.checkState(localName, Element.RENDER_THEME);
                    this.createRenderTheme(localName, attributes);
                    break block36;
                }
                if (ELEMENT_NAME_MATCH_MAPSFORGE.equals(localName) || ELEMENT_NAME_MATCH_VTM.equals(localName)) {
                    this.checkState(localName, Element.RULE);
                    RuleBuilder rule = this.createRule(localName, attributes);
                    if (!this.mRuleStack.empty() && this.isVisible(rule)) {
                        this.mCurrentRule.addSubRule(rule);
                    }
                    this.mCurrentRule = rule;
                    this.mRuleStack.push(this.mCurrentRule);
                    break block36;
                }
                if ("style-text".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleTextElement(localName, attributes, true, false);
                    break block36;
                }
                if ("style-symbol".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleSymbolElement(localName, attributes, true);
                    break block36;
                }
                if ("style-area".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleAreaElement(localName, attributes, true);
                    break block36;
                }
                if ("style-line".equals(localName)) {
                    this.checkState(localName, Element.STYLE);
                    this.handleLineElement(localName, attributes, true, false);
                    break block36;
                }
                if ("outline-layer".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    LineStyle line = this.createLine(null, localName, attributes, this.mLevels++, true, false);
                    this.mStyles.put(OUTLINE_STYLE + line.style, (RenderStyle)line);
                    break block36;
                }
                if ("area".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleAreaElement(localName, attributes, false);
                    break block36;
                }
                if ("caption".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(localName, attributes, false, true);
                    break block36;
                }
                if ("circle".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    CircleStyle circle = this.createCircle(localName, attributes, this.mLevels++);
                    if (this.isVisible((RenderStyle)circle)) {
                        this.mCurrentRule.addStyle((RenderStyle)circle);
                    }
                    break block36;
                }
                if ("line".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(localName, attributes, false, false);
                    break block36;
                }
                if ("text".equals(localName) || "pathText".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(localName, attributes, false, false);
                    break block36;
                }
                if ("symbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleSymbolElement(localName, attributes, false);
                    break block36;
                }
                if ("outline".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    LineStyle outline = this.createOutline(attributes.getValue("use"), attributes);
                    if (outline != null && this.isVisible((RenderStyle)outline)) {
                        this.mCurrentRule.addStyle((RenderStyle)outline);
                    }
                    break block36;
                }
                if ("extrusion".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    ExtrusionStyle extrusion = this.createExtrusion(localName, attributes, this.mLevels++);
                    if (this.isVisible((RenderStyle)extrusion)) {
                        this.mCurrentRule.addStyle((RenderStyle)extrusion);
                    }
                    break block36;
                }
                if ("lineSymbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(localName, attributes, false, true);
                    break block36;
                }
                if ("atlas".equals(localName)) {
                    this.checkState(localName, Element.ATLAS);
                    this.createAtlas(localName, attributes);
                    break block36;
                }
                if ("rect".equals(localName)) {
                    this.checkState(localName, Element.RECT);
                    this.createTextureRegion(localName, attributes);
                    break block36;
                }
                if ("cat".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addCategory(this.getStringAttribute(attributes, "id"));
                    break block36;
                }
                if ("layer".equals(localName)) {
                    XmlRenderThemeStyleLayer parentEntry;
                    this.checkState(qName, Element.RENDERING_STYLE);
                    boolean enabled = false;
                    if (this.getStringAttribute(attributes, "enabled") != null) {
                        enabled = Boolean.valueOf(this.getStringAttribute(attributes, "enabled"));
                    }
                    boolean visible = Boolean.valueOf(this.getStringAttribute(attributes, "visible"));
                    this.mCurrentLayer = this.mRenderThemeStyleMenu.createLayer(this.getStringAttribute(attributes, "id"), visible, enabled);
                    String parent = this.getStringAttribute(attributes, "parent");
                    if (null != parent && null != (parentEntry = this.mRenderThemeStyleMenu.getLayer(parent))) {
                        for (String cat : parentEntry.getCategories()) {
                            this.mCurrentLayer.addCategory(cat);
                        }
                        for (XmlRenderThemeStyleLayer overlay : parentEntry.getOverlays()) {
                            this.mCurrentLayer.addOverlay(overlay);
                        }
                    }
                    break block36;
                }
                if ("name".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addTranslation(this.getStringAttribute(attributes, "lang"), this.getStringAttribute(attributes, "value"));
                    break block36;
                }
                if ("overlay".equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    XmlRenderThemeStyleLayer overlay = this.mRenderThemeStyleMenu.getLayer(this.getStringAttribute(attributes, "id"));
                    if (overlay != null) {
                        this.mCurrentLayer.addOverlay(overlay);
                    }
                    break block36;
                }
                if (ELEMENT_NAME_STYLE_MENU.equals(localName)) {
                    this.checkState(qName, Element.RENDERING_STYLE);
                    this.mRenderThemeStyleMenu = new XmlRenderThemeStyleMenu(this.getStringAttribute(attributes, "id"), this.getStringAttribute(attributes, "defaultlang"), this.getStringAttribute(attributes, "defaultvalue"));
                    break block36;
                }
                if ("tag-transform".equals(localName)) {
                    this.checkState(qName, Element.TAG_TRANSFORM);
                    this.tagTransform(localName, attributes);
                    break block36;
                }
                log.error("unknown element: {}", (Object)localName);
                throw new SAXException("unknown element: " + localName);
            }
            catch (SAXException e) {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
            catch (IOException e) {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
        }
    }

    private RuleBuilder createRule(String localName, Attributes attributes) {
        String cat = null;
        int element = 7;
        int closed = 3;
        String keys = null;
        String values = null;
        byte zoomMin = 0;
        byte zoomMax = 127;
        int selector = 0;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String val;
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("e".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("WAY".equals(val)) {
                    element = 6;
                    continue;
                }
                if (!"NODE".equals(val)) continue;
                element = 1;
                continue;
            }
            if ("k".equals(name)) {
                if (this.mMapsforgeTheme) {
                    if ("*".equals(value)) continue;
                    keys = value;
                    continue;
                }
                keys = value;
                continue;
            }
            if ("v".equals(name)) {
                if (this.mMapsforgeTheme) {
                    if ("*".equals(value)) continue;
                    values = value;
                    continue;
                }
                values = value;
                continue;
            }
            if ("cat".equals(name)) {
                cat = value;
                continue;
            }
            if ("closed".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("YES".equals(val)) {
                    closed = 2;
                    continue;
                }
                if (!"NO".equals(val)) continue;
                closed = 1;
                continue;
            }
            if ("zoom-min".equals(name)) {
                zoomMin = Byte.parseByte(value);
                continue;
            }
            if ("zoom-max".equals(name)) {
                zoomMax = Byte.parseByte(value);
                continue;
            }
            if ("select".equals(name)) {
                if ("first".equals(value)) {
                    selector |= 1;
                }
                if (!"when-matched".equals(value)) continue;
                selector |= 2;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(localName, name, value, i);
        }
        if (closed == 2) {
            element = 4;
        } else if (closed == 1) {
            element = 2;
        }
        XmlThemeBuilder.validateNonNegative("zoom-min", zoomMin);
        XmlThemeBuilder.validateNonNegative("zoom-max", zoomMax);
        if (zoomMin > zoomMax) {
            throw new IRenderTheme.ThemeException("zoom-min must be less or equal zoom-max: " + zoomMin);
        }
        RuleBuilder b = RuleBuilder.create(keys, values);
        b.cat(cat);
        b.zoom(zoomMin, zoomMax);
        b.element(element);
        b.select(selector);
        return b;
    }

    private TextureRegion getAtlasRegion(String src) {
        if (this.mTextureAtlas == null) {
            return null;
        }
        TextureRegion texture = this.mTextureAtlas.getTextureRegion((Object)src);
        if (texture == null) {
            log.debug("missing texture atlas item '" + src + "'");
        }
        return texture;
    }

    private void handleLineElement(String localName, Attributes attributes, boolean isStyle, boolean hasSymbol) throws SAXException {
        String use = attributes.getValue("use");
        LineStyle style = null;
        if (use != null && (style = (LineStyle)this.mStyles.get(LINE_STYLE + use)) == null) {
            log.debug("missing line style 'use': " + use);
            return;
        }
        LineStyle line = this.createLine(style, localName, attributes, this.mLevels++, false, hasSymbol);
        if (isStyle) {
            this.mStyles.put(LINE_STYLE + line.style, (RenderStyle)line);
        } else if (this.isVisible((RenderStyle)line)) {
            LineStyle outline;
            this.mCurrentRule.addStyle((RenderStyle)line);
            String outlineValue = attributes.getValue("outline");
            if (outlineValue != null && (outline = this.createOutline(outlineValue, attributes)) != null) {
                this.mCurrentRule.addStyle((RenderStyle)outline);
            }
        }
    }

    private LineStyle createLine(LineStyle line, String elementName, Attributes attributes, int level, boolean isOutline, boolean hasSymbol) {
        LineStyle.LineBuilder b = this.mLineBuilder.set(line);
        b.isOutline(isOutline);
        b.level(level);
        b.themeCallback(this.mThemeCallback);
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                b.style = value;
                continue;
            }
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("use".equals(name) || "outline".equals(name)) continue;
            if ("stroke".equals(name)) {
                b.color(value);
                continue;
            }
            if ("width".equals(name) || "stroke-width".equals(name)) {
                b.strokeWidth = Float.parseFloat(value) * this.mScale * this.mStrokeScale;
                if (line == null) {
                    if (isOutline) continue;
                    XmlThemeBuilder.validateNonNegative("width", b.strokeWidth);
                    continue;
                }
                b.strokeWidth += line.width;
                if (!(b.strokeWidth <= 0.0f)) continue;
                b.strokeWidth = 1.0f;
                continue;
            }
            if ("cap".equals(name) || "stroke-linecap".equals(name)) {
                b.cap = Paint.Cap.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("fix".equals(name)) {
                b.fixed = Boolean.parseBoolean(value);
                continue;
            }
            if ("stipple".equals(name)) {
                b.stipple = (int)((float)Integer.parseInt(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            if ("stipple-stroke".equals(name)) {
                b.stippleColor(value);
                continue;
            }
            if ("stipple-width".equals(name)) {
                b.stippleWidth = Float.parseFloat(value);
                continue;
            }
            if ("fade".equals(name)) {
                b.fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("min".equals(name)) continue;
            if ("blur".equals(name)) {
                b.blur = Float.parseFloat(value);
                continue;
            }
            if ("style".equals(name)) continue;
            if ("dasharray".equals(name) || "stroke-dasharray".equals(name)) {
                b.dashArray = XmlThemeBuilder.parseFloatArray(value);
                for (int j = 0; j < b.dashArray.length; ++j) {
                    b.dashArray[j] = b.dashArray[j] * this.mScale * this.mStrokeScale;
                }
                continue;
            }
            if ("symbol-width".equals(name)) {
                b.symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                b.symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                b.symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("repeat-start".equals(name)) {
                b.repeatStart = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("repeat-gap".equals(name)) {
                b.repeatGap = Float.parseFloat(value) * this.mScale;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        if (b.dashArray != null) {
            if (b.dashArray.length == 1) {
                b.randomOffset = false;
                b.stipple = b.dashArray[0] < 1.0f ? 1 : (int)b.dashArray[0];
                b.stippleWidth = 1.0f;
                b.stippleColor = 0;
                b.dashArray = null;
            } else {
                float factor = 1.0f;
                for (Object f : (String)b.dashArray) {
                    if (!(0.0f < f) || !(f < 1.0f)) continue;
                    factor = Math.max(factor, 1.0f / f);
                }
                if (b.dashArray.length % 2 != 0) {
                    float[] newDashArray = new float[b.dashArray.length * 2];
                    System.arraycopy(b.dashArray, 0, newDashArray, 0, b.dashArray.length);
                    System.arraycopy(b.dashArray, 0, newDashArray, b.dashArray.length, b.dashArray.length);
                    b.dashArray = newDashArray;
                }
                int width = 0;
                int height = b.strokeWidth < 1.0f ? 1 : (int)b.strokeWidth;
                for (float f : b.dashArray) {
                    width = (int)((float)width + (f *= factor));
                }
                Bitmap bitmap = CanvasAdapter.newBitmap((int)width, (int)height, (int)0);
                Canvas canvas = CanvasAdapter.newCanvas();
                canvas.setBitmap(bitmap);
                int x = 0;
                boolean transparent = false;
                for (float f : b.dashArray) {
                    canvas.fillRectangle((float)x, 0.0f, f *= factor, (float)height, transparent ? 0 : -1);
                    x = (int)((float)x + f);
                    transparent = !transparent;
                }
                b.texture = new TextureItem(Utils.potBitmap((Bitmap)bitmap));
                b.texture.mipmap = true;
                b.randomOffset = false;
                b.stipple = width;
                b.stippleWidth = 1.0f;
                b.stippleColor = b.fillColor;
            }
        } else {
            if (src != null) {
                b.symbolPercent *= 2;
                float symbolScale = hasSymbol && Parameters.SYMBOL_SCALING == Parameters.SymbolScaling.ALL ? CanvasAdapter.symbolScale : 1.0f;
                b.texture = Utils.loadTexture((String)this.mTheme.getRelativePathPrefix(), (String)src, (XmlThemeResourceProvider)this.mTheme.getResourceProvider(), (int)b.symbolWidth, (int)b.symbolHeight, (int)((int)((float)b.symbolPercent * symbolScale)));
            }
            if (b.texture != null) {
                int width = (int)((float)b.texture.width + (hasSymbol ? b.repeatGap : 0.0f));
                int height = b.texture.height;
                Bitmap bitmap = CanvasAdapter.newBitmap((int)width, (int)height, (int)0);
                Canvas canvas = CanvasAdapter.newCanvas();
                canvas.setBitmap(bitmap);
                canvas.drawBitmap(b.texture.bitmap, hasSymbol ? b.repeatStart : 0.0f, 0.0f);
                b.texture = new TextureItem(Utils.potBitmap((Bitmap)bitmap));
                b.texture.mipmap = true;
                if (hasSymbol) {
                    b.fixed = true;
                    b.strokeWidth = (float)height * 0.25f;
                }
                b.randomOffset = false;
                b.stipple = width;
                b.stippleWidth = 1.0f;
                b.stippleColor = -1;
            }
        }
        return b.build();
    }

    private void handleAreaElement(String localName, Attributes attributes, boolean isStyle) throws SAXException {
        String use = attributes.getValue("use");
        AreaStyle style = null;
        if (use != null && (style = (AreaStyle)this.mStyles.get(AREA_STYLE + use)) == null) {
            log.debug("missing area style 'use': " + use);
            return;
        }
        AreaStyle area = this.createArea(style, localName, attributes, this.mLevels++);
        if (isStyle) {
            this.mStyles.put(AREA_STYLE + area.style, (RenderStyle)area);
        } else if (this.isVisible((RenderStyle)area)) {
            this.mCurrentRule.addStyle((RenderStyle)area);
        }
    }

    private AreaStyle createArea(AreaStyle area, String elementName, Attributes attributes, int level) {
        AreaStyle.AreaBuilder b = this.mAreaBuilder.set(area);
        b.level(level);
        b.themeCallback(this.mThemeCallback);
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                b.style = value;
                continue;
            }
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("use".equals(name)) continue;
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("fill".equals(name)) {
                b.color(value);
                continue;
            }
            if ("stroke".equals(name)) {
                b.strokeColor(value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                float strokeWidth = Float.parseFloat(value);
                XmlThemeBuilder.validateNonNegative("stroke-width", strokeWidth);
                b.strokeWidth = strokeWidth * this.mScale * this.mStrokeScale;
                continue;
            }
            if ("fade".equals(name)) {
                b.fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("blend".equals(name)) {
                b.blendScale = Integer.parseInt(value);
                continue;
            }
            if ("blend-fill".equals(name)) {
                b.blendColor(value);
                continue;
            }
            if ("mesh".equals(name)) {
                b.mesh(Boolean.parseBoolean(value));
                continue;
            }
            if ("symbol-width".equals(name)) {
                b.symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                b.symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                b.symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        if (src != null) {
            b.texture = Utils.loadTexture((String)this.mTheme.getRelativePathPrefix(), src, (XmlThemeResourceProvider)this.mTheme.getResourceProvider(), (int)b.symbolWidth, (int)b.symbolHeight, (int)b.symbolPercent);
        }
        return b.build();
    }

    private LineStyle createOutline(String style, Attributes attributes) {
        LineStyle line;
        if (style != null && (line = (LineStyle)this.mStyles.get(OUTLINE_STYLE + style)) != null && line.outline) {
            String cat = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                if (!"cat".equals(name)) continue;
                cat = value;
                break;
            }
            return (LineStyle)line.setCat(cat);
        }
        log.debug("BUG not an outline style: " + style);
        return null;
    }

    private void createAtlas(String elementName, Attributes attributes) throws IOException {
        String img = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("img".equals(name)) {
                img = value;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("img", img, elementName);
        Bitmap bitmap = CanvasAdapter.getBitmapAsset((String)this.mTheme.getRelativePathPrefix(), img);
        if (bitmap != null) {
            this.mTextureAtlas = new TextureAtlas(bitmap);
        }
    }

    private void createTextureRegion(String elementName, Attributes attributes) {
        if (this.mTextureAtlas == null) {
            return;
        }
        String regionName = null;
        TextureAtlas.Rect r = null;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                regionName = value;
                continue;
            }
            if ("pos".equals(name)) {
                String[] pos = value.split(" ");
                if (pos.length != 4) continue;
                r = new TextureAtlas.Rect(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("id", regionName, elementName);
        XmlThemeBuilder.validateExists("pos", r, elementName);
        this.mTextureAtlas.addTextureRegion((Object)regionName.intern(), r);
    }

    private void checkElement(String elementName, Element element) throws SAXException {
        switch (element) {
            case RENDER_THEME: {
                if (!this.mElementStack.empty()) {
                    throw new SAXException(UNEXPECTED_ELEMENT_STACK_NOT_EMPTY + elementName);
                }
                return;
            }
            case RULE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT_RULE_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case STYLE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new SAXException(UNEXPECTED_ELEMENT_STYLE_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RENDERING_INSTRUCTION: {
                if (this.mElementStack.peek() != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT_RENDERING_INSTRUCTION_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case ATLAS: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new SAXException(UNEXPECTED_ELEMENT_ATLAS_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RECT: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.ATLAS) {
                    throw new SAXException(UNEXPECTED_ELEMENT_RECT_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RENDERING_STYLE: {
                return;
            }
            case TAG_TRANSFORM: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new SAXException(UNEXPECTED_ELEMENT_TAG_TRANSFORM_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
        }
        throw new SAXException("unknown enum value: " + (Object)((Object)element));
    }

    private void checkState(String elementName, Element element) throws SAXException {
        this.checkElement(elementName, element);
        this.mElementStack.push(element);
    }

    private void createRenderTheme(String elementName, Attributes attributes) {
        int renderThemeVersion;
        Integer version = null;
        int mapBackground = -1;
        float baseStrokeWidth = 1.0f;
        float baseTextScale = 1.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("schemaLocation".equals(name)) continue;
            if ("version".equals(name)) {
                version = Integer.parseInt(value);
                continue;
            }
            if ("map-background".equals(name)) {
                mapBackground = Color.parseColor((String)value);
                if (this.mThemeCallback == null) continue;
                mapBackground = this.mThemeCallback.getColor(null, mapBackground);
                continue;
            }
            if ("base-stroke-width".equals(name)) {
                baseStrokeWidth = Float.parseFloat(value);
                continue;
            }
            if ("base-text-scale".equals(name) || "base-text-size".equals(name)) {
                baseTextScale = Float.parseFloat(value);
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("version", version, elementName);
        int n = renderThemeVersion = this.mMapsforgeTheme ? 6 : 1;
        if (version > renderThemeVersion) {
            throw new IRenderTheme.ThemeException("invalid render theme version:" + version);
        }
        XmlThemeBuilder.validateNonNegative("base-stroke-width", baseStrokeWidth);
        XmlThemeBuilder.validateNonNegative("base-text-scale", baseTextScale);
        this.mMapBackground = mapBackground;
        this.mStrokeScale = baseStrokeWidth;
        this.mTextScale = baseTextScale;
    }

    private void handleTextElement(String localName, Attributes attributes, boolean isStyle, boolean isCaption) throws SAXException {
        String style = attributes.getValue("use");
        TextStyle.TextBuilder<?> pt = null;
        if (style != null && (pt = this.mTextStyles.get(style)) == null) {
            log.debug("missing text style: " + style);
            return;
        }
        TextStyle.TextBuilder<?> b = this.createText(localName, attributes, isCaption, pt);
        if (isStyle) {
            log.debug("put style {}", (Object)b.style);
            this.mTextStyles.put(b.style, TextStyle.builder().from(b));
        } else {
            TextStyle text = b.buildInternal();
            if (this.isVisible((RenderStyle)text)) {
                this.mCurrentRule.addStyle((RenderStyle)text);
            }
        }
    }

    private TextStyle.TextBuilder<?> createText(String elementName, Attributes attributes, boolean caption, TextStyle.TextBuilder<?> style) {
        TextStyle.TextBuilder b;
        if (style == null) {
            b = this.mTextBuilder.reset();
            b.caption = caption;
        } else {
            b = this.mTextBuilder.from(style);
        }
        b.themeCallback(this.mThemeCallback);
        String symbol = null;
        if (this.mMapsforgeTheme) {
            b.priority = 0x3FFFFFFF;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                b.style = value;
                continue;
            }
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("k".equals(name)) {
                b.textKey = value.intern();
                continue;
            }
            if ("font-family".equals(name)) {
                b.fontFamily = Paint.FontFamily.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("style".equals(name) || "font-style".equals(name)) {
                b.fontStyle = Paint.FontStyle.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("size".equals(name) || "font-size".equals(name)) {
                b.fontSize = Float.parseFloat(value);
                continue;
            }
            if ("bg-fill".equals(name)) {
                b.bgFillColor = Color.parseColor((String)value);
                continue;
            }
            if ("fill".equals(name)) {
                b.fillColor = Color.parseColor((String)value);
                continue;
            }
            if ("stroke".equals(name)) {
                b.strokeColor = Color.parseColor((String)value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                b.strokeWidth = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("caption".equals(name)) {
                b.caption = Boolean.parseBoolean(value);
                continue;
            }
            if ("priority".equals(name)) {
                b.priority = Integer.parseInt(value);
                if (!this.mMapsforgeTheme) continue;
                b.priority = FastMath.clamp((int)(0x3FFFFFFF - b.priority), (int)0, (int)Integer.MAX_VALUE);
                continue;
            }
            if ("area-size".equals(name)) {
                b.areaSize = Float.parseFloat(value);
                continue;
            }
            if ("dy".equals(name)) {
                b.dy = -Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("symbol".equals(name)) {
                symbol = value;
                continue;
            }
            if ("use".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                b.symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                b.symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                b.symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("position".equals(name)) {
                if (b.dy != 0.0f) continue;
                value = "above".equals(value) ? "20" : "-20";
                b.dy = -Float.parseFloat(value) * this.mScale;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("k", b.textKey, elementName);
        XmlThemeBuilder.validateNonNegative("size", b.fontSize);
        XmlThemeBuilder.validateNonNegative("stroke-width", b.strokeWidth);
        if (symbol != null && symbol.length() > 0) {
            String lowValue = symbol.toLowerCase(Locale.ENGLISH);
            if (lowValue.endsWith(".png") || lowValue.endsWith(".svg")) {
                try {
                    b.bitmap = CanvasAdapter.getBitmapAsset((String)this.mTheme.getRelativePathPrefix(), (String)symbol, (XmlThemeResourceProvider)this.mTheme.getResourceProvider(), (int)b.symbolWidth, (int)b.symbolHeight, (int)b.symbolPercent);
                }
                catch (Exception e) {
                    log.error("{}: {}", (Object)symbol, (Object)e.getMessage());
                }
            } else {
                b.texture = this.getAtlasRegion(symbol);
            }
        }
        return b;
    }

    private CircleStyle createCircle(String elementName, Attributes attributes, int level) {
        CircleStyle.CircleBuilder b = this.mCircleBuilder.reset();
        b.level(level);
        b.themeCallback(this.mThemeCallback);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("r".equals(name) || "radius".equals(name)) {
                b.radius(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("scale-radius".equals(name)) {
                b.scaleRadius(Boolean.parseBoolean(value));
                continue;
            }
            if ("fill".equals(name)) {
                b.color(Color.parseColor((String)value));
                continue;
            }
            if ("stroke".equals(name)) {
                b.strokeColor(Color.parseColor((String)value));
                continue;
            }
            if ("stroke-width".equals(name)) {
                b.strokeWidth(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("radius", Float.valueOf(b.radius), elementName);
        XmlThemeBuilder.validateNonNegative("radius", b.radius);
        XmlThemeBuilder.validateNonNegative("stroke-width", b.strokeWidth);
        return b.build();
    }

    private void handleSymbolElement(String localName, Attributes attributes, boolean isStyle) throws SAXException {
        String style = attributes.getValue("use");
        SymbolStyle.SymbolBuilder<?> ps = null;
        if (style != null && (ps = this.mSymbolStyles.get(style)) == null) {
            log.debug("missing symbol style: " + style);
            return;
        }
        SymbolStyle.SymbolBuilder<?> b = this.createSymbol(localName, attributes, ps);
        if (isStyle) {
            log.debug("put style {}", (Object)b.style);
            this.mSymbolStyles.put(b.style, SymbolStyle.builder().from(b));
        } else {
            SymbolStyle symbol = this.buildSymbol(b);
            if (symbol != null && this.isVisible((RenderStyle)symbol)) {
                this.mCurrentRule.addStyle((RenderStyle)symbol);
            }
        }
    }

    private SymbolStyle.SymbolBuilder<?> createSymbol(String elementName, Attributes attributes, SymbolStyle.SymbolBuilder<?> style) {
        SymbolStyle.SymbolBuilder b = style == null ? this.mSymbolBuilder.reset() : this.mSymbolBuilder.from(style);
        b.themeCallback(this.mThemeCallback);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("id".equals(name)) {
                b.style = value;
                continue;
            }
            if ("src".equals(name)) {
                b.src(value);
                continue;
            }
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("use".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                b.symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                b.symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                b.symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("billboard".equals(name)) {
                b.billboard(Boolean.parseBoolean(value));
                continue;
            }
            if ("repeat".equals(name)) {
                b.repeat(Boolean.parseBoolean(value));
                continue;
            }
            if ("repeat-start".equals(name)) {
                b.repeatStart = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("repeat-gap".equals(name)) {
                b.repeatGap = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("rotate".equals(name)) {
                b.rotate(Boolean.parseBoolean(value));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("src", b.src, elementName);
        return b;
    }

    private SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b) {
        String lowSrc = b.src.toLowerCase(Locale.ENGLISH);
        if (lowSrc.endsWith(".png") || lowSrc.endsWith(".svg")) {
            try {
                Bitmap bitmap = CanvasAdapter.getBitmapAsset((String)this.mTheme.getRelativePathPrefix(), (String)b.src, (XmlThemeResourceProvider)this.mTheme.getResourceProvider(), (int)b.symbolWidth, (int)b.symbolHeight, (int)b.symbolPercent);
                if (bitmap != null) {
                    return this.buildSymbol(b, b.src, bitmap);
                }
            }
            catch (Exception e) {
                log.error("{}: {}", (Object)b.src, (Object)e.getMessage());
            }
            return null;
        }
        return b.texture(this.getAtlasRegion(b.src)).build();
    }

    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b, String src, Bitmap bitmap) {
        return b.bitmap(bitmap).build();
    }

    private ExtrusionStyle createExtrusion(String elementName, Attributes attributes, int level) {
        ExtrusionStyle.ExtrusionBuilder b = this.mExtrusionBuilder.reset();
        b.level(level);
        b.themeCallback(this.mThemeCallback);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("cat".equals(name)) {
                b.cat(value);
                continue;
            }
            if ("side-color".equals(name)) {
                b.colorSide(Color.parseColor((String)value));
                continue;
            }
            if ("top-color".equals(name)) {
                b.colorTop(Color.parseColor((String)value));
                continue;
            }
            if ("line-color".equals(name)) {
                b.colorLine(Color.parseColor((String)value));
                continue;
            }
            if ("hsv-h".equals(name)) {
                b.hsvHue(Double.parseDouble(value));
                continue;
            }
            if ("hsv-s".equals(name)) {
                b.hsvSaturation(Double.parseDouble(value));
                continue;
            }
            if ("hsv-v".equals(name)) {
                b.hsvValue(Double.parseDouble(value));
                continue;
            }
            if ("default-height".equals(name)) {
                b.defaultHeight(Integer.parseInt(value));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        return b.build();
    }

    private String getStringAttribute(Attributes attributes, String name) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equals(name)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private boolean isVisible(RenderStyle renderStyle) {
        return this.mCategories == null || renderStyle.cat == null || this.mCategories.contains(renderStyle.cat);
    }

    private boolean isVisible(RuleBuilder rule) {
        return this.mCategories == null || rule.cat == null || this.mCategories.contains(rule.cat);
    }

    private static float[] parseFloatArray(String dashString) {
        String[] dashEntries = dashString.split(",");
        float[] dashIntervals = new float[dashEntries.length];
        for (int i = 0; i < dashEntries.length; ++i) {
            dashIntervals[i] = Float.parseFloat(dashEntries[i]);
        }
        return dashIntervals;
    }

    private void tagTransform(String localName, Attributes attributes) {
        String libV = null;
        String libK = null;
        String v = null;
        String k = null;
        block12: for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            switch (name) {
                case "k": {
                    k = value;
                    continue block12;
                }
                case "v": {
                    v = value;
                    continue block12;
                }
                case "k-lib": {
                    libK = value;
                    continue block12;
                }
                case "v-lib": {
                    libV = value;
                    continue block12;
                }
                default: {
                    XmlThemeBuilder.logUnknownAttribute(localName, name, value, i);
                }
            }
        }
        if (k == null || k.isEmpty() || libK == null || libK.isEmpty()) {
            log.debug("empty key in element " + localName);
            return;
        }
        if (v == null && libV == null) {
            this.mTransformKeyMap.put(k, libK);
        } else {
            this.mTransformTagMap.put(new Tag(k, v), new Tag(libK, libV));
        }
    }

    private static void validateNonNegative(String name, float value) {
        if (value < 0.0f) {
            throw new IRenderTheme.ThemeException(name + " must not be negative: " + value);
        }
    }

    private static void validateExists(String name, Object obj, String elementName) {
        if (obj == null) {
            throw new IRenderTheme.ThemeException("missing attribute " + name + " for element: " + elementName);
        }
    }

    private RuleBuilder buildingRule() {
        ExtrusionStyle.ExtrusionBuilder b = this.mExtrusionBuilder.reset();
        b.level(this.mLevels++);
        b.themeCallback(this.mThemeCallback);
        b.colorLine(-2500394);
        b.colorSide(-353571863);
        b.colorTop(-352716554);
        RuleBuilder rule = new RuleBuilder(RuleBuilder.RuleType.POSITIVE, new String[]{"building", "building:part"}, new String[0]);
        rule.element(6).zoom((byte)17, (byte)127).style(new RenderStyle.StyleBuilder[]{b});
        return rule;
    }

    private static enum Element {
        RENDER_THEME,
        RENDERING_INSTRUCTION,
        RULE,
        STYLE,
        ATLAS,
        RECT,
        RENDERING_STYLE,
        TAG_TRANSFORM;

    }
}

