/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.bitmap;

import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.Tile;
import org.oscim.gdx.client.GwtBitmap;
import org.oscim.layers.tile.LoadDelayTask;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.source.LwHttp;
import org.oscim.tiling.source.UrlTileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileSource
extends UrlTileSource {
    static final Logger log = LoggerFactory.getLogger(LwHttp.class);

    protected BitmapTileSource(Builder<?> builder) {
        super(builder);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public BitmapTileSource(String url, int zoomMin, int zoomMax) {
        super(url, "/{Z}/{X}/{Y}.png", zoomMin, zoomMax);
    }

    public BitmapTileSource(String url, int zoomMin, int zoomMax, String extension) {
        super(url, "/{Z}/{X}/{Y}" + extension, zoomMin, zoomMax);
    }

    public BitmapTileSource(String url, String tilePath, int zoomMin, int zoomMax) {
        super(url, tilePath, zoomMin, zoomMax);
    }

    public ITileDataSource getDataSource() {
        return new BitmapTileDataSource(this);
    }

    public class BitmapTileDataSource
    implements ITileDataSource {
        protected final UrlTileSource mTileSource;

        public BitmapTileDataSource(BitmapTileSource bitmapTileSource) {
            this.mTileSource = bitmapTileSource;
        }

        public void query(final MapTile tile, final ITileDataSink sink) {
            String url = this.mTileSource.getTileUrl((Tile)tile);
            SafeUri uri = UriUtils.fromTrustedString((String)url);
            final Image img = new Image();
            img.setVisible(false);
            img.getElement().setAttribute("crossorigin", "anonymous");
            img.setUrl(uri);
            RootPanel.get().add((Widget)img);
            img.addLoadHandler(new LoadHandler(){

                public void onLoad(LoadEvent event) {
                    TileLoader.postLoadDelay(new LoadDelayTask<Image>(tile, sink, img){

                        @Override
                        public void continueLoading() {
                            if (!this.tile.state(2)) {
                                this.sink.completed(QueryResult.FAILED);
                                RootPanel.get().remove((Widget)this.data);
                            } else {
                                this.sink.setTileImage((Bitmap)new GwtBitmap((Image)this.data));
                                this.sink.completed(QueryResult.SUCCESS);
                            }
                        }
                    });
                }
            });
            img.addErrorHandler(new ErrorHandler(){

                public void onError(ErrorEvent event) {
                    sink.completed(QueryResult.FAILED);
                    RootPanel.get().remove((Widget)img);
                }
            });
        }

        public void dispose() {
        }

        public void cancel() {
        }
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        public Builder() {
            super(null, "/{Z}/{X}/{Y}.png", 0, 17);
        }

        public BitmapTileSource build() {
            return new BitmapTileSource(this);
        }
    }
}

