/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractCollection;
import java.util.Iterator;

public class JsArrayCollection<T>
extends AbstractCollection<T> {
    private JsArr<T> _data;

    public JsArrayCollection() {
        this._data = (JsArr)JsArr.create().cast();
    }

    public JsArrayCollection(JavaScriptObject data) {
        this._data = (JsArr)data.cast();
    }

    public static <T> JsArrayCollection<T> create(JavaScriptObject data) {
        return new JsArrayCollection<T>(data);
    }

    @Override
    public Iterator<T> iterator() {
        return new JsArrayIterator(this);
    }

    @Override
    public int size() {
        return this._data.size();
    }

    private static class JsArr<T>
    extends JavaScriptObject {
        protected JsArr() {
        }

        public final native JsArr<T> slice(int var1, int var2);

        public static final native <T> JsArr<T> create();

        public final native int size();

        public final native T get(int var1);
    }

    public static class JsArrayIterator<T>
    implements Iterator<T> {
        private JsArrayCollection<T> arr;
        int currentIndex;

        public JsArrayIterator(JsArrayCollection<T> arr) {
            this.arr = arr;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.arr.size();
        }

        @Override
        public T next() {
            ++this.currentIndex;
            return ((JsArrayCollection)this.arr)._data.get(this.currentIndex - 1);
        }

        @Override
        public void remove() {
            ((JsArrayCollection)this.arr)._data.slice(this.currentIndex - 1, this.currentIndex);
        }
    }
}

