/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.gwt.widgets.TextInputDialogBox;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Touch;

public class GwtInput
implements Input {
    static final int MAX_TOUCHES = 20;
    boolean justTouched = false;
    private IntMap<Integer> touchMap = new IntMap(20);
    private boolean[] touched = new boolean[20];
    private int[] touchX = new int[20];
    private int[] touchY = new int[20];
    private int[] deltaX = new int[20];
    private int[] deltaY = new int[20];
    IntSet pressedButtons = new IntSet();
    int pressedKeyCount = 0;
    boolean[] pressedKeys = new boolean[256];
    boolean keyJustPressed = false;
    boolean[] justPressedKeys = new boolean[256];
    InputProcessor processor;
    char lastKeyCharPressed;
    float keyRepeatTimer;
    long currentEventTimeStamp;
    final CanvasElement canvas;
    boolean hasFocus = true;
    private static final int KEY_PAUSE = 19;
    private static final int KEY_CAPS_LOCK = 20;
    private static final int KEY_SPACE = 32;
    private static final int KEY_INSERT = 45;
    private static final int KEY_0 = 48;
    private static final int KEY_1 = 49;
    private static final int KEY_2 = 50;
    private static final int KEY_3 = 51;
    private static final int KEY_4 = 52;
    private static final int KEY_5 = 53;
    private static final int KEY_6 = 54;
    private static final int KEY_7 = 55;
    private static final int KEY_8 = 56;
    private static final int KEY_9 = 57;
    private static final int KEY_A = 65;
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_D = 68;
    private static final int KEY_E = 69;
    private static final int KEY_F = 70;
    private static final int KEY_G = 71;
    private static final int KEY_H = 72;
    private static final int KEY_I = 73;
    private static final int KEY_J = 74;
    private static final int KEY_K = 75;
    private static final int KEY_L = 76;
    private static final int KEY_M = 77;
    private static final int KEY_N = 78;
    private static final int KEY_O = 79;
    private static final int KEY_P = 80;
    private static final int KEY_Q = 81;
    private static final int KEY_R = 82;
    private static final int KEY_S = 83;
    private static final int KEY_T = 84;
    private static final int KEY_U = 85;
    private static final int KEY_V = 86;
    private static final int KEY_W = 87;
    private static final int KEY_X = 88;
    private static final int KEY_Y = 89;
    private static final int KEY_Z = 90;
    private static final int KEY_LEFT_WINDOW_KEY = 91;
    private static final int KEY_RIGHT_WINDOW_KEY = 92;
    private static final int KEY_SELECT_KEY = 93;
    private static final int KEY_NUMPAD0 = 96;
    private static final int KEY_NUMPAD1 = 97;
    private static final int KEY_NUMPAD2 = 98;
    private static final int KEY_NUMPAD3 = 99;
    private static final int KEY_NUMPAD4 = 100;
    private static final int KEY_NUMPAD5 = 101;
    private static final int KEY_NUMPAD6 = 102;
    private static final int KEY_NUMPAD7 = 103;
    private static final int KEY_NUMPAD8 = 104;
    private static final int KEY_NUMPAD9 = 105;
    private static final int KEY_MULTIPLY = 106;
    private static final int KEY_ADD = 107;
    private static final int KEY_SUBTRACT = 109;
    private static final int KEY_DECIMAL_POINT_KEY = 110;
    private static final int KEY_DIVIDE = 111;
    private static final int KEY_F1 = 112;
    private static final int KEY_F2 = 113;
    private static final int KEY_F3 = 114;
    private static final int KEY_F4 = 115;
    private static final int KEY_F5 = 116;
    private static final int KEY_F6 = 117;
    private static final int KEY_F7 = 118;
    private static final int KEY_F8 = 119;
    private static final int KEY_F9 = 120;
    private static final int KEY_F10 = 121;
    private static final int KEY_F11 = 122;
    private static final int KEY_F12 = 123;
    private static final int KEY_NUM_LOCK = 144;
    private static final int KEY_SCROLL_LOCK = 145;
    private static final int KEY_SEMICOLON = 186;
    private static final int KEY_EQUALS = 187;
    private static final int KEY_COMMA = 188;
    private static final int KEY_DASH = 189;
    private static final int KEY_PERIOD = 190;
    private static final int KEY_FORWARD_SLASH = 191;
    private static final int KEY_GRAVE_ACCENT = 192;
    private static final int KEY_OPEN_BRACKET = 219;
    private static final int KEY_BACKSLASH = 220;
    private static final int KEY_CLOSE_BRACKET = 221;
    private static final int KEY_SINGLE_QUOTE = 222;

    public GwtInput(CanvasElement canvas) {
        this.canvas = canvas;
        this.hookEvents();
    }

    void reset() {
        this.justTouched = false;
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            for (int i = 0; i < this.justPressedKeys.length; ++i) {
                this.justPressedKeys[i] = false;
            }
        }
    }

    public float getAccelerometerX() {
        return 0.0f;
    }

    public float getAccelerometerY() {
        return 0.0f;
    }

    public float getAccelerometerZ() {
        return 0.0f;
    }

    public float getGyroscopeX() {
        return 0.0f;
    }

    public float getGyroscopeY() {
        return 0.0f;
    }

    public float getGyroscopeZ() {
        return 0.0f;
    }

    public int getX() {
        return this.touchX[0];
    }

    public int getX(int pointer) {
        return this.touchX[pointer];
    }

    public int getDeltaX() {
        return this.deltaX[0];
    }

    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    public int getY() {
        return this.touchY[0];
    }

    public int getY(int pointer) {
        return this.touchY[pointer];
    }

    public int getDeltaY() {
        return this.deltaY[0];
    }

    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    public boolean isTouched() {
        for (int pointer = 0; pointer < 20; ++pointer) {
            if (!this.touched[pointer]) continue;
            return true;
        }
        return false;
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isTouched(int pointer) {
        return this.touched[pointer];
    }

    public boolean isButtonPressed(int button) {
        return this.pressedButtons.contains(button) && this.touched[0];
    }

    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeyCount > 0;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.pressedKeys[key];
    }

    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        TextInputDialogBox dialog = new TextInputDialogBox(title, text, hint);
        final Input.TextInputListener capturedListener = listener;
        dialog.setListener(new TextInputDialogBox.TextInputDialogListener(){

            public void onPositive(String text) {
                if (capturedListener != null) {
                    capturedListener.input(text);
                }
            }

            public void onNegative() {
                if (capturedListener != null) {
                    capturedListener.canceled();
                }
            }
        });
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public float getAzimuth() {
        return 0.0f;
    }

    public float getPitch() {
        return 0.0f;
    }

    public float getRoll() {
        return 0.0f;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    public void setCatchBackKey(boolean catchBack) {
    }

    public boolean isCatchBackKey() {
        return false;
    }

    public void setCatchMenuKey(boolean catchMenu) {
    }

    public boolean isCatchMenuKey() {
        return false;
    }

    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return false;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return false;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return true;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return GwtInput.isTouchScreen();
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return false;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return false;
        }
        return false;
    }

    public int getRotation() {
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    private native boolean isCursorCatchedJSNI();

    private native void setCursorCatchedJSNI(CanvasElement var1);

    private native void exitCursorCatchedJSNI();

    private native float getMovementXJSNI(NativeEvent var1);

    private native float getMovementYJSNI(NativeEvent var1);

    private static native boolean isTouchScreen();

    public void setCursorCatched(boolean catched) {
        if (catched) {
            this.setCursorCatchedJSNI(this.canvas);
        } else {
            this.exitCursorCatchedJSNI();
        }
    }

    public boolean isCursorCatched() {
        return this.isCursorCatchedJSNI();
    }

    public void setCursorPosition(int x, int y) {
    }

    static native void addEventListener(JavaScriptObject var0, String var1, GwtInput var2, boolean var3);

    private static native float getMouseWheelVelocity(NativeEvent var0);

    protected static native String getMouseWheelEvent();

    protected int getRelativeX(NativeEvent e, CanvasElement target) {
        float xScaleRatio = (float)target.getWidth() * 1.0f / (float)target.getClientWidth();
        return Math.round(xScaleRatio * (float)(e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft()));
    }

    protected int getRelativeY(NativeEvent e, CanvasElement target) {
        float yScaleRatio = (float)target.getHeight() * 1.0f / (float)target.getClientHeight();
        return Math.round(yScaleRatio * (float)(e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop()));
    }

    protected int getRelativeX(Touch touch, CanvasElement target) {
        float xScaleRatio = (float)target.getWidth() * 1.0f / (float)target.getClientWidth();
        return Math.round(xScaleRatio * (float)touch.getRelativeX((Element)target));
    }

    protected int getRelativeY(Touch touch, CanvasElement target) {
        float yScaleRatio = (float)target.getHeight() * 1.0f / (float)target.getClientHeight();
        return Math.round(yScaleRatio * (float)touch.getRelativeY((Element)target));
    }

    private void hookEvents() {
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mousedown", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mouseup", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mousemove", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, GwtInput.getMouseWheelEvent(), this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "keydown", this, false);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "keyup", this, false);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "keypress", this, false);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "touchstart", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "touchmove", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "touchcancel", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "touchend", this, true);
    }

    private int getButton(int button) {
        if (button == 1) {
            return 0;
        }
        if (button == 2) {
            return 1;
        }
        if (button == 4) {
            return 2;
        }
        return 0;
    }

    private void handleEvent(NativeEvent e) {
        int touchId;
        int real;
        Touch touch;
        int i;
        int j;
        int code;
        if (e.getType().equals("mousedown")) {
            if (!e.getEventTarget().equals((Object)this.canvas) || this.touched[0]) {
                float mouseX = this.getRelativeX(e, this.canvas);
                float mouseY = this.getRelativeY(e, this.canvas);
                if (mouseX < 0.0f || mouseX > (float)Gdx.graphics.getWidth() || mouseY < 0.0f || mouseY > (float)Gdx.graphics.getHeight()) {
                    this.hasFocus = false;
                }
                return;
            }
            this.hasFocus = true;
            this.justTouched = true;
            this.touched[0] = true;
            this.pressedButtons.add(this.getButton(e.getButton()));
            this.deltaX[0] = 0;
            this.deltaY[0] = 0;
            if (this.isCursorCatched()) {
                this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
            } else {
                this.touchX[0] = this.getRelativeX(e, this.canvas);
                this.touchY[0] = this.getRelativeY(e, this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            if (this.processor != null) {
                this.processor.touchDown(this.touchX[0], this.touchY[0], 0, this.getButton(e.getButton()));
            }
        }
        if (e.getType().equals("mousemove")) {
            if (this.isCursorCatched()) {
                this.deltaX[0] = (int)this.getMovementXJSNI(e);
                this.deltaY[0] = (int)this.getMovementYJSNI(e);
                this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
            } else {
                this.deltaX[0] = this.getRelativeX(e, this.canvas) - this.touchX[0];
                this.deltaY[0] = this.getRelativeY(e, this.canvas) - this.touchY[0];
                this.touchX[0] = this.getRelativeX(e, this.canvas);
                this.touchY[0] = this.getRelativeY(e, this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            if (this.processor != null) {
                if (this.touched[0]) {
                    this.processor.touchDragged(this.touchX[0], this.touchY[0], 0);
                } else {
                    this.processor.mouseMoved(this.touchX[0], this.touchY[0]);
                }
            }
        }
        if (e.getType().equals("mouseup")) {
            if (!this.touched[0]) {
                return;
            }
            this.pressedButtons.remove(this.getButton(e.getButton()));
            boolean bl = this.touched[0] = this.pressedButtons.size > 0;
            if (this.isCursorCatched()) {
                this.deltaX[0] = (int)this.getMovementXJSNI(e);
                this.deltaY[0] = (int)this.getMovementYJSNI(e);
                this.touchX[0] = (int)((float)this.touchX[0] + this.getMovementXJSNI(e));
                this.touchY[0] = (int)((float)this.touchY[0] + this.getMovementYJSNI(e));
            } else {
                this.deltaX[0] = this.getRelativeX(e, this.canvas) - this.touchX[0];
                this.deltaY[0] = this.getRelativeY(e, this.canvas) - this.touchY[0];
                this.touchX[0] = this.getRelativeX(e, this.canvas);
                this.touchY[0] = this.getRelativeY(e, this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            this.touched[0] = false;
            if (this.processor != null) {
                this.processor.touchUp(this.touchX[0], this.touchY[0], 0, this.getButton(e.getButton()));
            }
        }
        if (e.getType().equals(GwtInput.getMouseWheelEvent())) {
            if (this.processor != null) {
                this.processor.scrolled((int)GwtInput.getMouseWheelVelocity(e));
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("keydown") && this.hasFocus) {
            code = GwtInput.keyForCode(e.getKeyCode());
            if (code == 67) {
                e.preventDefault();
                if (this.processor != null) {
                    this.processor.keyDown(code);
                    this.processor.keyTyped('\b');
                }
            } else if (!this.pressedKeys[code]) {
                ++this.pressedKeyCount;
                this.pressedKeys[code] = true;
                this.keyJustPressed = true;
                this.justPressedKeys[code] = true;
                if (this.processor != null) {
                    this.processor.keyDown(code);
                }
            }
        }
        if (e.getType().equals("keypress") && this.hasFocus) {
            char c = (char)e.getCharCode();
            if (this.processor != null) {
                this.processor.keyTyped(c);
            }
        }
        if (e.getType().equals("keyup") && this.hasFocus) {
            code = GwtInput.keyForCode(e.getKeyCode());
            if (this.pressedKeys[code]) {
                --this.pressedKeyCount;
                this.pressedKeys[code] = false;
            }
            if (this.processor != null) {
                this.processor.keyUp(code);
            }
        }
        if (e.getType().equals("touchstart")) {
            this.justTouched = true;
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = this.getAvailablePointer();
                this.touchMap.put(real, (Object)touchId);
                this.touched[touchId] = true;
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                this.deltaX[touchId] = 0;
                this.deltaY[touchId] = 0;
                if (this.processor == null) continue;
                this.processor.touchDown(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchmove")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchDragged(this.touchX[touchId], this.touchY[touchId], touchId);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchcancel")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.touchMap.remove(real);
                this.touched[touchId] = false;
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchUp(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
        if (e.getType().equals("touchend")) {
            JsArray touches = e.getChangedTouches();
            j = touches.length();
            for (i = 0; i < j; ++i) {
                touch = (Touch)touches.get(i);
                real = touch.getIdentifier();
                touchId = (Integer)this.touchMap.get(real);
                this.touchMap.remove(real);
                this.touched[touchId] = false;
                this.deltaX[touchId] = this.getRelativeX(touch, this.canvas) - this.touchX[touchId];
                this.deltaY[touchId] = this.getRelativeY(touch, this.canvas) - this.touchY[touchId];
                this.touchX[touchId] = this.getRelativeX(touch, this.canvas);
                this.touchY[touchId] = this.getRelativeY(touch, this.canvas);
                if (this.processor == null) continue;
                this.processor.touchUp(this.touchX[touchId], this.touchY[touchId], touchId, 0);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            e.preventDefault();
        }
    }

    private int getAvailablePointer() {
        for (int i = 0; i < 20; ++i) {
            if (this.touchMap.containsValue((Object)i, false)) continue;
            return i;
        }
        return -1;
    }

    private static int keyForCode(int keyCode) {
        switch (keyCode) {
            case 18: {
                return 57;
            }
            case 8: {
                return 67;
            }
            case 17: {
                return 129;
            }
            case 46: {
                return 67;
            }
            case 40: {
                return 20;
            }
            case 35: {
                return 132;
            }
            case 13: {
                return 66;
            }
            case 27: {
                return 131;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return 21;
            }
            case 34: {
                return 93;
            }
            case 33: {
                return 92;
            }
            case 39: {
                return 22;
            }
            case 16: {
                return 59;
            }
            case 9: {
                return 61;
            }
            case 38: {
                return 19;
            }
            case 19: {
                return 0;
            }
            case 20: {
                return 0;
            }
            case 32: {
                return 62;
            }
            case 45: {
                return 133;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 91: {
                return 0;
            }
            case 92: {
                return 0;
            }
            case 96: {
                return 144;
            }
            case 97: {
                return 145;
            }
            case 98: {
                return 146;
            }
            case 99: {
                return 147;
            }
            case 100: {
                return 148;
            }
            case 101: {
                return 149;
            }
            case 102: {
                return 150;
            }
            case 103: {
                return 151;
            }
            case 104: {
                return 152;
            }
            case 105: {
                return 153;
            }
            case 106: {
                return 0;
            }
            case 107: {
                return 81;
            }
            case 109: {
                return 69;
            }
            case 110: {
                return 56;
            }
            case 111: {
                return 0;
            }
            case 112: {
                return 244;
            }
            case 113: {
                return 245;
            }
            case 114: {
                return 246;
            }
            case 115: {
                return 247;
            }
            case 116: {
                return 248;
            }
            case 117: {
                return 249;
            }
            case 118: {
                return 250;
            }
            case 119: {
                return 251;
            }
            case 120: {
                return 252;
            }
            case 121: {
                return 253;
            }
            case 122: {
                return 254;
            }
            case 123: {
                return 255;
            }
            case 144: {
                return 78;
            }
            case 145: {
                return 0;
            }
            case 186: {
                return 74;
            }
            case 187: {
                return 70;
            }
            case 188: {
                return 55;
            }
            case 189: {
                return 69;
            }
            case 190: {
                return 56;
            }
            case 191: {
                return 76;
            }
            case 192: {
                return 0;
            }
            case 219: {
                return 71;
            }
            case 220: {
                return 73;
            }
            case 221: {
                return 72;
            }
            case 222: {
                return 75;
            }
        }
        return 0;
    }
}

