/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.oscim.backend.GLAdapter;

public class GLMatrix {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    private final FloatBuffer buffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final String INVALID_INPUT = "Bad Array!";
    public final float[] tmp = new float[16];
    public final float[] val = new float[16];
    static float PiTimesThumb = 4.8828125E-4f;

    public void set(float[] values) {
        this.val[0] = values[0];
        this.val[1] = values[1];
        this.val[2] = values[2];
        this.val[3] = values[3];
        this.val[4] = values[4];
        this.val[5] = values[5];
        this.val[6] = values[6];
        this.val[7] = values[7];
        this.val[8] = values[8];
        this.val[9] = values[9];
        this.val[10] = values[10];
        this.val[11] = values[11];
        this.val[12] = values[12];
        this.val[13] = values[13];
        this.val[14] = values[14];
        this.val[15] = values[15];
    }

    public void get(float[] m) {
        if (m == null || m.length != 16) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        System.arraycopy(this.val, 0, m, 0, 16);
    }

    public void copy(GLMatrix m) {
        if (m == null || m.val.length != 16) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        System.arraycopy(m.val, 0, this.val, 0, 16);
    }

    public void prj(float[] vec3) {
        if (vec3 == null || vec3.length < 3) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.matrix4_proj(this.val, vec3);
    }

    static void matrix4_proj(float[] mat, float[] vec) {
        float inv_w = 1.0f / (vec[0] * mat[3] + vec[1] * mat[7] + vec[2] * mat[11] + mat[15]);
        float x = (vec[0] * mat[0] + vec[1] * mat[4] + vec[2] * mat[8] + mat[12]) * inv_w;
        float y = (vec[0] * mat[1] + vec[1] * mat[5] + vec[2] * mat[9] + mat[13]) * inv_w;
        float z = (vec[0] * mat[2] + vec[1] * mat[6] + vec[2] * mat[10] + mat[14]) * inv_w;
        vec[0] = x;
        vec[1] = y;
        vec[2] = z;
    }

    public void prj3D(float[] vec, int offset, int cnt) {
        throw new RuntimeException("unimplemented");
    }

    public void prj2D(float[] vec, int offset, int cnt) {
        cnt <<= 1;
        int x = offset <<= 1;
        int y = x + 1;
        while (x < cnt + offset) {
            float inv_w = 1.0f / (vec[x] * this.val[3] + vec[y] * this.val[7] + this.val[15]);
            float ox = (vec[x] * this.val[0] + vec[y] * this.val[4] + this.val[12]) * inv_w;
            vec[y] = (vec[x] * this.val[1] + vec[y] * this.val[5] + this.val[13]) * inv_w;
            vec[x] = ox;
            x += 2;
            y += 2;
        }
    }

    public void prj2D(float[] src, int src_offset, float[] dst, int dst_offset, int length) {
        if (src == null || src_offset < 0 || length + src_offset * 2 > src.length) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        int x = src_offset << 1;
        int y = x + 1;
        int end = x + (length << 1);
        dst_offset <<= 1;
        while (x < end) {
            float inv_w = 1.0f / (src[x] * this.val[3] + src[y] * this.val[7] + this.val[15]);
            dst[dst_offset++] = (src[x] * this.val[0] + src[y] * this.val[4] + this.val[12]) * inv_w;
            dst[dst_offset++] = (src[x] * this.val[1] + src[y] * this.val[5] + this.val[13]) * inv_w;
            x += 2;
            y += 2;
        }
    }

    public void multiplyRhs(GLMatrix rhs) {
        GLMatrix.matrix4_mul(this.val, rhs.val);
    }

    public void multiplyLhs(GLMatrix lhs) {
        System.arraycopy(lhs.val, 0, this.tmp, 0, 16);
        GLMatrix.matrix4_mul(this.tmp, this.val);
        System.arraycopy(this.tmp, 0, this.val, 0, 16);
    }

    public void multiplyMM(GLMatrix lhs, GLMatrix rhs) {
        System.arraycopy(lhs.val, 0, this.tmp, 0, 16);
        GLMatrix.matrix4_mul(this.tmp, rhs.val);
        System.arraycopy(this.tmp, 0, this.val, 0, 16);
    }

    public void transposeM(GLMatrix mat) {
        this.val[0] = mat.val[0];
        this.val[4] = mat.val[1];
        this.val[8] = mat.val[2];
        this.val[12] = mat.val[3];
        this.val[1] = mat.val[4];
        this.val[5] = mat.val[5];
        this.val[9] = mat.val[6];
        this.val[13] = mat.val[7];
        this.val[2] = mat.val[8];
        this.val[6] = mat.val[9];
        this.val[10] = mat.val[10];
        this.val[14] = mat.val[11];
        this.val[3] = mat.val[12];
        this.val[7] = mat.val[13];
        this.val[11] = mat.val[14];
        this.val[15] = mat.val[15];
    }

    public void setRotation(float a, float x, float y, float z) {
        this.setRotateM(this.val, 0, a, x, y, z);
    }

    public void setTranslation(float x, float y, float z) {
        this.setIdentity();
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
    }

    public void setScale(float x, float y, float z) {
        this.setIdentity();
        this.val[0] = x;
        this.val[5] = y;
        this.val[10] = z;
    }

    public void setTransScale(float tx, float ty, float scale) {
        this.setIdentity();
        this.val[12] = tx;
        this.val[13] = ty;
        this.val[0] = scale;
        this.val[5] = scale;
    }

    public void setAsUniform(int location) {
        this.buffer.clear();
        this.buffer.put(this.val, 0, 16);
        this.buffer.position(0);
        GLAdapter.gl.uniformMatrix4fv(location, 1, false, this.buffer);
    }

    public void setValue(int pos, float value) {
        this.val[pos] = value;
    }

    public void addDepthOffset(int delta) {
        this.val[10] = this.val[10] * (1.0f + PiTimesThumb * (float)delta);
    }

    public void setIdentity() {
        this.val[0] = 1.0f;
        this.val[4] = 0.0f;
        this.val[8] = 0.0f;
        this.val[12] = 0.0f;
        this.val[1] = 0.0f;
        this.val[5] = 1.0f;
        this.val[9] = 0.0f;
        this.val[13] = 0.0f;
        this.val[2] = 0.0f;
        this.val[6] = 0.0f;
        this.val[10] = 1.0f;
        this.val[14] = 0.0f;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
    }

    static void matrix4_mul(float[] mata, float[] matb) {
        float[] tmp = new float[16];
        tmp[0] = mata[0] * matb[0] + mata[4] * matb[1] + mata[8] * matb[2] + mata[12] * matb[3];
        tmp[4] = mata[0] * matb[4] + mata[4] * matb[5] + mata[8] * matb[6] + mata[12] * matb[7];
        tmp[8] = mata[0] * matb[8] + mata[4] * matb[9] + mata[8] * matb[10] + mata[12] * matb[11];
        tmp[12] = mata[0] * matb[12] + mata[4] * matb[13] + mata[8] * matb[14] + mata[12] * matb[15];
        tmp[1] = mata[1] * matb[0] + mata[5] * matb[1] + mata[9] * matb[2] + mata[13] * matb[3];
        tmp[5] = mata[1] * matb[4] + mata[5] * matb[5] + mata[9] * matb[6] + mata[13] * matb[7];
        tmp[9] = mata[1] * matb[8] + mata[5] * matb[9] + mata[9] * matb[10] + mata[13] * matb[11];
        tmp[13] = mata[1] * matb[12] + mata[5] * matb[13] + mata[9] * matb[14] + mata[13] * matb[15];
        tmp[2] = mata[2] * matb[0] + mata[6] * matb[1] + mata[10] * matb[2] + mata[14] * matb[3];
        tmp[6] = mata[2] * matb[4] + mata[6] * matb[5] + mata[10] * matb[6] + mata[14] * matb[7];
        tmp[10] = mata[2] * matb[8] + mata[6] * matb[9] + mata[10] * matb[10] + mata[14] * matb[11];
        tmp[14] = mata[2] * matb[12] + mata[6] * matb[13] + mata[10] * matb[14] + mata[14] * matb[15];
        tmp[3] = mata[3] * matb[0] + mata[7] * matb[1] + mata[11] * matb[2] + mata[15] * matb[3];
        tmp[7] = mata[3] * matb[4] + mata[7] * matb[5] + mata[11] * matb[6] + mata[15] * matb[7];
        tmp[11] = mata[3] * matb[8] + mata[7] * matb[9] + mata[11] * matb[10] + mata[15] * matb[11];
        tmp[15] = mata[3] * matb[12] + mata[7] * matb[13] + mata[11] * matb[14] + mata[15] * matb[15];
        System.arraycopy(tmp, 0, mata, 0, 16);
    }

    public static void frustumM(float[] m, int offset, float left, float right, float bottom, float top, float near, float far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (top == bottom) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        if (near <= 0.0f) {
            throw new IllegalArgumentException("near <= 0.0f");
        }
        if (far <= 0.0f) {
            throw new IllegalArgumentException("far <= 0.0f");
        }
        float r_width = 1.0f / (right - left);
        float r_height = 1.0f / (top - bottom);
        float r_depth = 1.0f / (near - far);
        float x = 2.0f * (near * r_width);
        float y = 2.0f * (near * r_height);
        float A = (right + left) * r_width;
        float B = (top + bottom) * r_height;
        float C = (far + near) * r_depth;
        float D = 2.0f * (far * near * r_depth);
        m[offset + 0] = x;
        m[offset + 5] = y;
        m[offset + 8] = A;
        m[offset + 9] = B;
        m[offset + 10] = C;
        m[offset + 14] = D;
        m[offset + 11] = -1.0f;
        m[offset + 1] = 0.0f;
        m[offset + 2] = 0.0f;
        m[offset + 3] = 0.0f;
        m[offset + 4] = 0.0f;
        m[offset + 6] = 0.0f;
        m[offset + 7] = 0.0f;
        m[offset + 12] = 0.0f;
        m[offset + 13] = 0.0f;
        m[offset + 15] = 0.0f;
    }

    public static boolean invertM(float[] mInv, int mInvOffset, float[] m, int mOffset) {
        float src0 = m[mOffset + 0];
        float src4 = m[mOffset + 1];
        float src8 = m[mOffset + 2];
        float src12 = m[mOffset + 3];
        float src1 = m[mOffset + 4];
        float src5 = m[mOffset + 5];
        float src9 = m[mOffset + 6];
        float src13 = m[mOffset + 7];
        float src2 = m[mOffset + 8];
        float src6 = m[mOffset + 9];
        float src10 = m[mOffset + 10];
        float src14 = m[mOffset + 11];
        float src3 = m[mOffset + 12];
        float src7 = m[mOffset + 13];
        float src11 = m[mOffset + 14];
        float src15 = m[mOffset + 15];
        float atmp0 = src10 * src15;
        float atmp1 = src11 * src14;
        float atmp2 = src9 * src15;
        float atmp3 = src11 * src13;
        float atmp4 = src9 * src14;
        float atmp5 = src10 * src13;
        float atmp6 = src8 * src15;
        float atmp7 = src11 * src12;
        float atmp8 = src8 * src14;
        float atmp9 = src10 * src12;
        float atmp10 = src8 * src13;
        float atmp11 = src9 * src12;
        float dst0 = atmp0 * src5 + atmp3 * src6 + atmp4 * src7 - (atmp1 * src5 + atmp2 * src6 + atmp5 * src7);
        float dst1 = atmp1 * src4 + atmp6 * src6 + atmp9 * src7 - (atmp0 * src4 + atmp7 * src6 + atmp8 * src7);
        float dst2 = atmp2 * src4 + atmp7 * src5 + atmp10 * src7 - (atmp3 * src4 + atmp6 * src5 + atmp11 * src7);
        float dst3 = atmp5 * src4 + atmp8 * src5 + atmp11 * src6 - (atmp4 * src4 + atmp9 * src5 + atmp10 * src6);
        float dst4 = atmp1 * src1 + atmp2 * src2 + atmp5 * src3 - (atmp0 * src1 + atmp3 * src2 + atmp4 * src3);
        float dst5 = atmp0 * src0 + atmp7 * src2 + atmp8 * src3 - (atmp1 * src0 + atmp6 * src2 + atmp9 * src3);
        float dst6 = atmp3 * src0 + atmp6 * src1 + atmp11 * src3 - (atmp2 * src0 + atmp7 * src1 + atmp10 * src3);
        float dst7 = atmp4 * src0 + atmp9 * src1 + atmp10 * src2 - (atmp5 * src0 + atmp8 * src1 + atmp11 * src2);
        float btmp0 = src2 * src7;
        float btmp1 = src3 * src6;
        float btmp2 = src1 * src7;
        float btmp3 = src3 * src5;
        float btmp4 = src1 * src6;
        float btmp5 = src2 * src5;
        float btmp6 = src0 * src7;
        float btmp7 = src3 * src4;
        float btmp8 = src0 * src6;
        float btmp9 = src2 * src4;
        float btmp10 = src0 * src5;
        float btmp11 = src1 * src4;
        float dst8 = btmp0 * src13 + btmp3 * src14 + btmp4 * src15 - (btmp1 * src13 + btmp2 * src14 + btmp5 * src15);
        float dst9 = btmp1 * src12 + btmp6 * src14 + btmp9 * src15 - (btmp0 * src12 + btmp7 * src14 + btmp8 * src15);
        float dst10 = btmp2 * src12 + btmp7 * src13 + btmp10 * src15 - (btmp3 * src12 + btmp6 * src13 + btmp11 * src15);
        float dst11 = btmp5 * src12 + btmp8 * src13 + btmp11 * src14 - (btmp4 * src12 + btmp9 * src13 + btmp10 * src14);
        float dst12 = btmp2 * src10 + btmp5 * src11 + btmp1 * src9 - (btmp4 * src11 + btmp0 * src9 + btmp3 * src10);
        float dst13 = btmp8 * src11 + btmp0 * src8 + btmp7 * src10 - (btmp6 * src10 + btmp9 * src11 + btmp1 * src8);
        float dst14 = btmp6 * src9 + btmp11 * src11 + btmp3 * src8 - (btmp10 * src11 + btmp2 * src8 + btmp7 * src9);
        float dst15 = btmp10 * src10 + btmp4 * src8 + btmp9 * src9 - (btmp8 * src9 + btmp11 * src10 + btmp5 * src8);
        float det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
        if (det == 0.0f) {
            return false;
        }
        float invdet = 1.0f / det;
        mInv[mInvOffset] = dst0 * invdet;
        mInv[1 + mInvOffset] = dst1 * invdet;
        mInv[2 + mInvOffset] = dst2 * invdet;
        mInv[3 + mInvOffset] = dst3 * invdet;
        mInv[4 + mInvOffset] = dst4 * invdet;
        mInv[5 + mInvOffset] = dst5 * invdet;
        mInv[6 + mInvOffset] = dst6 * invdet;
        mInv[7 + mInvOffset] = dst7 * invdet;
        mInv[8 + mInvOffset] = dst8 * invdet;
        mInv[9 + mInvOffset] = dst9 * invdet;
        mInv[10 + mInvOffset] = dst10 * invdet;
        mInv[11 + mInvOffset] = dst11 * invdet;
        mInv[12 + mInvOffset] = dst12 * invdet;
        mInv[13 + mInvOffset] = dst13 * invdet;
        mInv[14 + mInvOffset] = dst14 * invdet;
        mInv[15 + mInvOffset] = dst15 * invdet;
        return true;
    }

    void setRotateM(float[] rm, int rmOffset, float a, float x, float y, float z) {
        rm[rmOffset + 3] = 0.0f;
        rm[rmOffset + 7] = 0.0f;
        rm[rmOffset + 11] = 0.0f;
        rm[rmOffset + 12] = 0.0f;
        rm[rmOffset + 13] = 0.0f;
        rm[rmOffset + 14] = 0.0f;
        rm[rmOffset + 15] = 1.0f;
        float s = (float)Math.sin(a *= (float)Math.PI / 180);
        float c = (float)Math.cos(a);
        if (1.0f == x && 0.0f == y && 0.0f == z) {
            rm[rmOffset + 5] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 6] = s;
            rm[rmOffset + 9] = -s;
            rm[rmOffset + 1] = 0.0f;
            rm[rmOffset + 2] = 0.0f;
            rm[rmOffset + 4] = 0.0f;
            rm[rmOffset + 8] = 0.0f;
            rm[rmOffset + 0] = 1.0f;
        } else if (0.0f == x && 1.0f == y && 0.0f == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 8] = s;
            rm[rmOffset + 2] = -s;
            rm[rmOffset + 1] = 0.0f;
            rm[rmOffset + 4] = 0.0f;
            rm[rmOffset + 6] = 0.0f;
            rm[rmOffset + 9] = 0.0f;
            rm[rmOffset + 5] = 1.0f;
        } else if (0.0f == x && 0.0f == y && 1.0f == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 5] = c;
            rm[rmOffset + 1] = s;
            rm[rmOffset + 4] = -s;
            rm[rmOffset + 2] = 0.0f;
            rm[rmOffset + 6] = 0.0f;
            rm[rmOffset + 8] = 0.0f;
            rm[rmOffset + 9] = 0.0f;
            rm[rmOffset + 10] = 1.0f;
        } else {
            float len = (float)Math.sqrt(x * x + y * y + z * z);
            if (1.0f != len) {
                float recipLen = 1.0f / len;
                x *= recipLen;
                y *= recipLen;
                z *= recipLen;
            }
            float nc = 1.0f - c;
            float xy = x * y;
            float yz = y * z;
            float zx = z * x;
            float xs = x * s;
            float ys = y * s;
            float zs = z * s;
            rm[rmOffset + 0] = x * x * nc + c;
            rm[rmOffset + 4] = xy * nc - zs;
            rm[rmOffset + 8] = zx * nc + ys;
            rm[rmOffset + 1] = xy * nc + zs;
            rm[rmOffset + 5] = y * y * nc + c;
            rm[rmOffset + 9] = yz * nc - xs;
            rm[rmOffset + 2] = zx * nc - ys;
            rm[rmOffset + 6] = yz * nc + xs;
            rm[rmOffset + 10] = z * z * nc + c;
        }
    }
}

