/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx.client;

import com.google.gwt.canvas.dom.client.Context2d;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.oscim.gdx.client.GwtBitmap;
import org.oscim.gdx.client.GwtGdxGraphics;
import org.oscim.gdx.client.GwtPaint;

public class GwtCanvas
implements Canvas {
    GwtBitmap bitmap;

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = (GwtBitmap)bitmap;
        Context2d ctx = this.bitmap.pixmap.getContext();
        ctx.clearRect(0.0, 0.0, (double)this.bitmap.getWidth(), (double)this.bitmap.getHeight());
        ctx.setLineJoin(Context2d.LineJoin.BEVEL);
    }

    public void drawText(String string, float x, float y, Paint paint) {
        if (this.bitmap == null) {
            return;
        }
        GwtPaint p = (GwtPaint)paint;
        if (p.stroke && GwtGdxGraphics.NO_STROKE_TEXT) {
            return;
        }
        Context2d ctx = this.bitmap.pixmap.getContext();
        ctx.setFont(p.font);
        if (p.stroke) {
            ctx.setLineWidth((double)p.strokeWidth);
            ctx.setStrokeStyle(p.color);
            ctx.strokeText(string, (double)((int)(x + 1.0f)), (double)((int)(y + 1.0f)));
        } else {
            ctx.setFillStyle(p.color);
            ctx.fillText(string, (double)((int)(x + 1.0f)), (double)((int)(y + 1.0f)));
        }
    }

    public void drawText(String string, float x, float y, Paint fill, Paint stroke) {
        if (this.bitmap == null) {
            return;
        }
        GwtPaint p = (GwtPaint)fill;
        if (p.stroke && GwtGdxGraphics.NO_STROKE_TEXT) {
            return;
        }
        Context2d ctx = this.bitmap.pixmap.getContext();
        ctx.setFont(p.font);
        if (p.stroke) {
            ctx.setLineWidth((double)p.strokeWidth);
            ctx.setStrokeStyle(p.color);
            ctx.strokeText(string, (double)((int)(x + 1.0f)), (double)((int)(y + 1.0f)));
        } else {
            ctx.setFillStyle(p.color);
            ctx.fillText(string, (double)((int)(x + 1.0f)), (double)((int)(y + 1.0f)));
        }
    }

    public void drawBitmap(Bitmap bitmap, float x, float y) {
    }

    public void drawBitmapScaled(Bitmap bitmap) {
    }

    public void drawCircle(float x, float y, float radius, Paint paint) {
    }

    public void drawLine(float x1, float y1, float x2, float y2, Paint paint) {
    }

    public void fillColor(int color) {
    }

    public int getHeight() {
        return this.bitmap != null ? this.bitmap.getHeight() : 0;
    }

    public int getWidth() {
        return this.bitmap != null ? this.bitmap.getWidth() : 0;
    }
}

