/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.backend.canvas;

import org.oscim.utils.ColorUtil;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Vec3;

public final class Color {
    private static final int OPAQUE = -16777216;
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;

    public static int fadePremul(int color, double alpha) {
        alpha = FastMath.clamp(alpha, 0.0, 1.0);
        int c = ((int)(alpha *= (double)(color >>> 24 & 0xFF)) & 0xFF) << 24;
        c |= (int)((alpha /= 255.0) * (double)(color >>> 16 & 0xFF)) << 16;
        c |= (int)(alpha * (double)(color >>> 8 & 0xFF)) << 8;
        return c |= (int)(alpha * (double)(color & 0xFF));
    }

    public static int fade(int color, double alpha) {
        alpha = FastMath.clamp(alpha, 0.0, 1.0);
        int c = ((int)(alpha *= (double)(color >>> 24 & 0xFF)) & 0xFF) << 24;
        return c | color & 0xFFFFFF;
    }

    public static int rainbow(float pos) {
        float i = 255.0f * pos;
        int r = (int)Math.round(Math.sin(0.024 * (double)i + 0.0) * 127.0 + 128.0);
        int g = (int)Math.round(Math.sin(0.024 * (double)i + 2.0) * 127.0 + 128.0);
        int b = (int)Math.round(Math.sin(0.024 * (double)i + 4.0) * 127.0 + 128.0);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int get(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int get(double r, double g, double b) {
        return 0xFF000000 | (int)Math.round(r * 255.0) << 16 | (int)Math.round(g * 255.0) << 8 | (int)Math.round(b * 255.0);
    }

    public static int get(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int get(float a, int r, int g, int b) {
        return Color.fade(0xFF000000 | r << 16 | g << 8 | b, a);
    }

    public static float rToFloat(int color) {
        return (float)(color >>> 16 & 0xFF) / 255.0f;
    }

    public static float gToFloat(int color) {
        return (float)(color >>> 8 & 0xFF) / 255.0f;
    }

    public static float bToFloat(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float aToFloat(int color) {
        return (float)(color >>> 24 & 0xFF) / 255.0f;
    }

    public static int a(int color) {
        return color >>> 24 & 0xFF;
    }

    public static int r(int color) {
        return color >>> 16 & 0xFF;
    }

    public static int g(int color) {
        return color >>> 8 & 0xFF;
    }

    public static int b(int color) {
        return color & 0xFF;
    }

    public static int setA(int color, int a) {
        return a << 24 | color & 0xFFFFFF;
    }

    public static int setR(int color, int r) {
        return r << 16 | color & 0xFF00FFFF;
    }

    public static int setG(int color, int g) {
        return g << 8 | color & 0xFFFF00FF;
    }

    public static int setB(int color, int b) {
        return b | color & 0xFFFFFF00;
    }

    public static int parseColorComponents(String str) {
        int numComponents = 4;
        int cur = 5;
        if (str.startsWith("rgb(")) {
            numComponents = 3;
            cur = 4;
        } else if (!str.startsWith("rgba(")) {
            Color.parseColorException(str);
        }
        int end = str.length();
        int component = 0;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        if (str.charAt(end - 1) != ')') {
            Color.parseColorException(str);
        }
        while (cur < end) {
            char c = str.charAt(cur);
            if (c == ',') {
                if (++component >= numComponents) {
                    Color.parseColorException(str);
                }
            } else if (c >= '0' && c <= '9') {
                if (component == 0) {
                    r *= 10;
                    r += c - 48;
                } else if (component == 1) {
                    g *= 10;
                    g += c - 48;
                } else if (component == 2) {
                    b *= 10;
                    b += c - 48;
                } else {
                    a *= 10;
                    a += c - 48;
                }
            } else {
                Color.parseColorException(str);
            }
            ++cur;
        }
        if (r > 255 || g > 255 || b > 255 || a > 255) {
            Color.parseColorException(str);
        }
        if (numComponents == 3) {
            return Color.get(r, g, b);
        }
        return Color.get(a, r, g, b);
    }

    private static void parseColorException(String str) {
        throw new IllegalArgumentException("Unknown color: '" + str + '\'');
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                Color.parseColorException(colorString);
            }
            return (int)color;
        }
        if (colorString.charAt(0) == 'r') {
            return Color.parseColorComponents(colorString);
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static int parseColor(String colorString, int fallBackColor) {
        if (colorString.charAt(0) == '#') {
            long color = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                return fallBackColor;
            }
            return (int)color;
        }
        return fallBackColor;
    }

    public static boolean isOpaque(int color) {
        return (color & 0xFF000000) == -16777216;
    }

    public static String toString(int color) {
        return "RGB: " + Color.r(color) + ", " + Color.g(color) + ", " + Color.b(color);
    }

    private Color() {
    }

    public static class HSV {
        public double hue;
        public double saturation;
        public double value;

        public HSV() {
            this.hue = 0.0;
            this.saturation = 1.0;
            this.value = 1.0;
        }

        public HSV(double hue, double saturation, double value) {
            this.hue = hue;
            this.saturation = saturation;
            this.value = value;
        }

        public HSV(Vec3 hsv) {
            this.hue = hsv.x;
            this.saturation = hsv.y;
            this.value = hsv.z;
        }

        public int mod(int color, boolean relative) {
            return ColorUtil.modHsv(color, this.hue, this.saturation, this.value, relative);
        }

        public String toString() {
            return "HSV: " + this.hue + ", " + this.saturation + ", " + this.value;
        }
    }
}

