/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;

public class Box {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;

    public Box() {
    }

    public Box(double x, double y) {
        this.xmax = this.xmin = x;
        this.ymax = this.ymin = y;
    }

    public Box(double xmin, double ymin, double xmax, double ymax) {
        if (xmin > xmax || ymin > ymax) {
            throw new IllegalArgumentException("min > max !");
        }
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    public Box(Box bbox) {
        this.xmin = bbox.xmin;
        this.ymin = bbox.ymin;
        this.xmax = bbox.xmax;
        this.ymax = bbox.ymax;
    }

    public void add(double x, double y) {
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
        if (x > this.xmax) {
            this.xmax = x;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
    }

    public void add(Box bbox) {
        if (bbox.xmin < this.xmin) {
            this.xmin = bbox.xmin;
        }
        if (bbox.ymin < this.ymin) {
            this.ymin = bbox.ymin;
        }
        if (bbox.xmax > this.xmax) {
            this.xmax = bbox.xmax;
        }
        if (bbox.ymax > this.ymax) {
            this.ymax = bbox.ymax;
        }
    }

    public boolean contains(double x, double y) {
        return x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax;
    }

    public boolean contains(Point p) {
        return p.x >= this.xmin && p.x <= this.xmax && p.y >= this.ymin && p.y <= this.ymax;
    }

    public static Box createSafe(double x1, double y1, double x2, double y2) {
        return new Box(x1 < x2 ? x1 : x2, y1 < y2 ? y1 : y2, x1 > x2 ? x1 : x2, y1 > y2 ? y1 : y2);
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public boolean inside(Box box) {
        return this.xmin >= box.xmin && this.xmax <= box.xmax && this.ymin >= box.ymin && this.ymax <= box.ymax;
    }

    public void map2mercator() {
        double minLon = MercatorProjection.toLongitude(this.xmin);
        double maxLon = MercatorProjection.toLongitude(this.xmax);
        double minLat = MercatorProjection.toLatitude(this.ymax);
        double maxLat = MercatorProjection.toLatitude(this.ymin);
        this.xmin = minLon;
        this.xmax = maxLon;
        this.ymin = minLat;
        this.ymax = maxLat;
    }

    public boolean overlap(Box other) {
        return !(this.xmin > other.xmax || this.xmax < other.xmin || this.ymin > other.ymax || this.ymax < other.ymin);
    }

    public void scale(double d) {
        this.xmin *= d;
        this.xmax *= d;
        this.ymin *= d;
        this.ymax *= d;
    }

    public void setExtents(float[] points) {
        this.setExtents(points, points.length);
    }

    public void setExtents(float[] points, int length) {
        float y2;
        float x2;
        float x1 = x2 = points[0];
        float y1 = y2 = points[1];
        for (int i = 2; i < length; i += 2) {
            float x = points[i];
            if (x < x1) {
                x1 = x;
            } else if (x > x2) {
                x2 = x;
            }
            float y = points[i + 1];
            if (y < y1) {
                y1 = y;
                continue;
            }
            if (!(y > y2)) continue;
            y2 = y;
        }
        this.xmin = x1;
        this.ymin = y1;
        this.xmax = x2;
        this.ymax = y2;
    }

    public String toString() {
        return "[" + this.xmin + ',' + this.ymin + ',' + this.xmax + ',' + this.ymax + ']';
    }

    public void translate(double dx, double dy) {
        this.xmin += dx;
        this.xmax += dx;
        this.ymin += dy;
        this.ymax += dy;
    }
}

