/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers;

import org.oscim.core.MercatorProjection;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.LocationTextureRenderer;
import org.oscim.renderer.atlas.TextureRegion;

public class LocationTextureLayer
extends Layer {
    public final LocationTextureRenderer locationRenderer;

    public LocationTextureLayer(Map map, TextureRegion textureRegion) {
        super(map);
        this.locationRenderer = new LocationTextureRenderer(map);
        this.mRenderer = this.locationRenderer;
        this.locationRenderer.setTextureRegion(textureRegion);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (!enabled) {
            this.locationRenderer.animate(false);
        }
    }

    public void setPosition(double latitude, double longitude, float bearing, float accuracy) {
        double x = MercatorProjection.longitudeToX(longitude);
        double y = MercatorProjection.latitudeToY(latitude);
        for (bearing = -bearing; bearing < 0.0f; bearing += 360.0f) {
        }
        double radius = (double)accuracy / MercatorProjection.groundResolutionWithScale(latitude, 1.0);
        this.locationRenderer.setLocation(x, y, bearing, radius);
        this.locationRenderer.animate(true);
    }
}

