/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileSet;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.ScanBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(TileRenderer.class);
    protected static final float FADE_TIME = 500.0f;
    protected static final int MAX_TILE_LOAD = 8;
    private TileManager mTileManager;
    protected final TileSet mDrawTiles;
    protected int mProxyTileCnt;
    private int mOverdraw = 0;
    private float mAlpha = 1.0f;
    protected int mOverdrawColor;
    protected float mLayerAlpha;
    private int mUploadSerial = 0;
    private final Object tilelock = new Object();
    private final ScanBox mScanBox = new ScanBox(){

        @Override
        protected void setVisible(int y, int x1, int x2) {
            MapTile[] tiles = TileRenderer.this.mDrawTiles.tiles;
            int proxyOffset = TileRenderer.this.mDrawTiles.cnt;
            for (int i = 0; i < proxyOffset; ++i) {
                MapTile t = tiles[i];
                if (t.tileY != y || t.tileX < x1 || t.tileX >= x2) continue;
                t.isVisible = true;
            }
            int xmax = 1 << this.mZoom;
            if (x1 >= 0 && x2 < xmax) {
                return;
            }
            block1: for (int x = x1; x < x2; ++x) {
                if (x >= 0 && x < xmax) continue;
                int xx = x;
                xx = x < 0 ? xmax + x : x - xmax;
                if (xx < 0 || xx >= xmax) continue;
                for (int i = proxyOffset; i < proxyOffset + TileRenderer.this.mProxyTileCnt; ++i) {
                    if (tiles[i].tileX == x && tiles[i].tileY == y) continue block1;
                }
                MapTile tile = null;
                for (int i = 0; i < proxyOffset; ++i) {
                    if (tiles[i].tileX != xx || tiles[i].tileY != y) continue;
                    tile = tiles[i];
                    break;
                }
                if (tile == null) continue;
                if (proxyOffset + TileRenderer.this.mProxyTileCnt >= tiles.length) break;
                MapTile holder = new MapTile(null, x, y, (byte)this.mZoom);
                holder.isVisible = true;
                holder.holder = tile;
                holder.state = tile.state;
                tile.isVisible = true;
                tiles[proxyOffset + TileRenderer.this.mProxyTileCnt++] = holder;
            }
        }
    };

    public TileRenderer() {
        this.mDrawTiles = new TileSet();
    }

    protected void setTileManager(TileManager tileManager) {
        this.mTileManager = tileManager;
    }

    public synchronized void setOverdrawColor(int color) {
        this.mOverdraw = color;
    }

    public synchronized void setBitmapAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(GLViewport v) {
        if (this.mAlpha == 0.0f) {
            this.mDrawTiles.releaseTiles();
            this.setReady(false);
            return;
        }
        this.mLayerAlpha = this.mAlpha;
        this.mOverdrawColor = this.mOverdraw;
        Object object = this.tilelock;
        synchronized (object) {
            boolean tilesChanged = this.mTileManager.getActiveTiles(this.mDrawTiles);
            if (this.mDrawTiles.cnt == 0) {
                this.setReady(false);
                this.mProxyTileCnt = 0;
                return;
            }
            if (tilesChanged || v.changed()) {
                this.mProxyTileCnt = 0;
                MapTile[] tiles = this.mDrawTiles.tiles;
                byte tileZoom = tiles[0].zoomLevel;
                for (int i = 0; i < this.mDrawTiles.cnt; ++i) {
                    tiles[i].isVisible = false;
                }
                this.mScanBox.scan(v.pos.x, v.pos.y, v.pos.scale, tileZoom, v.plane);
            }
        }
        if (TileRenderer.compileTileLayers(this.mDrawTiles.tiles, this.mDrawTiles.cnt + this.mProxyTileCnt) > 0) {
            ++this.mUploadSerial;
            BufferObject.checkBufferUsage(false);
        }
        this.setReady(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTiles() {
        Object object = this.tilelock;
        synchronized (object) {
            this.mDrawTiles.releaseTiles();
            this.mDrawTiles.tiles = new MapTile[1];
            this.mDrawTiles.cnt = 0;
        }
    }

    private static int compileTileLayers(MapTile[] tiles, int tileCnt) {
        int uploadCnt = 0;
        for (int i = 0; i < tileCnt; ++i) {
            MapTile tile = tiles[i];
            if (!tile.isVisible || tile.state(8)) continue;
            if (tile.state(4)) {
                uploadCnt += TileRenderer.uploadTileData(tile);
                continue;
            }
            MapTile proxy = tile.holder;
            if (proxy != null && (proxy.state(4) || proxy.state(8))) {
                tile.state = (byte)4;
                uploadCnt += TileRenderer.uploadTileData(tile);
                continue;
            }
            proxy = tile.getProxy(16, (byte)4);
            if (proxy != null) {
                uploadCnt += TileRenderer.uploadTileData(proxy);
                continue;
            }
            for (int c = 0; c < 4; ++c) {
                proxy = tile.getProxyChild(c, (byte)4);
                if (proxy == null) continue;
                uploadCnt += TileRenderer.uploadTileData(proxy);
            }
            if (uploadCnt >= 8) break;
        }
        return uploadCnt;
    }

    private static int uploadTileData(MapTile tile) {
        tile.setState((byte)8);
        RenderBuckets buckets = tile.getBuckets();
        if (buckets == null) {
            return 0;
        }
        if (!buckets.compile(true)) {
            buckets.clear();
            return 0;
        }
        return 1;
    }

    public boolean getVisibleTiles(TileSet tileSet) {
        return this.getVisibleTiles(tileSet, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVisibleTiles(TileSet tileSet, boolean replace) {
        if (tileSet == null) {
            return null;
        }
        if (this.mDrawTiles == null) {
            this.releaseTiles(tileSet);
            return null;
        }
        Integer zoom = null;
        int prevSerial = tileSet.serial;
        Object object = this.tilelock;
        synchronized (object) {
            MapTile t;
            int i;
            MapTile[] newTiles = this.mDrawTiles.tiles;
            int cnt = this.mDrawTiles.cnt;
            if (tileSet.tiles.length != newTiles.length) {
                tileSet.tiles = new MapTile[newTiles.length];
            }
            tileSet.cnt = 0;
            for (i = 0; i < cnt; ++i) {
                t = newTiles[i];
                if (!t.isVisible || !t.state(8)) continue;
                t.lock();
            }
            if (cnt > 0) {
                zoom = newTiles[0].zoomLevel;
            }
            tileSet.releaseTiles();
            block4: for (i = 0; i < cnt; ++i) {
                t = newTiles[i];
                if (!t.isVisible) continue;
                if (t.state(8)) {
                    tileSet.tiles[tileSet.cnt++] = t;
                    continue;
                }
                if (!replace) continue;
                for (int j = t.zoomLevel - 1; j > this.mTileManager.mMinZoom; --j) {
                    int diff = t.zoomLevel - j;
                    MapTile parent = this.mTileManager.getTile(t.tileX >> diff, t.tileY >> diff, j);
                    if (parent == null || !parent.state(8)) continue;
                    parent.lock();
                    tileSet.tiles[tileSet.cnt++] = parent;
                    continue block4;
                }
            }
            tileSet.serial = this.mUploadSerial;
        }
        return prevSerial != tileSet.serial ? zoom : null;
    }

    public void releaseTiles(TileSet tileSet) {
        tileSet.releaseTiles();
    }

    public static long getMinFade(MapTile tile, int proxyLevel) {
        long minFade = MapRenderer.frametime - 50L;
        if (proxyLevel <= 0) {
            for (int c = 0; c < 4; ++c) {
                long m;
                MapTile ci = (MapTile)tile.node.child(c);
                if (ci == null) continue;
                if (ci.fadeTime > 0L && ci.fadeTime < minFade) {
                    minFade = ci.fadeTime;
                }
                if (proxyLevel < -1 || (m = TileRenderer.getMinFade(ci, proxyLevel - 1)) >= minFade) continue;
                minFade = m;
            }
        }
        MapTile.TileNode p = (MapTile.TileNode)tile.node.parent;
        for (int i = proxyLevel; i >= -1 && p != null; --i) {
            if (p.item != null && ((MapTile)p.item).fadeTime > 0L && ((MapTile)p.item).fadeTime < minFade) {
                minFade = ((MapTile)p.item).fadeTime;
            }
            p = (MapTile.TileNode)p.parent;
        }
        return minFade;
    }
}

