/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.FastMath;

public class VectorTileRenderer
extends TileRenderer {
    static final boolean debugOverdraw = false;
    protected int mClipMode;
    protected GLMatrix mClipProj = new GLMatrix();
    protected GLMatrix mClipMVP = new GLMatrix();
    protected int mDrawSerial;

    @Override
    public synchronized void render(GLViewport v) {
        MapTile t;
        int i;
        boolean preferParent;
        MapTile t2;
        int i2;
        this.mClipProj.copy(v.proj);
        this.mClipProj.setValue(10, 0.0f);
        this.mClipProj.setValue(14, 0.0f);
        this.mClipProj.multiplyRhs(v.view);
        this.mClipMode = 1;
        int tileCnt = this.mDrawTiles.cnt + this.mProxyTileCnt;
        MapTile[] tiles = this.mDrawTiles.tiles;
        boolean drawProxies = false;
        ++this.mDrawSerial;
        for (i2 = 0; i2 < tileCnt; ++i2) {
            t2 = tiles[i2];
            if (!t2.isVisible || t2.state(8)) continue;
            GLAdapter.gl.depthMask(true);
            GLAdapter.gl.clear(256);
            GLAdapter.gl.depthFunc(519);
            this.mClipMode = 2;
            drawProxies = true;
            break;
        }
        for (i2 = 0; i2 < tileCnt; ++i2) {
            t2 = tiles[i2];
            if (!t2.isVisible || !t2.state(8)) continue;
            this.drawTile(t2, v, 0);
        }
        if (!drawProxies) {
            return;
        }
        GLAdapter.gl.depthFunc(513);
        boolean bl = preferParent = v.pos.getZoomScale() < 1.5 || v.pos.zoomLevel < tiles[0].zoomLevel;
        if (preferParent) {
            for (i = 0; i < tileCnt; ++i) {
                t = tiles[i];
                if (!t.isVisible || t.lastDraw == this.mDrawSerial || this.drawParent(t, v)) continue;
                this.drawChildren(t, v);
            }
        } else {
            for (i = 0; i < tileCnt; ++i) {
                t = tiles[i];
                if (!t.isVisible || t.lastDraw == this.mDrawSerial) continue;
                this.drawChildren(t, v);
            }
            for (i = 0; i < tileCnt; ++i) {
                t = tiles[i];
                if (!t.isVisible || t.lastDraw == this.mDrawSerial) continue;
                this.drawParent(t, v);
            }
        }
        for (i = 0; i < tileCnt; ++i) {
            t = tiles[i];
            if (!t.isVisible || t.lastDraw == this.mDrawSerial) continue;
            this.drawGrandParent(t, v);
        }
        GLAdapter.gl.depthMask(false);
    }

    private void drawTile(MapTile tile, GLViewport v, int proxyLevel) {
        RenderBuckets buckets;
        if (tile.lastDraw == this.mDrawSerial) {
            return;
        }
        tile.lastDraw = this.mDrawSerial;
        RenderBuckets renderBuckets = buckets = tile.holder == null ? tile.getBuckets() : tile.holder.getBuckets();
        if (buckets == null || buckets.vbo == null) {
            return;
        }
        double tileScale = (double)Tile.SIZE * v.pos.scale;
        float x = (float)((tile.x - v.pos.x) * tileScale);
        float y = (float)((tile.y - v.pos.y) * tileScale);
        float scale = (float)(v.pos.scale / (double)(1 << tile.zoomLevel));
        v.mvp.setTransScale(x, y, scale / MapRenderer.COORD_SCALE);
        v.mvp.multiplyLhs(v.viewproj);
        this.mClipMVP.setTransScale(x, y, scale / MapRenderer.COORD_SCALE);
        this.mClipMVP.multiplyLhs(this.mClipProj);
        float zoomDiv = FastMath.pow(tile.zoomLevel - v.pos.zoomLevel);
        buckets.bind();
        PolygonBucket.Renderer.clip(this.mClipMVP, this.mClipMode);
        boolean first = true;
        RenderBucket b = buckets.get();
        while (b != null) {
            switch (b.type) {
                case 2: {
                    b = PolygonBucket.Renderer.draw(b, v, zoomDiv, first);
                    first = false;
                    GLAdapter.gl.stencilFunc(514, 128, 128);
                    break;
                }
                case 0: {
                    b = LineBucket.Renderer.draw(b, v, scale, buckets);
                    break;
                }
                case 1: {
                    b = LineTexBucket.Renderer.draw(b, v, zoomDiv, buckets);
                    break;
                }
                case 3: {
                    b = MeshBucket.Renderer.draw(b, v);
                    break;
                }
                case 5: {
                    b = HairLineBucket.Renderer.draw(b, v);
                    break;
                }
                case 7: {
                    b = BitmapBucket.Renderer.draw(b, v, 1.0f, this.mLayerAlpha);
                    break;
                }
                case 8: {
                    b = CircleBucket.Renderer.draw(b, v);
                    break;
                }
                default: {
                    log.error("unknown layer {}", (Object)b.type);
                    b = (RenderBucket)b.next;
                }
            }
            buckets.bind();
        }
        long fadeTime = tile.fadeTime;
        if (fadeTime == 0L) {
            if (tile.holder == null) {
                fadeTime = VectorTileRenderer.getMinFade(tile, proxyLevel);
            } else {
                fadeTime = tile.holder.fadeTime;
                if (fadeTime == 0L) {
                    fadeTime = VectorTileRenderer.getMinFade(tile.holder, proxyLevel);
                }
            }
            tile.fadeTime = fadeTime;
        }
        long dTime = MapRenderer.frametime - fadeTime;
        if (this.mOverdrawColor == 0 || (float)dTime > 500.0f) {
            PolygonBucket.Renderer.drawOver(this.mClipMVP, 0, 1.0f);
            return;
        }
        float fade = 1.0f - (float)dTime / 500.0f;
        PolygonBucket.Renderer.drawOver(this.mClipMVP, this.mOverdrawColor, fade * fade);
        MapRenderer.animate();
    }

    protected boolean drawChildren(MapTile t, GLViewport v) {
        int drawn = 0;
        for (int i = 0; i < 4; ++i) {
            MapTile c = t.getProxyChild(i, (byte)8);
            if (c == null) continue;
            this.drawTile(c, v, 1);
            ++drawn;
        }
        if (drawn == 4) {
            t.lastDraw = this.mDrawSerial;
            return true;
        }
        return false;
    }

    protected boolean drawParent(MapTile t, GLViewport v) {
        MapTile proxy = t.getProxy(16, (byte)8);
        if (proxy != null) {
            this.drawTile(proxy, v, -1);
            t.lastDraw = this.mDrawSerial;
            return true;
        }
        return false;
    }

    protected void drawGrandParent(MapTile t, GLViewport v) {
        MapTile proxy = t.getProxy(32, (byte)8);
        if (proxy != null) {
            this.drawTile(proxy, v, -2);
            t.lastDraw = this.mDrawSerial;
        }
    }
}

