/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.MapPosition;
import org.oscim.layers.tile.vector.labeling.Label;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.LineStyle;

class Debug {
    private static final float[] mDebugPoints = new float[8];
    static RenderBuckets dbg;

    Debug() {
    }

    static void addDebugBox(Label l, TextItem ti, int overlaps, boolean prev, float scale) {
        LineBucket ll;
        if (prev) {
            ll = overlaps == 1 ? dbg.getLineBucket(4) : dbg.getLineBucket(5);
        } else if (ti.width > (float)ti.length * scale) {
            ll = dbg.getLineBucket(1);
            overlaps = 3;
        } else {
            ll = overlaps == 1 ? dbg.getLineBucket(0) : (overlaps == 2 ? dbg.getLineBucket(3) : dbg.getLineBucket(2));
        }
        float[] points = mDebugPoints;
        float width = (ti.x2 - ti.x1) / 2.0f;
        float height = (ti.y2 - ti.y1) / 2.0f;
        points[0] = l.x - width * scale;
        points[1] = l.y - height * scale;
        points[2] = l.x + width * scale;
        points[3] = l.y + height * scale;
        ll.addLine(points, 4, false);
        System.arraycopy(l.bbox.vec, 2, points, 0, 8);
        if (l.bbox != null && overlaps != 3) {
            ll.addLine(points, 8, true);
        }
    }

    static void addDebugLayers(RenderBuckets dbg) {
        int alpha = -1426063361;
        dbg.clear();
        dbg.addLineBucket(0, new LineStyle(0xFF0000FF & alpha, 2.0f));
        dbg.addLineBucket(1, new LineStyle(0xFFFF0000 & alpha, 2.0f));
        dbg.addLineBucket(3, new LineStyle(0xFFFFFF00 & alpha, 2.0f));
        dbg.addLineBucket(2, new LineStyle(0xFF00FF00 & alpha, 2.0f));
        dbg.addLineBucket(4, new LineStyle(0xFF00FFFF & alpha, 2.0f));
        dbg.addLineBucket(5, new LineStyle(0xFFFF00FF & alpha, 2.0f));
    }

    public static void draw(MapPosition pos, GLViewport m, RenderBuckets layers) {
    }
}

