/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.map.Animator;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.oscim.utils.ThreadUtils;
import org.oscim.utils.animation.DragForce;
import org.oscim.utils.animation.Easing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Animator2
extends Animator {
    private static final Logger log = LoggerFactory.getLogger(Animator2.class);
    private static final int ANIM_KINETIC = 32;
    private static final float DEFAULT_MIN_VISIBLE_CHANGE_PIXELS = 0.6f;
    private static final float DEFAULT_MIN_VISIBLE_CHANGE_RADIAN = 0.001f;
    private static final float DEFAULT_MIN_VISIBLE_CHANGE_SCALE = 1.0f;
    public static float FLING_FRICTION_MOVE = 1.0f;
    public static float FLING_FRICTION_ROTATE = 1.2f;
    public static float FLING_FRICTION_SCALE = 1.2f;
    private final DragForce mFlingRotateForce = new DragForce();
    private final DragForce mFlingScaleForce = new DragForce();
    private final DragForce mFlingScrollForce = new DragForce();
    private final Point mMovePoint = new Point();
    private final Point mScrollRatio = new Point();
    private long mFrameStart = -1L;
    private float mScrollDet2D = 1.0f;

    public Animator2(Map map) {
        super(map);
        this.mFlingRotateForce.setValueThreshold(0.001f);
        this.mFlingScrollForce.setValueThreshold(0.6f);
        this.mFlingScaleForce.setValueThreshold(1.0f);
    }

    public void animateFlingRotate(float angularVelocity, float pivotX, float pivotY) {
        ThreadUtils.assertMainThread();
        float flingFactor = -0.25f;
        this.mFlingRotateForce.setFrictionScalar(FLING_FRICTION_ROTATE);
        this.mFlingRotateForce.setValueAndVelocity(0.0f, angularVelocity *= flingFactor);
        if (!this.isActive()) {
            this.mMap.getMapPosition(this.mStartPos);
            this.mPivot.x = pivotX;
            this.mPivot.y = pivotY;
            this.animFlingStart(4);
        } else {
            this.mState |= 4;
        }
    }

    public void animateFlingScroll(float velocityX, float velocityY, int xmin, int xmax, int ymin, int ymax) {
        ThreadUtils.assertMainThread();
        if (velocityX * velocityX + velocityY * velocityY < 2048.0f) {
            return;
        }
        float flingFactor = 2.0f;
        float screenFactor = 160.0f / CanvasAdapter.dpi;
        velocityX *= screenFactor * flingFactor;
        velocityY *= screenFactor * flingFactor;
        velocityX = FastMath.clamp(velocityX, (float)xmin, (float)xmax);
        velocityY = FastMath.clamp(velocityY, (float)ymin, (float)ymax);
        float sumVelocity = Math.abs(velocityX) + Math.abs(velocityY);
        this.mScrollRatio.x = velocityX / sumVelocity;
        this.mScrollRatio.y = velocityY / sumVelocity;
        this.mScrollDet2D = (float)(this.mScrollRatio.x * this.mScrollRatio.x + this.mScrollRatio.y * this.mScrollRatio.y);
        this.mFlingScrollForce.setFrictionScalar(FLING_FRICTION_MOVE);
        this.mFlingScrollForce.setValueAndVelocity(0.0f, (float)Math.sqrt(velocityX * velocityX + velocityY * velocityY));
        if (!this.isActive()) {
            this.mMap.getMapPosition(this.mStartPos);
            this.animFlingStart(1);
        } else {
            this.mState |= 1;
        }
    }

    public void animateFlingZoom(float scaleVelocity, float pivotX, float pivotY) {
        ThreadUtils.assertMainThread();
        float flingFactor = -1.0f;
        float screenFactor = 160.0f / CanvasAdapter.dpi;
        this.mFlingScaleForce.setFrictionScalar(FLING_FRICTION_SCALE);
        this.mFlingScaleForce.setValueAndVelocity(0.0f, scaleVelocity *= flingFactor * screenFactor);
        if (!this.isActive()) {
            this.mMap.getMapPosition(this.mStartPos);
            this.mPivot.x = pivotX;
            this.mPivot.y = pivotY;
            this.animFlingStart(2);
        } else {
            this.mState |= 2;
        }
    }

    private void animFlingStart(int state) {
        if (!this.isActive()) {
            this.mMap.events.fire(Map.ANIM_START, this.mMap.mMapPosition);
        }
        this.mCurPos.copy(this.mStartPos);
        this.mState |= 0x10 | state;
        this.mFrameStart = MapRenderer.frametime;
        this.mMap.render();
    }

    public void kineticScroll(float velocityX, float velocityY, int xmin, int xmax, int ymin, int ymax) {
        ThreadUtils.assertMainThread();
        if (velocityX * velocityX + velocityY * velocityY < 2048.0f) {
            return;
        }
        this.mMap.getMapPosition(this.mStartPos);
        float duration = 500.0f;
        float screenFactor = 160.0f / CanvasAdapter.dpi;
        velocityX *= screenFactor;
        velocityY *= screenFactor;
        velocityX = FastMath.clamp(velocityX, (float)xmin, (float)xmax);
        velocityY = FastMath.clamp(velocityY, (float)ymin, (float)ymax);
        if (Float.isNaN(velocityX) || Float.isNaN(velocityY)) {
            log.debug("fling NaN!");
            return;
        }
        double tileScale = this.mStartPos.scale * (double)Tile.SIZE;
        ViewController.applyRotation(-velocityX, -velocityY, this.mStartPos.bearing, this.mMovePoint);
        this.mDeltaPos.setX(this.mMovePoint.x / tileScale);
        this.mDeltaPos.setY(this.mMovePoint.y / tileScale);
        this.animStart(duration, 33, Easing.Type.SINE_OUT);
    }

    @Override
    void updateAnimation() {
        if (this.mState == 0) {
            return;
        }
        ViewController v = this.mMap.viewport();
        if (v.getMapPosition(this.mCurPos)) {
            log.debug("cancel anim - changed");
            this.cancel();
            return;
        }
        long currentFrametime = MapRenderer.frametime;
        if ((this.mState & 0x10) == 0) {
            long millisLeft = this.mAnimEnd - currentFrametime;
            float adv = FastMath.clamp(1.0f - (float)millisLeft / this.mDuration, 1.0E-6f, 1.0f);
            if (this.mEasingType != Easing.Type.LINEAR) {
                adv = Easing.ease(0L, (long)(adv * 9.223372E18f), 9.223372E18f, this.mEasingType);
                adv = FastMath.clamp(adv, 0.0f, 1.0f);
            }
            double scaleAdv = 1.0;
            if ((this.mState & 2) != 0) {
                scaleAdv = this.doScale(v, adv);
            }
            if ((this.mState & 0x20) != 0) {
                adv = (float)Math.sqrt(adv);
            }
            if ((this.mState & 1) != 0) {
                v.moveTo(this.mStartPos.x + this.mDeltaPos.x * ((double)adv / scaleAdv), this.mStartPos.y + this.mDeltaPos.y * ((double)adv / scaleAdv));
            }
            if ((this.mState & 4) != 0) {
                v.setRotation(this.mStartPos.bearing + this.mDeltaPos.bearing * adv);
            }
            if ((this.mState & 8) != 0) {
                v.setTilt(this.mStartPos.tilt + this.mDeltaPos.tilt * adv);
            }
            if (millisLeft <= 0L) {
                this.cancel();
            }
        } else {
            float velocity;
            float valueDelta;
            long deltaT = currentFrametime - this.mFrameStart;
            this.mFrameStart = currentFrametime;
            if ((this.mState & 2) != 0) {
                valueDelta = this.mFlingScaleForce.updateValueAndVelocity(deltaT) / 1000.0f;
                velocity = this.mFlingScaleForce.getVelocity();
                if (valueDelta != 0.0f) {
                    valueDelta = valueDelta > 0.0f ? valueDelta + 1.0f : -1.0f / (valueDelta - 1.0f);
                    v.scaleMap(valueDelta, (float)this.mPivot.x, (float)this.mPivot.y);
                }
                if (velocity == 0.0f) {
                    this.mState &= 0xFFFFFFFD;
                }
            }
            if ((this.mState & 1) != 0) {
                valueDelta = this.mFlingScrollForce.updateValueAndVelocity(deltaT);
                velocity = this.mFlingScrollForce.getVelocity();
                float valFactor = (float)Math.sqrt(valueDelta * valueDelta / this.mScrollDet2D);
                float dx = (float)this.mScrollRatio.x * valFactor;
                float dy = (float)this.mScrollRatio.y * valFactor;
                if (dx != 0.0f || dy != 0.0f) {
                    v.moveMap(dx, dy);
                }
                if (velocity == 0.0f) {
                    this.mState &= 0xFFFFFFFE;
                }
            }
            if ((this.mState & 4) != 0) {
                valueDelta = this.mFlingRotateForce.updateValueAndVelocity(deltaT);
                velocity = this.mFlingRotateForce.getVelocity();
                v.rotateMap(valueDelta, (float)this.mPivot.x, (float)this.mPivot.y);
                if (velocity == 0.0f) {
                    this.mState &= 0xFFFFFFFB;
                }
            }
            if ((this.mState & 7) == 0) {
                this.cancel();
            }
        }
        boolean changed = v.getMapPosition(this.mCurPos);
        if (changed) {
            this.mMap.updateMap(true);
        } else {
            this.mMap.postDelayed(this.updateTask, 10L);
        }
    }
}

