/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;

public class BitmapRenderer
extends BucketRenderer {
    private Bitmap mBitmap;
    private int mWidth;
    private int mHeight;
    private boolean mUpdateBitmap;
    private GLViewport.Position position = GLViewport.Position.TOP_LEFT;
    private float xOffset;
    private float yOffset;

    public synchronized void setBitmap(Bitmap bitmap, int width, int height) {
        this.mBitmap = bitmap;
        this.mWidth = width;
        this.mHeight = height;
        this.mInitialized = false;
    }

    public synchronized void setPosition(GLViewport.Position position) {
        this.position = position;
    }

    public synchronized void setOffset(float xOffset, float yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public synchronized void updateBitmap() {
        this.mUpdateBitmap = true;
    }

    @Override
    public synchronized void update(GLViewport v) {
        if (!this.mInitialized) {
            this.buckets.clear();
            BitmapBucket l = new BitmapBucket(true);
            l.setBitmap(this.mBitmap, this.mWidth, this.mHeight);
            this.buckets.set(l);
            this.mUpdateBitmap = true;
        }
        if (this.mUpdateBitmap) {
            this.mUpdateBitmap = false;
            this.compile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void compile() {
        if (this.mBitmap == null) {
            return;
        }
        Bitmap bitmap = this.mBitmap;
        synchronized (bitmap) {
            super.compile();
        }
    }

    @Override
    public synchronized void render(GLViewport v) {
        v.useScreenCoordinates(this.mWidth, this.mHeight, this.position, this.xOffset, this.yOffset, MapRenderer.COORD_SCALE);
        BitmapBucket.Renderer.draw(this.buckets.get(), v, 1.0f, 1.0f);
    }
}

