/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketRenderer
extends LayerRenderer {
    public static final Logger log = LoggerFactory.getLogger(BucketRenderer.class);
    protected MapPosition mMapPosition;
    protected boolean mFlipOnDateLine = true;
    public final RenderBuckets buckets = new RenderBuckets();
    protected boolean mInitialized;

    public BucketRenderer() {
        this.mMapPosition = new MapPosition();
    }

    @Override
    public void update(GLViewport v) {
        if (!this.mInitialized) {
            this.mMapPosition.copy(v.pos);
            this.mInitialized = true;
            this.compile();
        }
    }

    @Override
    public synchronized void render(GLViewport v) {
        MapPosition layerPos = this.mMapPosition;
        GLState.test(false, false);
        GLState.blend(true);
        float div = (float)(v.pos.scale / layerPos.scale);
        boolean project = true;
        this.setMatrix(v, project);
        RenderBucket b = this.buckets.get();
        block10: while (b != null) {
            this.buckets.bind();
            if (!project && b.type != 6) {
                project = true;
                this.setMatrix(v, project);
            }
            switch (b.type) {
                case 2: {
                    b = PolygonBucket.Renderer.draw(b, v, 1.0f, true);
                    continue block10;
                }
                case 0: {
                    b = LineBucket.Renderer.draw(b, v, div, this.buckets);
                    continue block10;
                }
                case 1: {
                    b = LineTexBucket.Renderer.draw(b, v, FastMath.pow(layerPos.zoomLevel - v.pos.zoomLevel) * (float)layerPos.getZoomScale(), this.buckets);
                    continue block10;
                }
                case 3: {
                    b = MeshBucket.Renderer.draw(b, v);
                    continue block10;
                }
                case 5: {
                    b = HairLineBucket.Renderer.draw(b, v);
                    continue block10;
                }
                case 7: {
                    b = BitmapBucket.Renderer.draw(b, v, 1.0f, 1.0f);
                    continue block10;
                }
                case 6: {
                    if (project) {
                        project = false;
                        this.setMatrix(v, project);
                    }
                    b = TextureBucket.Renderer.draw(b, v, div);
                    continue block10;
                }
                case 8: {
                    b = CircleBucket.Renderer.draw(b, v);
                    continue block10;
                }
            }
            log.error("invalid bucket {}", (Object)b.type);
            b = (RenderBucket)b.next;
        }
    }

    protected synchronized void compile() {
        boolean ok = this.buckets.compile(true);
        this.setReady(ok);
    }

    protected void setMatrix(GLViewport v, boolean project) {
        this.setMatrix(v, project, MapRenderer.COORD_SCALE);
    }

    protected void setMatrix(GLViewport v, boolean project, float coordScale) {
        this.setMatrix(v.mvp, v, project, coordScale);
    }

    protected void setMatrix(GLMatrix mvp, GLViewport v, boolean project, float coordScale) {
        double x;
        MapPosition oPos = this.mMapPosition;
        double tileScale = (double)Tile.SIZE * v.pos.scale;
        double y = oPos.y - v.pos.y;
        if (this.mFlipOnDateLine) {
            for (x = oPos.x - v.pos.x; x < 0.5; x += 1.0) {
            }
            while (x > 0.5) {
                x -= 1.0;
            }
        }
        mvp.setTransScale((float)(x * tileScale), (float)(y * tileScale), (float)(v.pos.scale / oPos.scale) / coordScale);
        mvp.multiplyLhs(project ? v.viewproj : v.view);
    }

    protected void setMatrix(GLViewport v) {
        this.setMatrix(v, true);
    }
}

