/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.oscim.backend.GLAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GLMatrix {
    static final Logger log = LoggerFactory.getLogger(GLMatrix.class);
    private static final boolean dbg = false;
    private final long pointer = GLMatrix.alloc();
    private final FloatBuffer buffer = GLMatrix.getBuffer(this.pointer).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final String INVALID_INPUT = "Bad Array!";

    public void set(float[] m) {
        if (m == null || m.length != 16) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.set(this.pointer, m);
    }

    public void get(float[] m) {
        if (m == null || m.length != 16) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.get(this.pointer, m);
    }

    public void copy(GLMatrix mat) {
        GLMatrix.copy(this.pointer, mat.pointer);
    }

    public void prj(float[] vec3) {
        if (vec3 == null || vec3.length < 3) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.prj(this.pointer, vec3);
    }

    public void prj3D(float[] vec3, int offset, int length) {
        if (vec3 == null || vec3.length / (offset + length) < 1) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.prj3D(this.pointer, vec3, offset, length);
    }

    public void prj2D(float[] vec2, int offset, int length) {
        if (vec2 == null || offset < 0 || (length + offset) * 2 > vec2.length) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.prj2D(this.pointer, vec2, offset, length);
    }

    public void prj2D(float[] src, int src_offset, float[] dst, int dst_offset, int length) {
        if (src == null || src_offset < 0 || length + src_offset * 2 > src.length) {
            throw new IllegalArgumentException(INVALID_INPUT);
        }
        GLMatrix.prj2D2(this.pointer, src, src_offset, dst, dst_offset, length);
    }

    public void multiplyRhs(GLMatrix rhs) {
        GLMatrix.smulrhs(this.pointer, rhs.pointer);
    }

    public void multiplyLhs(GLMatrix lhs) {
        GLMatrix.smullhs(this.pointer, lhs.pointer);
    }

    public void multiplyMM(GLMatrix lhs, GLMatrix rhs) {
        GLMatrix.smul(this.pointer, lhs.pointer, rhs.pointer);
    }

    public void transposeM(GLMatrix mat) {
        GLMatrix.strans(this.pointer, mat.pointer);
    }

    public void setRotation(float a, float x, float y, float z) {
        GLMatrix.setRotation(this.pointer, a, x, y, z);
    }

    public void setTranslation(float x, float y, float z) {
        GLMatrix.setTranslation(this.pointer, x, y, z);
    }

    public void setScale(float x, float y, float z) {
        GLMatrix.setScale(this.pointer, x, y, z);
    }

    public void setTransScale(float tx, float ty, float scale) {
        GLMatrix.setTransScale(this.pointer, tx, ty, scale);
    }

    public void setAsUniform(int location) {
        GLAdapter.gl.uniformMatrix4fv(location, 1, false, this.buffer);
    }

    public void setValue(int pos, float value) {
        GLMatrix.setValueAt(this.pointer, pos, value);
    }

    public void addDepthOffset(int delta) {
        GLMatrix.addDepthOffset(this.pointer, delta);
    }

    public void setIdentity() {
        GLMatrix.identity(this.pointer);
    }

    public void finalize() {
        if (this.pointer != 0L) {
            GLMatrix.delete(this.pointer);
        }
    }

    private static native long alloc();

    private static native void delete(long var0);

    private static native void set(long var0, float[] var2);

    private static native void copy(long var0, long var2);

    private static native void identity(long var0);

    private static native void get(long var0, float[] var2);

    private static native void mul(long var0, long var2);

    private static native void smul(long var0, long var2, long var4);

    private static native void smulrhs(long var0, long var2);

    private static native void smullhs(long var0, long var2);

    private static native void strans(long var0, long var2);

    private static native void prj(long var0, float[] var2);

    private static native void prj3D(long var0, float[] var2, int var3, int var4);

    private static native void prj2D(long var0, float[] var2, int var3, int var4);

    private static native void prj2D2(long var0, float[] var2, int var3, float[] var4, int var5, int var6);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setScale(long var0, float var2, float var3, float var4);

    private static native void setTranslation(long var0, float var2, float var3, float var4);

    private static native void setTransScale(long var0, float var2, float var3, float var4);

    private static native void setValueAt(long var0, int var2, float var3);

    private static native void addDepthOffset(long var0, int var2);

    private static native ByteBuffer getBuffer(long var0);

    public static void frustumM(float[] m, int offset, float left, float right, float bottom, float top, float near, float far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (top == bottom) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        if (near <= 0.0f) {
            throw new IllegalArgumentException("near <= 0.0f");
        }
        if (far <= 0.0f) {
            throw new IllegalArgumentException("far <= 0.0f");
        }
        float r_width = 1.0f / (right - left);
        float r_height = 1.0f / (top - bottom);
        float r_depth = 1.0f / (near - far);
        float x = 2.0f * (near * r_width);
        float y = 2.0f * (near * r_height);
        float A = (right + left) * r_width;
        float B = (top + bottom) * r_height;
        float C = (far + near) * r_depth;
        float D = 2.0f * (far * near * r_depth);
        m[offset + 0] = x;
        m[offset + 5] = y;
        m[offset + 8] = A;
        m[offset + 9] = B;
        m[offset + 10] = C;
        m[offset + 14] = D;
        m[offset + 11] = -1.0f;
        m[offset + 1] = 0.0f;
        m[offset + 2] = 0.0f;
        m[offset + 3] = 0.0f;
        m[offset + 4] = 0.0f;
        m[offset + 6] = 0.0f;
        m[offset + 7] = 0.0f;
        m[offset + 12] = 0.0f;
        m[offset + 13] = 0.0f;
        m[offset + 15] = 0.0f;
    }

    public static boolean invertM(float[] mInv, int mInvOffset, float[] m, int mOffset) {
        float src0 = m[mOffset + 0];
        float src4 = m[mOffset + 1];
        float src8 = m[mOffset + 2];
        float src12 = m[mOffset + 3];
        float src1 = m[mOffset + 4];
        float src5 = m[mOffset + 5];
        float src9 = m[mOffset + 6];
        float src13 = m[mOffset + 7];
        float src2 = m[mOffset + 8];
        float src6 = m[mOffset + 9];
        float src10 = m[mOffset + 10];
        float src14 = m[mOffset + 11];
        float src3 = m[mOffset + 12];
        float src7 = m[mOffset + 13];
        float src11 = m[mOffset + 14];
        float src15 = m[mOffset + 15];
        float atmp0 = src10 * src15;
        float atmp1 = src11 * src14;
        float atmp2 = src9 * src15;
        float atmp3 = src11 * src13;
        float atmp4 = src9 * src14;
        float atmp5 = src10 * src13;
        float atmp6 = src8 * src15;
        float atmp7 = src11 * src12;
        float atmp8 = src8 * src14;
        float atmp9 = src10 * src12;
        float atmp10 = src8 * src13;
        float atmp11 = src9 * src12;
        float dst0 = atmp0 * src5 + atmp3 * src6 + atmp4 * src7 - (atmp1 * src5 + atmp2 * src6 + atmp5 * src7);
        float dst1 = atmp1 * src4 + atmp6 * src6 + atmp9 * src7 - (atmp0 * src4 + atmp7 * src6 + atmp8 * src7);
        float dst2 = atmp2 * src4 + atmp7 * src5 + atmp10 * src7 - (atmp3 * src4 + atmp6 * src5 + atmp11 * src7);
        float dst3 = atmp5 * src4 + atmp8 * src5 + atmp11 * src6 - (atmp4 * src4 + atmp9 * src5 + atmp10 * src6);
        float dst4 = atmp1 * src1 + atmp2 * src2 + atmp5 * src3 - (atmp0 * src1 + atmp3 * src2 + atmp4 * src3);
        float dst5 = atmp0 * src0 + atmp7 * src2 + atmp8 * src3 - (atmp1 * src0 + atmp6 * src2 + atmp9 * src3);
        float dst6 = atmp3 * src0 + atmp6 * src1 + atmp11 * src3 - (atmp2 * src0 + atmp7 * src1 + atmp10 * src3);
        float dst7 = atmp4 * src0 + atmp9 * src1 + atmp10 * src2 - (atmp5 * src0 + atmp8 * src1 + atmp11 * src2);
        float btmp0 = src2 * src7;
        float btmp1 = src3 * src6;
        float btmp2 = src1 * src7;
        float btmp3 = src3 * src5;
        float btmp4 = src1 * src6;
        float btmp5 = src2 * src5;
        float btmp6 = src0 * src7;
        float btmp7 = src3 * src4;
        float btmp8 = src0 * src6;
        float btmp9 = src2 * src4;
        float btmp10 = src0 * src5;
        float btmp11 = src1 * src4;
        float dst8 = btmp0 * src13 + btmp3 * src14 + btmp4 * src15 - (btmp1 * src13 + btmp2 * src14 + btmp5 * src15);
        float dst9 = btmp1 * src12 + btmp6 * src14 + btmp9 * src15 - (btmp0 * src12 + btmp7 * src14 + btmp8 * src15);
        float dst10 = btmp2 * src12 + btmp7 * src13 + btmp10 * src15 - (btmp3 * src12 + btmp6 * src13 + btmp11 * src15);
        float dst11 = btmp5 * src12 + btmp8 * src13 + btmp11 * src14 - (btmp4 * src12 + btmp9 * src13 + btmp10 * src14);
        float dst12 = btmp2 * src10 + btmp5 * src11 + btmp1 * src9 - (btmp4 * src11 + btmp0 * src9 + btmp3 * src10);
        float dst13 = btmp8 * src11 + btmp0 * src8 + btmp7 * src10 - (btmp6 * src10 + btmp9 * src11 + btmp1 * src8);
        float dst14 = btmp6 * src9 + btmp11 * src11 + btmp3 * src8 - (btmp10 * src11 + btmp2 * src8 + btmp7 * src9);
        float dst15 = btmp10 * src10 + btmp4 * src8 + btmp9 * src9 - (btmp8 * src9 + btmp11 * src10 + btmp5 * src8);
        float det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
        if (det == 0.0f) {
            return false;
        }
        float invdet = 1.0f / det;
        mInv[mInvOffset] = dst0 * invdet;
        mInv[1 + mInvOffset] = dst1 * invdet;
        mInv[2 + mInvOffset] = dst2 * invdet;
        mInv[3 + mInvOffset] = dst3 * invdet;
        mInv[4 + mInvOffset] = dst4 * invdet;
        mInv[5 + mInvOffset] = dst5 * invdet;
        mInv[6 + mInvOffset] = dst6 * invdet;
        mInv[7 + mInvOffset] = dst7 * invdet;
        mInv[8 + mInvOffset] = dst8 * invdet;
        mInv[9 + mInvOffset] = dst9 * invdet;
        mInv[10 + mInvOffset] = dst10 * invdet;
        mInv[11 + mInvOffset] = dst11 * invdet;
        mInv[12 + mInvOffset] = dst12 * invdet;
        mInv[13 + mInvOffset] = dst13 * invdet;
        mInv[14 + mInvOffset] = dst14 * invdet;
        mInv[15 + mInvOffset] = dst15 * invdet;
        return true;
    }

    public static void lookAt(float[] m, int offset, float eyex, float eyey, float eyez, float centerx, float centery, float centerz, float upx, float upy, float upz) {
        float z0 = eyex - centerx;
        float z1 = eyey - centery;
        float z2 = eyez - centerz;
        double len = 1.0 / Math.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        float x0 = upy * (z2 = (float)((double)z2 * len)) - upz * (z1 = (float)((double)z1 * len));
        float x1 = upz * (z0 = (float)((double)z0 * len)) - upx * z2;
        float x2 = upx * z1 - upy * z0;
        if ((len = Math.sqrt(x0 * x0 + x1 * x1 + x2 * x2)) == 0.0) {
            x2 = 0.0f;
            x1 = 0.0f;
            x0 = 0.0f;
        } else {
            len = 1.0 / len;
            x0 = (float)((double)x0 * len);
            x1 = (float)((double)x1 * len);
            x2 = (float)((double)x2 * len);
        }
        float y0 = z1 * x2 - z2 * x1;
        float y1 = z2 * x0 - z0 * x2;
        float y2 = z0 * x1 - z1 * x0;
        len = Math.sqrt(y0 * y0 + y1 * y1 + y2 * y2);
        if (len == 0.0) {
            y2 = 0.0f;
            y1 = 0.0f;
            y0 = 0.0f;
        } else {
            len = 1.0 / len;
            y0 = (float)((double)y0 * len);
            y1 = (float)((double)y1 * len);
            y2 = (float)((double)y2 * len);
        }
        m[offset + 0] = x0;
        m[offset + 1] = y0;
        m[offset + 2] = z0;
        m[offset + 3] = 0.0f;
        m[offset + 4] = x1;
        m[offset + 5] = y1;
        m[offset + 6] = z1;
        m[offset + 7] = 0.0f;
        m[offset + 8] = x2;
        m[offset + 9] = y2;
        m[offset + 10] = z2;
        m[offset + 11] = 0.0f;
        m[offset + 12] = -(x0 * eyex + x1 * eyey + x2 * eyez);
        m[offset + 13] = -(y0 * eyex + y1 * eyey + y2 * eyez);
        m[offset + 14] = -(z0 * eyex + z1 * eyey + z2 * eyez);
        m[offset + 15] = 1.0f;
    }

    public static void orthoM(float[] m, int offset, float left, float right, float bottom, float top, float near, float far) {
        float r_width = 1.0f / (left - right);
        float r_height = 1.0f / (bottom - top);
        float r_depth = 1.0f / (near - far);
        m[offset + 0] = -2.0f * r_width;
        m[offset + 5] = -2.0f * r_height;
        m[offset + 10] = 2.0f * r_depth;
        m[offset + 12] = (left + right) * r_width;
        m[offset + 13] = (top + bottom) * r_height;
        m[offset + 14] = (far + near) * r_depth;
        m[offset + 1] = 0.0f;
        m[offset + 2] = 0.0f;
        m[offset + 3] = 0.0f;
        m[offset + 4] = 0.0f;
        m[offset + 6] = 0.0f;
        m[offset + 7] = 0.0f;
        m[offset + 8] = 0.0f;
        m[offset + 9] = 0.0f;
        m[offset + 11] = 0.0f;
        m[offset + 15] = 1.0f;
    }
}

