/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.util.Locale;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.core.PointF;
import org.oscim.core.Tile;
import org.oscim.map.Map;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.SymbolBucket;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.math.Interpolation;

public class LocationTextureRenderer
extends BucketRenderer {
    private static final PointF CENTER_OFFSET = new PointF(0.5f, 0.5f);
    private static final long ANIM_RATE = 50L;
    private static final long INTERVAL = 2000L;
    private static final float CIRCLE_SIZE = 30.0f;
    private static final int SHOW_ACCURACY_ZOOM = 13;
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    private static final String V_SHADER = "precision highp float;uniform mat4 u_mvp;uniform float u_phase;uniform float u_scale;attribute vec2 a_pos;varying vec2 v_tex;void main() {  gl_Position = u_mvp * vec4(a_pos * u_scale * u_phase, 0.0, 1.0);  v_tex = a_pos;}".replace("precision highp float;", IS_MAC ? "" : "precision highp float;");
    private static final String F_SHADER = "precision highp float;varying vec2 v_tex;uniform float u_scale;uniform float u_phase;uniform vec4 u_fill;void main() {  float len = 1.0 - length(v_tex);  float a = smoothstep(0.0, 2.0 / u_scale, len);  float b = 0.8 * smoothstep(3.0 / u_scale, 4.0 / u_scale, len);  float c = 0.5 * (1.0 - smoothstep(14.0 / u_scale, 16.0 / u_scale, 1.0 - len));  vec2 dir = normalize(v_tex);  a = (a - (b + c)) + c;  gl_FragColor = u_fill * a;}".replace("precision highp float;", IS_MAC ? "" : "precision highp float;");
    private final SymbolBucket symbolBucket;
    private final float[] box = new float[8];
    private final Point mapPoint = new Point();
    private final Map map;
    private boolean initialized;
    private boolean locationIsVisible;
    private int shaderProgramNumber;
    private int hVertexPosition;
    private int hMatrixPosition;
    private int hScale;
    private int hPhase;
    private int uFill;
    private double radius;
    private final Point indicatorPosition = new Point();
    private final Point screenPoint = new Point();
    private final Box boundingBox = new Box();
    private boolean runAnim;
    private boolean animate = true;
    private long animStart;
    private boolean update;
    private float bearing;
    private TextureRegion textureRegion;
    private int accuracyColor = -16776961;
    private int viewShedColor = -65536;
    private boolean billboard = false;

    public LocationTextureRenderer(Map map) {
        this.map = map;
        this.symbolBucket = new SymbolBucket();
    }

    public void setAccuracyColor(int color) {
        this.accuracyColor = color;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public void setIndicatorColor(int color) {
        this.viewShedColor = color;
    }

    public void setLocation(double x, double y, float bearing, double radius) {
        this.update = true;
        this.mapPoint.x = x;
        this.mapPoint.y = y;
        this.bearing = bearing;
        this.radius = radius;
    }

    public void setTextureRegion(TextureRegion textureRegion) {
        this.textureRegion = textureRegion;
    }

    public void setTextureRegion(TextureRegion textureRegion, boolean billboard) {
        this.textureRegion = textureRegion;
        this.billboard = billboard;
    }

    public void animate(boolean enable) {
        if (this.runAnim == enable) {
            return;
        }
        this.runAnim = enable;
        if (!enable) {
            return;
        }
        if (!this.animate) {
            return;
        }
        Runnable action = new Runnable(){
            private long lastRun;

            @Override
            public void run() {
                if (!LocationTextureRenderer.this.runAnim) {
                    return;
                }
                if (!LocationTextureRenderer.this.animate) {
                    return;
                }
                long diff = System.currentTimeMillis() - this.lastRun;
                LocationTextureRenderer.this.map.postDelayed(this, Math.min(50L, diff));
                LocationTextureRenderer.this.map.render();
                this.lastRun = System.currentTimeMillis();
            }
        };
        this.animStart = System.currentTimeMillis();
        this.map.postDelayed(action, 50L);
    }

    private float animPhase() {
        return (float)((MapRenderer.frametime - this.animStart) % 2000L) / 2000.0f;
    }

    @Override
    public synchronized void update(GLViewport v) {
        if (!v.changed() && !this.update) {
            return;
        }
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        this.setReady(true);
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        v.getBBox(this.boundingBox, 0);
        double x = this.mapPoint.x;
        double y = this.mapPoint.y;
        if (!this.boundingBox.contains(this.mapPoint)) {
            x = FastMath.clamp(x, this.boundingBox.xmin, this.boundingBox.xmax);
            y = FastMath.clamp(y, this.boundingBox.ymin, this.boundingBox.ymax);
        }
        v.toScreenPoint(x, y, this.screenPoint);
        x = this.screenPoint.x + (double)(width / 2);
        y = this.screenPoint.y + (double)(height / 2);
        int visible = 0;
        if (x > (double)(width - 5)) {
            x = width;
        } else if (x < 5.0) {
            x = 0.0;
        } else {
            ++visible;
        }
        if (y > (double)(height - 5)) {
            y = height;
        } else if (y < 5.0) {
            y = 0.0;
        } else {
            ++visible;
        }
        boolean bl = this.locationIsVisible = visible == 2;
        if (this.locationIsVisible) {
            this.animate(false);
        } else {
            this.animate(true);
        }
        v.fromScreenPoint(x, y, this.indicatorPosition);
        this.mMapPosition.copy(v.pos);
        double mx = v.pos.x;
        double my = v.pos.y;
        double scale = (double)Tile.SIZE * v.pos.scale;
        this.map.viewport().getMapExtents(this.box, 100.0f);
        long flip = (long)((double)Tile.SIZE * v.pos.scale) >> 1;
        float symbolX = (float)((this.mapPoint.x - mx) * scale);
        float symbolY = (float)((this.mapPoint.y - my) * scale);
        if (symbolX > (float)flip) {
            symbolX -= (float)(flip << 1);
        } else if (symbolX < (float)(-flip)) {
            symbolX += (float)(flip << 1);
        }
        this.buckets.clear();
        if (!GeometryUtils.pointInPoly(symbolX, symbolY, this.box, 8, 0)) {
            return;
        }
        this.mMapPosition.bearing = -this.mMapPosition.bearing;
        if (this.textureRegion == null) {
            return;
        }
        SymbolItem symbolItem = SymbolItem.pool.get();
        symbolItem.set(symbolX, symbolY, this.textureRegion, this.bearing, this.billboard);
        symbolItem.offset = CENTER_OFFSET;
        this.symbolBucket.pushSymbol(symbolItem);
        this.buckets.set(this.symbolBucket);
        this.buckets.prepare();
        this.buckets.compile(true);
        this.compile();
        this.update = false;
    }

    @Override
    public void render(GLViewport v) {
        this.renderAccuracyCircle(v);
        super.render(v);
    }

    private void init() {
        int shader = GLShader.createProgram(V_SHADER, F_SHADER);
        if (shader == 0) {
            return;
        }
        this.shaderProgramNumber = shader;
        this.hVertexPosition = GLAdapter.gl.getAttribLocation(shader, "a_pos");
        this.hMatrixPosition = GLAdapter.gl.getUniformLocation(shader, "u_mvp");
        this.hPhase = GLAdapter.gl.getUniformLocation(shader, "u_phase");
        this.hScale = GLAdapter.gl.getUniformLocation(shader, "u_scale");
        this.uFill = GLAdapter.gl.getUniformLocation(shader, "u_fill");
    }

    private void renderAccuracyCircle(GLViewport v) {
        GLState.useProgram(this.shaderProgramNumber);
        GLState.blend(true);
        GLState.test(false, false);
        GLState.enableVertexArrays(this.hVertexPosition, -1);
        MapRenderer.bindQuadVertexVBO(this.hVertexPosition);
        float radius = 10.0f;
        boolean viewShed = false;
        if (!this.locationIsVisible) {
            radius = 30.0f * CanvasAdapter.getScale();
        } else {
            if (v.pos.zoomLevel >= 13) {
                radius = (float)(this.radius * v.pos.scale);
            }
            radius = Math.max(2.0f, radius);
            viewShed = true;
        }
        GLAdapter.gl.uniform1f(this.hScale, radius);
        double x = this.indicatorPosition.x - v.pos.x;
        double y = this.indicatorPosition.y - v.pos.y;
        double tileScale = (double)Tile.SIZE * v.pos.scale;
        v.mvp.setTransScale((float)(x * tileScale), (float)(y * tileScale), 1.0f);
        v.mvp.multiplyMM(v.viewproj, v.mvp);
        v.mvp.setAsUniform(this.hMatrixPosition);
        if (!viewShed && this.animate) {
            float phase = Math.abs(this.animPhase() - 0.5f) * 2.0f;
            phase = Interpolation.swing.apply(phase);
            GLAdapter.gl.uniform1f(this.hPhase, 0.8f + phase * 0.2f);
        } else {
            GLAdapter.gl.uniform1f(this.hPhase, 1.0f);
        }
        if (viewShed && this.locationIsVisible) {
            GLUtils.setColor(this.uFill, this.accuracyColor, 1.0f);
        } else {
            GLUtils.setColor(this.uFill, this.viewShedColor, 1.0f);
        }
        GLAdapter.gl.drawArrays(5, 0, 4);
        GLAdapter.gl.flush();
    }
}

