/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffscreenRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(OffscreenRenderer.class);
    int fb;
    int renderTex;
    int renderDepth;
    int texW = -1;
    int texH = -1;
    boolean initialized;
    private float[] mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private boolean useDepthTexture = false;
    private Shader mShader;
    public final Mode mode;
    LayerRenderer mRenderer;

    public OffscreenRenderer(Mode mode, LayerRenderer renderer) {
        this.mode = mode;
        if (mode == Mode.SSAO || mode == Mode.SSAO_FXAA) {
            this.useDepthTexture = true;
        }
        this.setRenderer(renderer);
    }

    protected boolean setupFBO(GLViewport viewport) {
        this.texW = (int)viewport.getWidth();
        this.texH = (int)viewport.getHeight();
        this.fb = GLUtils.glGenFrameBuffers(1)[0];
        this.renderTex = GLUtils.glGenTextures(1)[0];
        GLUtils.checkGlError(this.getClass().getName() + ": 0");
        GLAdapter.gl.bindFramebuffer(36160, this.fb);
        GLAdapter.gl.bindTexture(3553, this.renderTex);
        GLUtils.setTextureParameter(9729, 9729, 33071, 33071);
        GLAdapter.gl.texImage2D(3553, 0, 6408, this.texW, this.texH, 0, 6408, 5121, null);
        GLAdapter.gl.framebufferTexture2D(36160, 36064, 3553, this.renderTex, 0);
        GLUtils.checkGlError(this.getClass().getName() + ": 1");
        if (this.useDepthTexture) {
            this.renderDepth = GLUtils.glGenTextures(1)[0];
            GLAdapter.gl.bindTexture(3553, this.renderDepth);
            GLUtils.setTextureParameter(9728, 9728, 33071, 33071);
            GLAdapter.gl.texImage2D(3553, 0, 6402, this.texW, this.texH, 0, 6402, 5123, null);
            GLAdapter.gl.framebufferTexture2D(36160, 36096, 3553, this.renderDepth, 0);
        } else {
            int depthRenderbuffer = GLUtils.glGenRenderBuffers(1)[0];
            GLAdapter.gl.bindRenderbuffer(36161, depthRenderbuffer);
            GLAdapter.gl.renderbufferStorage(36161, 33189, this.texW, this.texH);
            GLAdapter.gl.framebufferRenderbuffer(36160, 36096, 36161, depthRenderbuffer);
        }
        GLUtils.checkGlError(this.getClass().getName() + ": 2");
        int status = GLUtils.checkFramebufferStatus(this.getClass().getName());
        GLAdapter.gl.bindFramebuffer(36160, 0);
        GLAdapter.gl.bindTexture(3553, 0);
        return status == 36053;
    }

    public void enable(boolean on) {
        if (on) {
            GLState.bindFramebuffer(this.fb);
        } else {
            GLState.bindFramebuffer(0);
        }
    }

    public void begin() {
        GLState.bindFramebuffer(this.fb);
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.clear(256);
    }

    public void setRenderer(LayerRenderer renderer) {
        this.mRenderer = renderer;
    }

    @Override
    public boolean setup() {
        this.mRenderer.setup();
        return super.setup();
    }

    @Override
    public void update(GLViewport viewport) {
        if ((float)this.texW != viewport.getWidth() || (float)this.texH != viewport.getHeight()) {
            this.setupFBO(viewport);
            switch (this.mode) {
                case FXAA: {
                    this.mShader = new Shader("post_fxaa");
                    break;
                }
                case SSAO: {
                    this.mShader = new Shader("post_ssao");
                    break;
                }
                case SSAO_FXAA: {
                    this.mShader = new Shader("post_combined");
                    break;
                }
                case BYPASS: {
                    this.mShader = new Shader("post_bypass");
                }
            }
        }
        this.mRenderer.update(viewport);
        this.setReady(this.mRenderer.isReady());
    }

    @Override
    public void render(GLViewport viewport) {
        GLState.bindFramebuffer(this.fb);
        GLState.viewport(this.texW, this.texH);
        GLAdapter.gl.depthMask(true);
        GLState.setClearColor(this.mClearColor);
        GLAdapter.gl.clear(16640);
        this.mRenderer.render(viewport);
        GLState.bindFramebuffer(0);
        this.mShader.useProgram();
        if (this.useDepthTexture) {
            GLAdapter.gl.activeTexture(33985);
            GLState.bindTex2D(this.renderDepth);
            GLAdapter.gl.uniform1i(this.mShader.uTexDepth, 1);
            GLAdapter.gl.activeTexture(33984);
        }
        GLState.bindTex2D(this.renderTex);
        GLAdapter.gl.uniform1i(this.mShader.uTexColor, 0);
        MapRenderer.bindQuadVertexVBO(this.mShader.aPos);
        GLAdapter.gl.uniform2f(this.mShader.uPixel, (float)(1.0 / (double)this.texW * 0.5), (float)(1.0 / (double)this.texH * 0.5));
        GLState.test(false, false);
        GLState.blend(true);
        GLAdapter.gl.drawArrays(5, 0, 4);
        GLUtils.checkGlError(this.getClass().getName() + ": render() end");
    }

    static class Shader
    extends GLShader {
        int aPos;
        int uTexDepth;
        int uTexColor;
        int uPixel;

        Shader(String shaderFile) {
            if (!this.create(shaderFile)) {
                return;
            }
            this.aPos = this.getAttrib("a_pos");
            this.uTexColor = this.getUniform("u_texColor");
            this.uTexDepth = this.getUniform("u_tex");
            this.uPixel = this.getUniform("u_pixel");
        }
    }

    public static enum Mode {
        FXAA,
        SSAO,
        SSAO_FXAA,
        BYPASS;

    }
}

