/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.theme.styles.CircleStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleBucket
extends RenderBucket {
    private static final Logger log = LoggerFactory.getLogger(CircleBucket.class);
    public CircleStyle circle;

    public CircleBucket(int level) {
        super((byte)8, true, GLAdapter.CIRCLE_QUADS);
        this.level = level;
    }

    public void addCircle(GeometryBuffer geom) {
        if (!geom.isPoint()) {
            log.error("Circle style applied to non-point geometry");
            return;
        }
        float x = geom.getPointX(0);
        float y = geom.getPointY(0);
        if (GLAdapter.CIRCLE_QUADS) {
            this.vertexItems.add((short)((x + this.circle.radius) * MapRenderer.COORD_SCALE), (short)((y - this.circle.radius) * MapRenderer.COORD_SCALE));
            int ne = this.numVertices++;
            this.vertexItems.add((short)((x - this.circle.radius) * MapRenderer.COORD_SCALE), (short)((y - this.circle.radius) * MapRenderer.COORD_SCALE));
            int nw = this.numVertices++;
            this.vertexItems.add((short)((x - this.circle.radius) * MapRenderer.COORD_SCALE), (short)((y + this.circle.radius) * MapRenderer.COORD_SCALE));
            int sw = this.numVertices++;
            this.vertexItems.add((short)((x + this.circle.radius) * MapRenderer.COORD_SCALE), (short)((y + this.circle.radius) * MapRenderer.COORD_SCALE));
            int se = this.numVertices++;
            this.indiceItems.add((short)ne);
            ++this.numIndices;
            this.indiceItems.add((short)nw);
            ++this.numIndices;
            this.indiceItems.add((short)sw);
            ++this.numIndices;
            this.indiceItems.add((short)sw);
            ++this.numIndices;
            this.indiceItems.add((short)se);
            ++this.numIndices;
            this.indiceItems.add((short)ne);
            ++this.numIndices;
        } else {
            this.vertexItems.add((short)(x * MapRenderer.COORD_SCALE), (short)(y * MapRenderer.COORD_SCALE));
            this.indiceItems.add((short)this.numVertices++);
            ++this.numIndices;
        }
    }

    public static class Renderer {
        static Shader shader;

        static boolean init() {
            shader = new Shader(GLAdapter.CIRCLE_QUADS ? "circle_quad" : "circle_point");
            return true;
        }

        public static RenderBucket draw(RenderBucket b, GLViewport v) {
            GLState.blend(true);
            Shader s = shader;
            s.set(v);
            while (b != null && b.type == 8) {
                CircleBucket cb = (CircleBucket)b;
                CircleStyle circle = cb.circle.current();
                GLUtils.setColor(s.uFill, circle.fillColor, 1.0f);
                GLAdapter.gl.uniform1f(s.uRadius, circle.radius);
                GLUtils.setColor(s.uStroke, circle.strokeColor, 1.0f);
                GLAdapter.gl.uniform1f(s.uWidth, circle.strokeWidth);
                GLAdapter.gl.vertexAttribPointer(s.aPos, 2, 5122, false, 0, cb.vertexOffset);
                if (GLAdapter.CIRCLE_QUADS) {
                    GLAdapter.gl.drawElements(4, cb.numIndices, 5123, cb.indiceOffset);
                } else {
                    GLAdapter.gl.drawElements(0, cb.numIndices, 5123, cb.indiceOffset);
                }
                b = (RenderBucket)b.next;
            }
            return b;
        }

        public static class Shader
        extends GLShader {
            int uMVP;
            int uFill;
            int uRadius;
            int uStroke;
            int uWidth;
            int aPos;

            Shader(String shaderFile) {
                if (!(GLAdapter.CIRCLE_QUADS || GLAdapter.ANDROID_QUIRKS || GLAdapter.GDX_WEBGL_QUIRKS)) {
                    GLAdapter.gl.enable(34370);
                }
                String version = null;
                if (!GLAdapter.CIRCLE_QUADS && GLAdapter.GDX_DESKTOP_QUIRKS) {
                    version = "120";
                }
                if (!this.createVersioned(shaderFile, version)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uFill = this.getUniform("u_fill");
                this.uRadius = this.getUniform("u_radius");
                this.uStroke = this.getUniform("u_stroke");
                this.uWidth = this.getUniform("u_width");
                this.aPos = this.getAttrib("a_pos");
            }

            public void set(GLViewport v) {
                this.useProgram();
                GLState.enableVertexArrays(this.aPos, -1);
                v.mvp.setAsUniform(this.uMVP);
            }
        }
    }
}

