/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.ExtrusionUtils;
import org.oscim.utils.FastMath;
import org.oscim.utils.KeyMap;
import org.oscim.utils.Tessellator;
import org.oscim.utils.geom.LineClipper;
import org.oscim.utils.pool.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrusionBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(ExtrusionBucket.class);
    private VertexData[] mIndices;
    private LineClipper mClipper;
    private final float[] colors;
    private final int color;
    public int[] idx = new int[]{0, 0, 0, 0, 0};
    public int[] off = new int[]{0, 0, 0, 0, 0};
    private static final int IND_ROOF = 2;
    private static final int IND_OUTLINE = 3;
    private static final int IND_MESH = 4;
    private final float mGroundResolution;
    private KeyMap<Vertex> mVertexMap;
    private static final int NORMAL_DIR_MASK = -2;
    static Pool<Vertex> vertexPool = new Pool<Vertex>(){

        @Override
        protected Vertex createItem() {
            return new Vertex();
        }
    };
    static Pool<KeyMap<Vertex>> vertexMapPool = new Pool<KeyMap<Vertex>>(){

        @Override
        protected KeyMap<Vertex> createItem() {
            return new KeyMap<Vertex>(2048);
        }
    };

    public ExtrusionBucket(int level, float groundResolution, float[] colors) {
        super((byte)4, true, false);
        this.level = level;
        this.colors = colors;
        this.color = 0;
        this.mGroundResolution = groundResolution;
        this.mIndices = new VertexData[5];
        for (int i = 0; i <= 4; ++i) {
            this.mIndices[i] = new VertexData();
        }
        this.mClipper = new LineClipper(0.0f, 0.0f, Tile.SIZE, Tile.SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtrusionBucket(int level, float groundResolution, int color) {
        super((byte)4, true, false);
        this.level = level;
        this.color = color;
        float a = Color.aToFloat(color);
        this.colors = new float[4];
        this.colors[0] = a * Color.rToFloat(color);
        this.colors[1] = a * Color.gToFloat(color);
        this.colors[2] = a * Color.bToFloat(color);
        this.colors[3] = a;
        this.mGroundResolution = groundResolution;
        this.mIndices = new VertexData[5];
        this.mIndices[4] = new VertexData();
        Pool<Vertex> pool = vertexPool;
        synchronized (pool) {
            this.mVertexMap = vertexMapPool.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMesh(GeometryBuffer element) {
        if (!element.isTris()) {
            return;
        }
        int[] index = element.index;
        float[] points = element.points;
        int vertexCnt = this.numVertices;
        Pool<Vertex> pool = vertexPool;
        synchronized (pool) {
            Vertex key = vertexPool.get();
            double scale = MapRenderer.COORD_SCALE * (float)Tile.SIZE / 4096.0f;
            int k = 0;
            int n = index.length;
            while (k < n && index[k] >= 0 && vertexCnt < 65536) {
                int vtx1 = index[k++] * 3;
                int vtx2 = index[k++] * 3;
                int vtx3 = index[k++] * 3;
                float vx1 = points[vtx1 + 0];
                float vy1 = points[vtx1 + 1];
                float vz1 = points[vtx1 + 2];
                float vx2 = points[vtx2 + 0];
                float vy2 = points[vtx2 + 1];
                float vz2 = points[vtx2 + 2];
                float vx3 = points[vtx3 + 0];
                float vy3 = points[vtx3 + 1];
                float vz3 = points[vtx3 + 2];
                float ax = vx2 - vx1;
                float ay = vy2 - vy1;
                float az = vz2 - vz1;
                float bx = vx3 - vx1;
                float by = vy3 - vy1;
                float bz = vz3 - vz1;
                float cx = ay * bz - az * by;
                float cy = az * bx - ax * bz;
                float cz = ax * by - ay * bx;
                double len = Math.sqrt(cx * cx + cy * cy + cz * cz);
                int mx = FastMath.clamp(127 + (int)((double)cx / len * 128.0), 0, 255);
                int my = FastMath.clamp(127 + (int)((double)cy / len * 128.0), 0, 255);
                short normal = (short)(my << 8 | mx & 0xFFFFFFFE | (cz > 0.0f ? 1 : 0));
                if (key == null) {
                    key = vertexPool.get();
                }
                key.set((short)((double)vx1 * scale), (short)((double)vy1 * scale), (short)((double)vz1 * scale), normal);
                Vertex vertex = this.mVertexMap.put(key, false);
                if (vertex == null) {
                    key.id = vertexCnt++;
                    this.addMeshIndex(key, true);
                    key = vertexPool.get();
                } else {
                    this.addMeshIndex(vertex, false);
                }
                key.set((short)((double)vx2 * scale), (short)((double)vy2 * scale), (short)((double)vz2 * scale), normal);
                vertex = this.mVertexMap.put(key, false);
                if (vertex == null) {
                    key.id = vertexCnt++;
                    this.addMeshIndex(key, true);
                    key = vertexPool.get();
                } else {
                    this.addMeshIndex(vertex, false);
                }
                key.set((short)((double)vx3 * scale), (short)((double)vy3 * scale), (short)((double)vz3 * scale), normal);
                vertex = this.mVertexMap.put(key, false);
                if (vertex == null) {
                    key.id = vertexCnt++;
                    this.addMeshIndex(key, true);
                    key = vertexPool.get();
                    continue;
                }
                this.addMeshIndex(vertex, false);
            }
            vertexPool.release(key);
        }
        this.numVertices = vertexCnt;
    }

    private void addMeshIndex(Vertex v, boolean addVertex) {
        if (addVertex) {
            this.vertexItems.add(v.x, v.y, v.z, v.n);
        }
        this.mIndices[4].add((short)v.id);
        ++this.numIndices;
    }

    public void addPoly(GeometryBuffer element, float height, float minHeight) {
        int[] index = element.index;
        float[] points = element.points;
        height = ExtrusionUtils.mapGroundScale(height, this.mGroundResolution);
        minHeight = ExtrusionUtils.mapGroundScale(minHeight, this.mGroundResolution);
        boolean complexOutline = false;
        boolean simpleOutline = true;
        int startVertex = this.numVertices;
        int length = 0;
        int ipos = 0;
        int ppos = 0;
        int n = index.length;
        while (ipos < n && (length = index[ipos]) >= 0) {
            if (length == 0) {
                startVertex = this.numVertices;
                simpleOutline = true;
                complexOutline = false;
            } else {
                int len = length;
                if (points[ppos] == points[ppos + len - 2] && points[ppos + 1] == points[ppos + len - 1]) {
                    log.debug("explicit closed poly " + (len -= 2));
                }
                if (len >= 6) {
                    if (simpleOutline && ipos < n - 1 && index[ipos + 1] > 0) {
                        simpleOutline = false;
                    }
                    boolean convex = this.extrudeOutline(points, ppos, len, minHeight, height, simpleOutline);
                    if (simpleOutline && (convex || len <= 8)) {
                        this.addRoofSimple(startVertex, len);
                    } else if (!complexOutline) {
                        complexOutline = true;
                        this.addRoof(startVertex, element, ipos, ppos);
                    }
                }
            }
            ++ipos;
            ppos += length;
        }
    }

    private void addRoofSimple(int startVertex, int len) {
        short first = (short)(startVertex + 1);
        VertexData it = this.mIndices[2];
        len -= 4;
        for (int k = 0; k < len; k += 2) {
            it.add(first, (short)(first + k + 2), (short)(first + k + 4));
        }
        this.numIndices += len / 2 * 3;
    }

    private void addRoof(int startVertex, GeometryBuffer geom, int ipos, int ppos) {
        int[] index = geom.index;
        float[] points = geom.points;
        int numPoints = 0;
        int numRings = 0;
        int n = index.length;
        for (int i = ipos; i < n && index[i] > 0; ++i) {
            numPoints += index[i];
            ++numRings;
        }
        this.numIndices += Tessellator.tessellate(points, ppos, numPoints, index, ipos, numRings, startVertex + 1, this.mIndices[2]);
    }

    private boolean extrudeOutline(float[] points, int pos, int len, float minHeight, float height, boolean convex) {
        boolean addFace = len % 4 != 0;
        int vertexCnt = len + (addFace ? 2 : 0);
        float cx = points[pos + len - 2];
        float cy = points[pos + len - 1];
        float nx = points[pos + 0];
        float ny = points[pos + 1];
        float vx = nx - cx;
        float vy = ny - cy;
        float a = (float)Math.sqrt(vx * vx + vy * vy);
        short mx1 = (short)((1.0f + vy / a) * 127.0f);
        short mxStore = mx1 = (short)(mx1 & 0xFFFFFFFE | (-vx > 0.0f ? 1 : 0));
        short mx2 = 0;
        short h = (short)height;
        short mh = (short)minHeight;
        int even = 0;
        int changeX = 0;
        int changeY = 0;
        int angleSign = 0;
        int vOffset = this.numVertices;
        this.mClipper.clipStart((int)nx, (int)ny);
        int n = vertexCnt + 2;
        for (int i = 2; i < n; i += 2) {
            short vert;
            short c;
            cx = nx;
            cy = ny;
            float ux = vx;
            float uy = vy;
            if (i < len) {
                nx = points[pos + i + 0];
                ny = points[pos + i + 1];
            } else if (i == len) {
                nx = points[pos + 0];
                ny = points[pos + 1];
            } else {
                c = (short)(mx1 | mxStore << 8);
                this.vertexItems.add((short)(cx * MapRenderer.COORD_SCALE), (short)(cy * MapRenderer.COORD_SCALE), mh, c);
                this.vertexItems.add((short)(cx * MapRenderer.COORD_SCALE), (short)(cy * MapRenderer.COORD_SCALE), h, c);
                break;
            }
            vx = nx - cx;
            vy = ny - cy;
            a = (float)Math.sqrt(vx * vx + vy * vy);
            mx2 = (short)((1.0f + vy / a) * 127.0f);
            mx2 = (short)(mx2 & 0xFFFFFFFE | (-vx > 0.0f ? 1 : 0));
            c = even == 0 ? (short)(mx1 | mx2 << 8) : (short)(mx2 | mx1 << 8);
            this.vertexItems.add((short)(cx * MapRenderer.COORD_SCALE), (short)(cy * MapRenderer.COORD_SCALE), mh, c);
            this.vertexItems.add((short)(cx * MapRenderer.COORD_SCALE), (short)(cy * MapRenderer.COORD_SCALE), h, c);
            mx1 = mx2;
            if (convex) {
                float cross;
                if ((ux < 0.0f ? 1 : -1) != (vx < 0.0f ? 1 : -1)) {
                    ++changeX;
                }
                if ((uy < 0.0f ? 1 : -1) != (vy < 0.0f ? 1 : -1)) {
                    ++changeY;
                }
                if (changeX > 2 || changeY > 2) {
                    convex = false;
                }
                if ((cross = ux * vy - uy * vy) > 0.0f) {
                    if (angleSign == -1) {
                        convex = false;
                    }
                    angleSign = 1;
                } else if (cross < 0.0f) {
                    if (angleSign == 1) {
                        convex = false;
                    }
                    angleSign = -1;
                }
            }
            if (this.mClipper.clipNext((int)nx, (int)ny) == 15) {
                ++even;
                even %= 2;
                continue;
            }
            short s = vert = (short)(vOffset + (i - 2));
            vert = (short)(vert + 1);
            short s0 = s;
            short s2 = vert;
            vert = (short)(vert + 1);
            short s1 = s2;
            short s3 = vert;
            vert = (short)(vert + 1);
            short s22 = s3;
            short s4 = vert;
            vert = (short)(vert + 1);
            short s32 = s4;
            if (!addFace && i == len) {
                s22 = (short)(s22 - len);
                s32 = (short)(s32 - len);
            }
            this.mIndices[even].add(s0, s22, s1);
            this.mIndices[even].add(s1, s22, s32);
            this.numIndices += 6;
            ++even;
            even %= 2;
            this.mIndices[3].add(s1, s32);
            this.numIndices += 2;
        }
        this.numVertices += vertexCnt;
        return convex;
    }

    @Override
    public void compile(ShortBuffer vboData, ShortBuffer iboData) {
        if (this.numVertices == 0) {
            return;
        }
        int iOffset = this.indiceOffset = iboData.position();
        for (int i = 0; i <= 4; ++i) {
            if (this.mIndices[i] == null) continue;
            this.idx[i] = this.mIndices[i].compile(iboData);
            this.off[i] = iOffset * 2;
            iOffset += this.idx[i];
        }
        this.vertexOffset = vboData.position() * 2;
        this.vertexItems.compile(vboData);
        this.clear();
    }

    @Override
    public void clear() {
        this.mClipper = null;
        this.releaseVertexPool();
        if (this.mIndices != null) {
            for (int i = 0; i <= 4; ++i) {
                if (this.mIndices[i] == null) continue;
                this.mIndices[i].dispose();
            }
            this.mIndices = null;
            this.vertexItems.dispose();
        }
    }

    public float[] getColors() {
        return this.colors;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    protected void prepare() {
        this.mClipper = null;
        this.releaseVertexPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseVertexPool() {
        if (this.mVertexMap == null) {
            return;
        }
        Pool<Vertex> pool = vertexPool;
        synchronized (pool) {
            vertexPool.releaseAll(this.mVertexMap.releaseItems());
            this.mVertexMap = vertexMapPool.release(this.mVertexMap);
        }
    }

    @Override
    public ExtrusionBucket next() {
        return (ExtrusionBucket)this.next;
    }

    static class Vertex
    extends KeyMap.HashItem {
        short x;
        short y;
        short z;
        short n;
        int id;

        Vertex() {
        }

        public boolean equals(Object obj) {
            Vertex o = (Vertex)obj;
            return this.x == o.x && this.y == o.y && this.z == o.z && this.n == o.n;
        }

        public int hashCode() {
            return 7 + ((this.x << 16 | this.y) ^ (this.n << 16 | this.z)) * 31;
        }

        public Vertex set(short x, short y, short z, short n) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.n = n;
            return this;
        }
    }
}

