/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.light;

import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;

public class ShadowFrameBuffer {
    private final int WIDTH;
    private final int HEIGHT;
    private int defaultWidth;
    private int defaultHeight;
    private int defaultFrameBuffer;
    private int defaultTexture;
    private int fbo;
    private int shadowMap;

    protected ShadowFrameBuffer(int width, int height) {
        this.WIDTH = width;
        this.HEIGHT = height;
        this.updateViewportDimensions();
        this.fbo = ShadowFrameBuffer.createFrameBuffer();
        this.shadowMap = this.createDepthBufferAttachment(width, height);
        this.unbindFrameBuffer();
    }

    protected void cleanUp() {
        GLUtils.glDeleteFrameBuffers(1, new int[]{this.fbo});
        GLUtils.glDeleteTextures(1, new int[]{this.shadowMap});
    }

    protected void unbindFrameBuffer() {
        GLState.bindFramebuffer(this.defaultFrameBuffer);
        GLState.viewport(this.defaultWidth, this.defaultHeight);
    }

    protected int getShadowMap() {
        return this.shadowMap;
    }

    public void bindFrameBuffer() {
        this.updateViewportDimensions();
        GLState.bindTex2D(this.defaultTexture);
        this.defaultFrameBuffer = GLState.getFramebuffer();
        GLState.bindFramebuffer(this.fbo);
        GLState.viewport(this.WIDTH, this.HEIGHT);
    }

    private static int createFrameBuffer() {
        int frameBuffer = GLUtils.glGenFrameBuffers(1)[0];
        GLState.bindFramebuffer(frameBuffer);
        if (GLAdapter.isGL30()) {
            GLUtils.glDrawBuffers(1, new int[]{0});
            GLAdapter.gl30.readBuffer(0);
        }
        return frameBuffer;
    }

    private int createDepthBufferAttachment(int width, int height) {
        this.defaultTexture = GLState.getTexture();
        int[] texture = GLUtils.glGenTextures(1);
        GLState.bindTex2D(texture[0]);
        if (GLAdapter.isGL30()) {
            GLAdapter.gl.texImage2D(3553, 0, 33189, width, height, 0, 6402, 5123, null);
        } else {
            GLAdapter.gl.texImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, null);
        }
        GLAdapter.gl.texParameteri(3553, 10240, 9728);
        GLAdapter.gl.texParameteri(3553, 10241, 9728);
        GLAdapter.gl.texParameteri(3553, 10242, 33071);
        GLAdapter.gl.texParameteri(3553, 10243, 33071);
        if (GLAdapter.isGL30()) {
            GLAdapter.gl.framebufferTexture2D(36160, 36096, 3553, texture[0], 0);
        } else {
            GLAdapter.gl.framebufferTexture2D(36160, 36064, 3553, texture[0], 0);
        }
        return texture[0];
    }

    private void updateViewportDimensions() {
        this.defaultWidth = GLState.getViewportWidth();
        this.defaultHeight = GLState.getViewportHeight();
    }
}

